/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table;

class BeamCalciteSchemaFactory {
    BeamCalciteSchemaFactory() {
    }

    static TableProvider fromInitialEmptySchema(JdbcConnection jdbcConnection) {
        InitialEmptySchema initialEmptySchema = (InitialEmptySchema)jdbcConnection.getCurrentBeamSchema();
        return initialEmptySchema.getTableProvider();
    }

    public static abstract class InitialEmptySchema
    implements Schema {
        public abstract TableProvider getTableProvider();

        public Table getTable(String name) {
            return (Table)InitialEmptySchema.illegal();
        }

        public Set<String> getTableNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public RelProtoDataType getType(String name) {
            return (RelProtoDataType)InitialEmptySchema.illegal();
        }

        public Set<String> getTypeNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public Collection<Function> getFunctions(String name) {
            return (Collection)InitialEmptySchema.illegal();
        }

        public Set<String> getFunctionNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public Schema getSubSchema(String name) {
            return (Schema)InitialEmptySchema.illegal();
        }

        public Set<String> getSubSchemaNames() {
            return Collections.emptySet();
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return (Expression)InitialEmptySchema.illegal();
        }

        public boolean isMutable() {
            return (Boolean)InitialEmptySchema.illegal();
        }

        public Schema snapshot(SchemaVersion version) {
            return (Schema)InitialEmptySchema.illegal();
        }

        private static <T> T illegal() {
            throw new IllegalStateException("Beam JDBC connection has not been initialized");
        }
    }

    public static class Empty
    extends InitialEmptySchema
    implements SchemaFactory {
        private static final TableProvider READ_ONLY_TABLE_PROVIDER = new ReadOnlyTableProvider("empty", (Map<String, BeamSqlTable>)ImmutableMap.of());

        @Override
        public TableProvider getTableProvider() {
            return READ_ONLY_TABLE_PROVIDER;
        }

        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return this;
        }
    }

    public static class AllProviders
    extends InitialEmptySchema
    implements SchemaFactory {
        @Override
        public TableProvider getTableProvider() {
            InMemoryMetaStore metaStore = new InMemoryMetaStore();
            for (TableProvider provider : ServiceLoader.load(TableProvider.class, this.getClass().getClassLoader())) {
                metaStore.registerProvider(provider);
            }
            return metaStore;
        }

        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return this;
        }
    }
}

