/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Location;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.WarningHandler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.JaninoRuntimeException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Java;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Mod;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Scanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.enumerator.Enumerator;

public class Parser {
    private final Scanner scanner;
    private static final String[] MODIFIER_NAMES = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "transient", "volatile", "strictfp"};
    private static final short[] MODIFIER_CODES = new short[]{1, 4, 2, 8, 1024, 16, 256, 32, 128, 64, 2048};
    private static final short[] MUTUALLY_EXCLUSIVE_MODIFIER_CODES = new short[]{7, 1040};
    private static final String[] BASIC_TYPE_NAMES = new String[]{"byte", "short", "char", "int", "long", "float", "double", "boolean"};
    private static final int[] BASIC_TYPE_CODES = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private Scanner.Token nextToken;
    private Scanner.Token nextButOneToken;
    private WarningHandler optionalWarningHandler;

    public Parser(Scanner scanner) {
        this.scanner = scanner;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public Java.CompilationUnit parseCompilationUnit() throws CompileException, IOException {
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(this.location().getFileName());
        if (this.peek("package")) {
            compilationUnit.setPackageDeclaration(this.parsePackageDeclaration());
        }
        while (this.peek("import")) {
            compilationUnit.addImportDeclaration(this.parseImportDeclaration());
        }
        while (!this.peekEof()) {
            if (this.peekRead(";")) continue;
            compilationUnit.addPackageMemberTypeDeclaration(this.parsePackageMemberTypeDeclaration());
        }
        return compilationUnit;
    }

    public Java.PackageDeclaration parsePackageDeclaration() throws CompileException, IOException {
        this.read("package");
        Location loc = this.location();
        String packageName = Parser.join(this.parseQualifiedIdentifier(), ".");
        this.read(";");
        this.verifyStringIsConventionalPackageName(packageName, loc);
        return new Java.PackageDeclaration(loc, packageName);
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclaration() throws CompileException, IOException {
        this.read("import");
        Java.CompilationUnit.ImportDeclaration importDeclaration = this.parseImportDeclarationBody();
        this.read(";");
        return importDeclaration;
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclarationBody() throws CompileException, IOException {
        Location loc = this.location();
        boolean isStatic = this.peekRead("static");
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.readIdentifier());
        while (true) {
            if (!this.peek(".")) {
                String[] identifiers = l.toArray(new String[l.size()]);
                return isStatic ? new Java.CompilationUnit.SingleStaticImportDeclaration(loc, identifiers) : new Java.CompilationUnit.SingleTypeImportDeclaration(loc, identifiers);
            }
            this.read(".");
            if (this.peekRead("*")) {
                String[] identifiers = l.toArray(new String[l.size()]);
                return isStatic ? new Java.CompilationUnit.StaticImportOnDemandDeclaration(loc, identifiers) : new Java.CompilationUnit.TypeImportOnDemandDeclaration(loc, identifiers);
            }
            l.add(this.readIdentifier());
        }
    }

    public String[] parseQualifiedIdentifier() throws CompileException, IOException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.readIdentifier());
        while (this.peek(".") && this.peekNextButOne().type == 1) {
            this.read();
            l.add(this.readIdentifier());
        }
        return l.toArray(new String[l.size()]);
    }

    public Java.PackageMemberTypeDeclaration parsePackageMemberTypeDeclaration() throws CompileException, IOException {
        String optionalDocComment = this.scanner.doc();
        Java.Modifiers modifiers = this.parseModifiers();
        switch (this.read(new String[]{"class", "interface"})) {
            case 0: {
                if (optionalDocComment == null) {
                    this.warning("CDCM", "Class doc comment missing", this.location());
                }
                return (Java.PackageMemberClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.COMPILATION_UNIT);
            }
            case 1: {
                if (optionalDocComment == null) {
                    this.warning("IDCM", "Interface doc comment missing", this.location());
                }
                return (Java.PackageMemberInterfaceDeclaration)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers, InterfaceDeclarationContext.COMPILATION_UNIT);
            }
        }
        throw new IllegalStateException();
    }

    public Java.Modifiers parseModifiers() throws CompileException, IOException {
        short mod = 0;
        ArrayList<Java.Annotation> as = new ArrayList<Java.Annotation>();
        while (true) {
            if (this.peek("@")) {
                as.add(this.parseAnnotation());
                continue;
            }
            int idx = this.peekRead(MODIFIER_NAMES);
            if (idx == -1) break;
            String kw = MODIFIER_NAMES[idx];
            short x = MODIFIER_CODES[idx];
            if ((mod & x) != 0) {
                throw this.compileException("Duplicate modifier \"" + kw + "\"");
            }
            for (short m : MUTUALLY_EXCLUSIVE_MODIFIER_CODES) {
                if ((x & m) == 0 || (mod & m) == 0) continue;
                throw this.compileException("Only one of '" + Mod.shortToString(m) + "' allowed");
            }
            mod = (short)(mod | x);
        }
        return new Java.Modifiers(mod, as.toArray(new Java.Annotation[as.size()]));
    }

    private Java.Annotation parseAnnotation() throws CompileException, IOException {
        this.read("@");
        Java.ReferenceType type = this.parseReferenceType();
        if (!this.peekRead("(")) {
            return new Java.MarkerAnnotation(type);
        }
        if (this.peekIdentifier() == null || !this.peekNextButOne("=")) {
            Java.ElementValue elementValue = this.parseElementValue();
            this.read(")");
            return new Java.SingleElementAnnotation(type, elementValue);
        }
        ArrayList<Java.ElementValuePair> evps = new ArrayList<Java.ElementValuePair>();
        while (!this.peekRead(")")) {
            evps.add(this.parseElementValuePair());
        }
        return new Java.NormalAnnotation(type, evps.toArray(new Java.ElementValuePair[evps.size()]));
    }

    private Java.ElementValuePair parseElementValuePair() throws CompileException, IOException {
        String identifier = this.readIdentifier();
        this.read("=");
        return new Java.ElementValuePair(identifier, this.parseElementValue());
    }

    private Java.ElementValue parseElementValue() throws CompileException, IOException {
        if (this.peek("@")) {
            return this.parseAnnotation();
        }
        if (this.peek("{")) {
            return this.parseElementValueArrayInitializer();
        }
        return this.parseConditionalAndExpression().toRvalueOrCompileException();
    }

    private Java.ElementValue parseElementValueArrayInitializer() throws CompileException, IOException {
        this.read("{");
        ArrayList<Java.ElementValue> evs = new ArrayList<Java.ElementValue>();
        while (!this.peekRead("}")) {
            if (this.peekRead(",")) continue;
            evs.add(this.parseElementValue());
        }
        return new Java.ElementValueArrayInitializer(evs.toArray(new Java.ElementValue[evs.size()]));
    }

    public Java.NamedClassDeclaration parseClassDeclarationRest(String optionalDocComment, Java.Modifiers modifiers, ClassDeclarationContext context) throws CompileException, IOException {
        Java.NamedClassDeclaration namedClassDeclaration;
        Location location = this.location();
        String className = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(className, location);
        Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
        Java.ReferenceType optionalExtendedType = null;
        if (this.peekRead("extends")) {
            optionalExtendedType = this.parseReferenceType();
        }
        Java.Type[] implementedTypes = new Java.ReferenceType[]{};
        if (this.peekRead("implements")) {
            implementedTypes = this.parseReferenceTypeList();
        }
        if (context == ClassDeclarationContext.COMPILATION_UNIT) {
            namedClassDeclaration = new Java.PackageMemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.TYPE_DECLARATION) {
            namedClassDeclaration = new Java.MemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.BLOCK) {
            namedClassDeclaration = new Java.LocalClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else {
            throw new JaninoRuntimeException("SNO: Class declaration in unexpected context " + context);
        }
        this.parseClassBody(namedClassDeclaration);
        return namedClassDeclaration;
    }

    public void parseClassBody(Java.ClassDeclaration classDeclaration) throws CompileException, IOException {
        this.read("{");
        while (!this.peekRead("}")) {
            this.parseClassBodyDeclaration(classDeclaration);
        }
        return;
    }

    public void parseClassBodyDeclaration(Java.ClassDeclaration classDeclaration) throws CompileException, IOException {
        if (this.peekRead(";")) {
            return;
        }
        String optionalDocComment = this.scanner.doc();
        Java.Modifiers modifiers = this.parseModifiers();
        if (this.peek("{")) {
            if ((modifiers.flags & 0xFFFFFFF7) != 0) {
                throw this.compileException("Only modifier \"static\" allowed on initializer");
            }
            Java.Initializer initializer = new Java.Initializer(this.location(), Mod.isStatic(modifiers.flags), this.parseBlock());
            classDeclaration.addInitializer(initializer);
            return;
        }
        if (this.peekRead("void")) {
            Location location = this.location();
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", location);
            }
            String name = this.readIdentifier();
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers, new Java.BasicType(location, 0), name));
            return;
        }
        if (this.peekRead("class")) {
            if (optionalDocComment == null) {
                this.warning("MCDCM", "Member class doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.TYPE_DECLARATION)));
            return;
        }
        if (this.peekRead("interface")) {
            if (optionalDocComment == null) {
                this.warning("MIDCM", "Member interface doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(8), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
            return;
        }
        if (classDeclaration instanceof Java.NamedClassDeclaration && this.peek().value.equals(((Java.NamedClassDeclaration)classDeclaration).getName()) && this.peekNextButOne("(")) {
            if (optionalDocComment == null) {
                this.warning("CDCM", "Constructor doc comment missing", this.location());
            }
            classDeclaration.addConstructor(this.parseConstructorDeclarator(optionalDocComment, modifiers));
            return;
        }
        Java.Type memberType = this.parseType();
        Location location = this.location();
        String memberName = this.readIdentifier();
        if (this.peek("(")) {
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", this.location());
            }
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers, memberType, memberName));
            return;
        }
        if (optionalDocComment == null) {
            this.warning("FDCM", "Field doc comment missing", this.location());
        }
        Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, modifiers, memberType, this.parseFieldDeclarationRest(memberName));
        this.read(";");
        classDeclaration.addFieldDeclaration(fd);
    }

    public Java.InterfaceDeclaration parseInterfaceDeclarationRest(String optionalDocComment, Java.Modifiers modifiers, InterfaceDeclarationContext context) throws CompileException, IOException {
        Java.InterfaceDeclaration interfaceDeclaration;
        Location location = this.location();
        String interfaceName = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(interfaceName, location);
        Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
        Java.Type[] extendedTypes = new Java.ReferenceType[]{};
        if (this.peekRead("extends")) {
            extendedTypes = this.parseReferenceTypeList();
        }
        if (context == InterfaceDeclarationContext.COMPILATION_UNIT) {
            interfaceDeclaration = new Java.PackageMemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, optionalTypeParameters, extendedTypes);
        } else if (context == InterfaceDeclarationContext.NAMED_TYPE_DECLARATION) {
            interfaceDeclaration = new Java.MemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, optionalTypeParameters, extendedTypes);
        } else {
            throw new JaninoRuntimeException("SNO: Interface declaration in unexpected context " + context);
        }
        this.parseInterfaceBody(interfaceDeclaration);
        return interfaceDeclaration;
    }

    public void parseInterfaceBody(Java.InterfaceDeclaration interfaceDeclaration) throws CompileException, IOException {
        this.read("{");
        while (!this.peekRead("}")) {
            if (this.peekRead(";")) continue;
            String optionalDocComment = this.scanner.doc();
            Java.Modifiers modifiers = this.parseModifiers();
            if (this.peekRead("void")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                Location location = this.location();
                String name = this.readIdentifier();
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers.add(1025), new Java.BasicType(location, 0), name));
                continue;
            }
            if (this.peekRead("class")) {
                if (optionalDocComment == null) {
                    this.warning("MCDCM", "Member class doc comment missing", this.location());
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers.add(9), ClassDeclarationContext.TYPE_DECLARATION)));
                continue;
            }
            if (this.peekRead("interface")) {
                if (optionalDocComment == null) {
                    this.warning("MIDCM", "Member interface doc comment missing", this.location());
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(9), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
                continue;
            }
            this.parseTypeArgumentsOpt();
            Java.Type memberType = this.parseType();
            String memberName = this.readIdentifier();
            Location location = this.location();
            if (this.peek("(")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers.add(1025), memberType, memberName));
                continue;
            }
            if (optionalDocComment == null) {
                this.warning("FDCM", "Field doc comment missing", this.location());
            }
            Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, modifiers.add(25), memberType, this.parseFieldDeclarationRest(memberName));
            interfaceDeclaration.addConstantDeclaration(fd);
        }
    }

    public Java.ConstructorDeclarator parseConstructorDeclarator(String optionalDocComment, Java.Modifiers modifiers) throws CompileException, IOException {
        this.readIdentifier();
        Java.FunctionDeclarator.FormalParameters formalParameters = this.parseFormalParameters();
        Java.Type[] thrownExceptions = this.peekRead("throws") ? this.parseReferenceTypeList() : new Java.ReferenceType[]{};
        Location location = this.location();
        this.read("{");
        Java.ConstructorInvocation optionalConstructorInvocation = null;
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        if (this.peek(new String[]{"this", "super", "new", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean"}) != -1 || this.peekLiteral() || this.peekIdentifier() != null) {
            Java.Atom a = this.parseExpression();
            if (a instanceof Java.ConstructorInvocation) {
                this.read(";");
                optionalConstructorInvocation = (Java.ConstructorInvocation)a;
            } else {
                Java.Statement s;
                if (this.peekIdentifier() != null) {
                    Java.Type variableType = a.toTypeOrCompileException();
                    s = new Java.LocalVariableDeclarationStatement(a.getLocation(), new Java.Modifiers(0), variableType, this.parseVariableDeclarators());
                    this.read(";");
                } else {
                    s = new Java.ExpressionStatement(a.toRvalueOrCompileException());
                    this.read(";");
                }
                statements.add(s);
            }
        }
        statements.addAll(this.parseBlockStatements());
        this.read("}");
        return new Java.ConstructorDeclarator(location, optionalDocComment, modifiers, formalParameters, thrownExceptions, optionalConstructorInvocation, statements);
    }

    public Java.MethodDeclarator parseMethodDeclarationRest(String optionalDocComment, Java.Modifiers modifiers, Java.Type type, String name) throws CompileException, IOException {
        List<Java.BlockStatement> optionalStatements;
        Location location = this.location();
        this.verifyIdentifierIsConventionalMethodName(name, location);
        Java.FunctionDeclarator.FormalParameters formalParameters = this.parseFormalParameters();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        Java.Type[] thrownExceptions = this.peekRead("throws") ? this.parseReferenceTypeList() : new Java.ReferenceType[]{};
        if (this.peekRead(";")) {
            if (!Mod.isAbstract(modifiers.flags) && !Mod.isNative(modifiers.flags)) {
                throw this.compileException("Non-abstract, non-native method must have a body");
            }
            optionalStatements = null;
        } else {
            if (Mod.isAbstract(modifiers.flags) || Mod.isNative(modifiers.flags)) {
                throw this.compileException("Abstract or native method must not have a body");
            }
            this.read("{");
            optionalStatements = this.parseBlockStatements();
            this.read("}");
        }
        return new Java.MethodDeclarator(location, optionalDocComment, modifiers, type, name, formalParameters, thrownExceptions, optionalStatements);
    }

    public Java.ArrayInitializerOrRvalue parseVariableInitializer() throws CompileException, IOException {
        if (this.peek("{")) {
            return this.parseArrayInitializer();
        }
        return this.parseExpression().toRvalueOrCompileException();
    }

    public Java.ArrayInitializer parseArrayInitializer() throws CompileException, IOException {
        Location location = this.location();
        this.read("{");
        ArrayList<Java.ArrayInitializerOrRvalue> l = new ArrayList<Java.ArrayInitializerOrRvalue>();
        while (!this.peekRead("}")) {
            l.add(this.parseVariableInitializer());
            if (this.peekRead("}")) break;
            this.read(",");
        }
        return new Java.ArrayInitializer(location, l.toArray(new Java.ArrayInitializerOrRvalue[l.size()]));
    }

    public Java.FunctionDeclarator.FormalParameters parseFormalParameters() throws CompileException, IOException {
        this.read("(");
        if (this.peekRead(")")) {
            return new Java.FunctionDeclarator.FormalParameters();
        }
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        boolean[] hasEllipsis = new boolean[1];
        do {
            if (hasEllipsis[0]) {
                throw this.compileException("Only the last parameter may have an ellipsis");
            }
            l.add(this.parseFormalParameter(hasEllipsis));
        } while (this.read(new String[]{",", ")"}) == 0);
        return new Java.FunctionDeclarator.FormalParameters(this.location(), l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]), hasEllipsis[0]);
    }

    public Java.FunctionDeclarator.FormalParameter parseFormalParameter(boolean[] hasEllipsis) throws CompileException, IOException {
        boolean finaL = this.peekRead("final");
        Java.Type type = this.parseType();
        if (this.peekRead(".")) {
            this.read(".");
            this.read(".");
            hasEllipsis[0] = true;
        }
        Location location = this.location();
        String name = this.readIdentifier();
        this.verifyIdentifierIsConventionalLocalVariableOrParameterName(name, location);
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        return new Java.FunctionDeclarator.FormalParameter(location, finaL, type, name);
    }

    int parseBracketsOpt() throws CompileException, IOException {
        int res = 0;
        while (this.peek("[") && this.peekNextButOne("]")) {
            this.read();
            this.read();
            ++res;
        }
        return res;
    }

    public Java.Block parseMethodBody() throws CompileException, IOException {
        return this.parseBlock();
    }

    public Java.Block parseBlock() throws CompileException, IOException {
        Java.Block block = new Java.Block(this.location());
        this.read("{");
        block.addStatements(this.parseBlockStatements());
        this.read("}");
        return block;
    }

    public List<Java.BlockStatement> parseBlockStatements() throws CompileException, IOException {
        ArrayList<Java.BlockStatement> l = new ArrayList<Java.BlockStatement>();
        while (!(this.peek("}") || this.peek("case") || this.peek("default"))) {
            l.add(this.parseBlockStatement());
        }
        return l;
    }

    public Java.BlockStatement parseBlockStatement() throws CompileException, IOException {
        if (this.peekIdentifier() != null && this.peekNextButOne(":") || this.peek(new String[]{"if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue", "assert"}) != -1 || this.peek(new String[]{"{", ";"}) != -1) {
            return this.parseStatement();
        }
        if (this.peekRead("class")) {
            String optionalDocComment = this.scanner.doc();
            if (optionalDocComment == null) {
                this.warning("LCDCM", "Local class doc comment missing", this.location());
            }
            Java.LocalClassDeclaration lcd = (Java.LocalClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, new Java.Modifiers(), ClassDeclarationContext.BLOCK);
            return new Java.LocalClassDeclarationStatement(lcd);
        }
        if (this.peek(new String[]{"final", "@"}) != -1) {
            Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(this.location(), this.parseModifiers(), this.parseType(), this.parseVariableDeclarators());
            this.read(";");
            return lvds;
        }
        Java.Atom a = this.parseExpression();
        if (this.peekRead(";")) {
            return new Java.ExpressionStatement(a.toRvalueOrCompileException());
        }
        Java.Type variableType = a.toTypeOrCompileException();
        Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(a.getLocation(), new Java.Modifiers(0), variableType, this.parseVariableDeclarators());
        this.read(";");
        return lvds;
    }

    public Java.VariableDeclarator[] parseVariableDeclarators() throws CompileException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        do {
            Java.VariableDeclarator vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalLocalVariableOrParameterName(vd.name, vd.getLocation());
            l.add(vd);
        } while (this.peekRead(","));
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator[] parseFieldDeclarationRest(String name) throws CompileException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        Java.VariableDeclarator vd = this.parseVariableDeclaratorRest(name);
        this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
        l.add(vd);
        while (this.peekRead(",")) {
            vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
            l.add(vd);
        }
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator parseVariableDeclarator() throws CompileException, IOException {
        return this.parseVariableDeclaratorRest(this.readIdentifier());
    }

    public Java.VariableDeclarator parseVariableDeclaratorRest(String name) throws CompileException, IOException {
        Location loc = this.location();
        int brackets = this.parseBracketsOpt();
        Java.ArrayInitializerOrRvalue initializer = null;
        if (this.peekRead("=")) {
            initializer = this.parseVariableInitializer();
        }
        return new Java.VariableDeclarator(loc, name, brackets, initializer);
    }

    public Java.Statement parseStatement() throws CompileException, IOException {
        Java.Block stmt;
        if (this.peekIdentifier() != null && this.peekNextButOne(":")) {
            return this.parseLabeledStatement();
        }
        Java.Statement statement = this.peek("{") ? this.parseBlock() : (this.peek("if") ? this.parseIfStatement() : (this.peek("for") ? this.parseForStatement() : (this.peek("while") ? this.parseWhileStatement() : (this.peek("do") ? this.parseDoStatement() : (this.peek("try") ? this.parseTryStatement() : (this.peek("switch") ? this.parseSwitchStatement() : (this.peek("synchronized") ? this.parseSynchronizedStatement() : (this.peek("return") ? this.parseReturnStatement() : (this.peek("throw") ? this.parseThrowStatement() : (this.peek("break") ? this.parseBreakStatement() : (this.peek("continue") ? this.parseContinueStatement() : (this.peek("assert") ? this.parseAssertStatement() : (stmt = this.peek(";") ? this.parseEmptyStatement() : this.parseExpressionStatement())))))))))))));
        if (stmt == null) {
            throw this.compileException("'" + this.peek().value + "' NYI");
        }
        return stmt;
    }

    public Java.Statement parseLabeledStatement() throws CompileException, IOException {
        String label = this.readIdentifier();
        this.read(":");
        return new Java.LabeledStatement(this.location(), label, this.parseStatement());
    }

    public Java.Statement parseIfStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("if");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        Java.Statement thenStatement = this.parseStatement();
        Java.Statement optionalElseStatement = null;
        if (this.peekRead("else")) {
            optionalElseStatement = this.parseStatement();
        }
        return new Java.IfStatement(location, condition, thenStatement, optionalElseStatement);
    }

    public Java.Statement parseForStatement() throws CompileException, IOException {
        this.read("for");
        Location forLocation = this.location();
        this.read("(");
        Java.Statement optionalInit = null;
        if (!this.peek(";")) {
            if (this.peek(new String[]{"final", "@", "byte", "short", "char", "int", "long", "float", "double", "boolean"}) != -1) {
                Java.Modifiers modifiers = this.parseModifiers();
                Java.Type type = this.parseType();
                if (this.peekIdentifier() != null && this.peekNextButOne(":")) {
                    String name = this.readIdentifier();
                    Location nameLocation = this.location();
                    this.read(":");
                    Java.Rvalue expression = this.parseExpression().toRvalue();
                    this.read(")");
                    return new Java.ForEachStatement(forLocation, new Java.FunctionDeclarator.FormalParameter(nameLocation, Mod.isFinal(modifiers.flags), type, name), expression, this.parseStatement());
                }
                optionalInit = new Java.LocalVariableDeclarationStatement(this.location(), modifiers, type, this.parseVariableDeclarators());
            } else {
                Java.Atom a = this.parseExpression();
                if (this.peekIdentifier() != null) {
                    if (this.peekNextButOne(":")) {
                        String name = this.readIdentifier();
                        Location nameLocation = this.location();
                        this.read(":");
                        Java.Rvalue expression = this.parseExpression().toRvalue();
                        this.read(")");
                        return new Java.ForEachStatement(forLocation, new Java.FunctionDeclarator.FormalParameter(nameLocation, false, a.toTypeOrCompileException(), name), expression, this.parseStatement());
                    }
                    optionalInit = new Java.LocalVariableDeclarationStatement(this.location(), new Java.Modifiers(0), a.toTypeOrCompileException(), this.parseVariableDeclarators());
                } else if (!this.peekRead(",")) {
                    optionalInit = new Java.ExpressionStatement(a.toRvalueOrCompileException());
                } else {
                    ArrayList<Java.BlockStatement> l = new ArrayList<Java.BlockStatement>();
                    l.add(new Java.ExpressionStatement(a.toRvalueOrCompileException()));
                    do {
                        l.add(new Java.ExpressionStatement(this.parseExpression().toRvalueOrCompileException()));
                    } while (this.peekRead(","));
                    Java.Block b = new Java.Block(a.getLocation());
                    b.addStatements(l);
                    optionalInit = b;
                }
            }
        }
        this.read(";");
        Java.Rvalue optionalCondition = null;
        if (!this.peek(";")) {
            optionalCondition = this.parseExpression().toRvalueOrCompileException();
        }
        this.read(";");
        Java.Rvalue[] optionalUpdate = null;
        if (!this.peek(")")) {
            optionalUpdate = this.parseExpressionList();
        }
        this.read(")");
        return new Java.ForStatement(forLocation, optionalInit, optionalCondition, optionalUpdate, this.parseStatement());
    }

    public Java.Statement parseWhileStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("while");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        return new Java.WhileStatement(location, condition, this.parseStatement());
    }

    public Java.Statement parseDoStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("do");
        Java.Statement body = this.parseStatement();
        this.read("while");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        this.read(";");
        return new Java.DoStatement(location, body, condition);
    }

    public Java.Statement parseTryStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("try");
        Java.Block body = this.parseBlock();
        ArrayList<Java.CatchClause> ccs = new ArrayList<Java.CatchClause>();
        while (this.peekRead("catch")) {
            Location loc = this.location();
            this.read("(");
            boolean[] hasEllipsis = new boolean[1];
            Java.FunctionDeclarator.FormalParameter caughtException = this.parseFormalParameter(hasEllipsis);
            if (hasEllipsis[0]) {
                throw this.compileException("Catch clause parameter must not have an ellipsis");
            }
            this.read(")");
            ccs.add(new Java.CatchClause(loc, caughtException, this.parseBlock()));
        }
        Java.Block optionalFinally = null;
        if (this.peekRead("finally")) {
            optionalFinally = this.parseBlock();
        }
        if (ccs.size() == 0 && optionalFinally == null) {
            throw this.compileException("\"try\" statement must have at least one \"catch\" clause or a \"finally\" clause");
        }
        return new Java.TryStatement(location, body, ccs, optionalFinally);
    }

    public Java.Statement parseSwitchStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("switch");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        this.read("{");
        ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup> sbsgs = new ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup>();
        while (!this.peekRead("}")) {
            Location location2 = this.location();
            boolean hasDefaultLabel = false;
            ArrayList<Java.Rvalue> caseLabels = new ArrayList<Java.Rvalue>();
            do {
                if (this.peekRead("case")) {
                    caseLabels.add(this.parseExpression().toRvalueOrCompileException());
                } else if (this.peekRead("default")) {
                    if (hasDefaultLabel) {
                        throw this.compileException("Duplicate \"default\" label");
                    }
                    hasDefaultLabel = true;
                } else {
                    throw this.compileException("\"case\" or \"default\" expected");
                }
                this.read(":");
            } while (this.peek(new String[]{"case", "default"}) != -1);
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = new Java.SwitchStatement.SwitchBlockStatementGroup(location2, caseLabels, hasDefaultLabel, this.parseBlockStatements());
            sbsgs.add(sbsg);
        }
        return new Java.SwitchStatement(location, condition, sbsgs);
    }

    public Java.Statement parseSynchronizedStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("synchronized");
        this.read("(");
        Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        return new Java.SynchronizedStatement(location, expression, this.parseBlock());
    }

    public Java.Statement parseReturnStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("return");
        Java.Rvalue returnValue = this.peek(";") ? null : this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ReturnStatement(location, returnValue);
    }

    public Java.Statement parseThrowStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("throw");
        Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ThrowStatement(location, expression);
    }

    public Java.Statement parseBreakStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("break");
        String optionalLabel = null;
        if (this.peekIdentifier() != null) {
            optionalLabel = this.readIdentifier();
        }
        this.read(";");
        return new Java.BreakStatement(location, optionalLabel);
    }

    public Java.Statement parseContinueStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("continue");
        String optionalLabel = null;
        if (this.peekIdentifier() != null) {
            optionalLabel = this.readIdentifier();
        }
        this.read(";");
        return new Java.ContinueStatement(location, optionalLabel);
    }

    public Java.Statement parseAssertStatement() throws CompileException, IOException {
        this.read("assert");
        Location loc = this.location();
        Java.Rvalue expression1 = this.parseExpression().toRvalueOrCompileException();
        Java.Rvalue optionalExpression2 = this.peekRead(":") ? this.parseExpression().toRvalueOrCompileException() : null;
        this.read(";");
        return new Java.AssertStatement(loc, expression1, optionalExpression2);
    }

    public Java.Statement parseEmptyStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read(";");
        return new Java.EmptyStatement(location);
    }

    public Java.Rvalue[] parseExpressionList() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        do {
            l.add(this.parseExpression().toRvalueOrCompileException());
        } while (this.peekRead(","));
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Type parseType() throws CompileException, IOException {
        int idx = this.peekRead(BASIC_TYPE_NAMES);
        Java.Type res = idx != -1 ? new Java.BasicType(this.location(), BASIC_TYPE_CODES[idx]) : this.parseReferenceType();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            res = new Java.ArrayType(res);
        }
        return res;
    }

    public Java.ReferenceType parseReferenceType() throws CompileException, IOException {
        return new Java.ReferenceType(this.location(), this.parseQualifiedIdentifier(), this.parseTypeArgumentsOpt());
    }

    private Java.TypeParameter[] parseTypeParametersOpt() throws CompileException, IOException {
        if (!this.peekRead("<")) {
            return null;
        }
        ArrayList<Java.TypeParameter> l = new ArrayList<Java.TypeParameter>();
        l.add(this.parseTypeParameter());
        while (this.read(new String[]{",", ">"}) == 0) {
            l.add(this.parseTypeParameter());
        }
        return l.toArray(new Java.TypeParameter[l.size()]);
    }

    private Java.TypeParameter parseTypeParameter() throws CompileException, IOException {
        String name = this.readIdentifier();
        if (this.peekRead("extends")) {
            ArrayList<Java.ReferenceType> bound = new ArrayList<Java.ReferenceType>();
            bound.add(this.parseReferenceType());
            while (this.peekRead("&")) {
                this.parseReferenceType();
            }
            return new Java.TypeParameter(name, bound.toArray(new Java.ReferenceType[bound.size()]));
        }
        return new Java.TypeParameter(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.TypeArgument[] parseTypeArgumentsOpt() throws CompileException, IOException {
        if (!this.peekRead("<")) {
            return null;
        }
        boolean orig = this.scanner.setExpectGreater(true);
        try {
            ArrayList<Java.TypeArgument> typeArguments = new ArrayList<Java.TypeArgument>();
            typeArguments.add(this.parseTypeArgument());
            while (this.read(new String[]{">", ","}) == 1) {
                typeArguments.add(this.parseTypeArgument());
            }
            Java.TypeArgument[] typeArgumentArray = typeArguments.toArray(new Java.TypeArgument[typeArguments.size()]);
            return typeArgumentArray;
        }
        finally {
            this.scanner.setExpectGreater(orig);
        }
    }

    private Java.TypeArgument parseTypeArgument() throws CompileException, IOException {
        if (this.peekRead("?")) {
            return this.peekRead("extends") ? new Java.Wildcard(1, this.parseReferenceType()) : (this.peekRead("super") ? new Java.Wildcard(2, this.parseReferenceType()) : new Java.Wildcard());
        }
        Java.Type t = this.parseType();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            t = new Java.ArrayType(t);
        }
        if (!(t instanceof Java.TypeArgument)) {
            throw this.compileException("'" + t + "' is not a valid type argument");
        }
        return (Java.TypeArgument)((Object)t);
    }

    public Java.ReferenceType[] parseReferenceTypeList() throws CompileException, IOException {
        ArrayList<Java.ReferenceType> l = new ArrayList<Java.ReferenceType>();
        l.add(this.parseReferenceType());
        while (this.peekRead(",")) {
            l.add(this.parseReferenceType());
        }
        return l.toArray(new Java.ReferenceType[l.size()]);
    }

    public Java.Atom parseExpression() throws CompileException, IOException {
        return this.parseAssignmentExpression();
    }

    public Java.Atom parseAssignmentExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalExpression();
        if (this.peek(new String[]{"=", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="}) != -1) {
            Java.Lvalue lhs = a.toLvalueOrCompileException();
            Location location = this.location();
            String operator = this.readOperator();
            Java.Rvalue rhs = this.parseAssignmentExpression().toRvalueOrCompileException();
            return new Java.Assignment(location, lhs, operator, rhs);
        }
        return a;
    }

    public Java.Atom parseConditionalExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalOrExpression();
        if (!this.peekRead("?")) {
            return a;
        }
        Location location = this.location();
        Java.Rvalue lhs = a.toRvalueOrCompileException();
        Java.Rvalue mhs = this.parseExpression().toRvalueOrCompileException();
        this.read(":");
        Java.Rvalue rhs = this.parseConditionalExpression().toRvalueOrCompileException();
        return new Java.ConditionalExpression(location, lhs, mhs, rhs);
    }

    public Java.Atom parseConditionalOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalAndExpression();
        while (this.peekRead("||")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "||", this.parseConditionalAndExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseConditionalAndExpression() throws CompileException, IOException {
        Java.Atom a = this.parseInclusiveOrExpression();
        while (this.peekRead("&&")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "&&", this.parseInclusiveOrExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseInclusiveOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseExclusiveOrExpression();
        while (this.peekRead("|")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "|", this.parseExclusiveOrExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseExclusiveOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseAndExpression();
        while (this.peekRead("^")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "^", this.parseAndExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseAndExpression() throws CompileException, IOException {
        Java.Atom a = this.parseEqualityExpression();
        while (this.peekRead("&")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "&", this.parseEqualityExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseEqualityExpression() throws CompileException, IOException {
        Java.Atom a = this.parseRelationalExpression();
        while (this.peek(new String[]{"==", "!="}) != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseRelationalExpression().toRvalueOrCompileException());
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Java.Atom parseRelationalExpression() throws CompileException, IOException {
        Java.Atom a = this.parseShiftExpression();
        while (true) {
            boolean orig;
            if (this.peekRead("instanceof")) {
                Location location = this.location();
                a = new Java.Instanceof(location, a.toRvalueOrCompileException(), this.parseType());
                continue;
            }
            if (this.peek(new String[]{"<", ">", "<=", ">="}) == -1) break;
            String op = this.read().value;
            if ("<".equals(op) && a instanceof Java.AmbiguousName && this.peek("?")) {
                String[] identifiers = ((Java.AmbiguousName)a).identifiers;
                orig = this.scanner.setExpectGreater(true);
                try {
                    ArrayList<Java.TypeArgument> typeArguments = new ArrayList<Java.TypeArgument>();
                    typeArguments.add(this.parseTypeArgument());
                    while (this.read(new String[]{">", ","}) == 1) {
                        typeArguments.add(this.parseTypeArgument());
                    }
                    Java.ReferenceType referenceType = new Java.ReferenceType(this.location(), identifiers, typeArguments.toArray(new Java.TypeArgument[typeArguments.size()]));
                    return referenceType;
                }
                finally {
                    this.scanner.setExpectGreater(orig);
                }
            }
            Java.Atom rhs = this.parseShiftExpression();
            if ("<".equals(op) && a instanceof Java.AmbiguousName) {
                orig = this.scanner.setExpectGreater(true);
                try {
                    if (this.peek(new String[]{"<", ">", ","}) != -1) {
                        Java.Type ta;
                        String[] identifiers = ((Java.AmbiguousName)a).identifiers;
                        this.parseTypeArgumentsOpt();
                        Java.Type t = rhs.toTypeOrCompileException();
                        if (t instanceof Java.ArrayType) {
                            ta = (Java.ArrayType)t;
                        } else if (t instanceof Java.ReferenceType) {
                            ta = (Java.ReferenceType)t;
                        } else {
                            throw this.compileException("'" + t + "' is not a valid type argument");
                        }
                        ArrayList<Java.TypeArgument> typeArguments = new ArrayList<Java.TypeArgument>();
                        typeArguments.add((Java.TypeArgument)((Object)ta));
                        while (this.read(new String[]{">", ","}) == 1) {
                            typeArguments.add(this.parseTypeArgument());
                        }
                        Java.ReferenceType referenceType = new Java.ReferenceType(this.location(), identifiers, typeArguments.toArray(new Java.TypeArgument[typeArguments.size()]));
                        return referenceType;
                    }
                }
                finally {
                    this.scanner.setExpectGreater(orig);
                }
            }
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), op, rhs.toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseShiftExpression() throws CompileException, IOException {
        Java.Atom a = this.parseAdditiveExpression();
        while (this.peek(new String[]{"<<", ">>", ">>>"}) != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseAdditiveExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseAdditiveExpression() throws CompileException, IOException {
        Java.Atom a = this.parseMultiplicativeExpression();
        while (this.peek(new String[]{"+", "-"}) != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseMultiplicativeExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseMultiplicativeExpression() throws CompileException, IOException {
        Java.Atom a = this.parseUnaryExpression();
        while (this.peek(new String[]{"*", "/", "%"}) != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseUnaryExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseUnaryExpression() throws CompileException, IOException {
        if (this.peek(new String[]{"++", "--"}) != -1) {
            return new Java.Crement(this.location(), this.read().value, this.parseUnaryExpression().toLvalueOrCompileException());
        }
        if (this.peek(new String[]{"+", "-", "~", "!"}) != -1) {
            return new Java.UnaryOperation(this.location(), this.read().value, this.parseUnaryExpression().toRvalueOrCompileException());
        }
        Java.Atom a = this.parsePrimary();
        while (this.peek(new String[]{".", "["}) != -1) {
            a = this.parseSelector(a);
        }
        while (this.peek(new String[]{"++", "--"}) != -1) {
            a = new Java.Crement(this.location(), a.toLvalueOrCompileException(), this.read().value);
        }
        return a;
    }

    public Java.Atom parsePrimary() throws CompileException, IOException {
        if (this.peekRead("(")) {
            if (this.peek(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"}) != -1) {
                Java.Type type = this.parseType();
                int brackets = this.parseBracketsOpt();
                this.read(")");
                for (int i = 0; i < brackets; ++i) {
                    type = new Java.ArrayType(type);
                }
                return new Java.Cast(this.location(), type, this.parseUnaryExpression().toRvalueOrCompileException());
            }
            Java.Atom a = this.parseExpression();
            this.read(")");
            if (this.peekLiteral() || this.peekIdentifier() != null || this.peek(new String[]{"(", "~", "!"}) != -1 || this.peek(new String[]{"this", "super", "new"}) != -1) {
                return new Java.Cast(this.location(), a.toTypeOrCompileException(), this.parseUnaryExpression().toRvalueOrCompileException());
            }
            return new Java.ParenthesizedExpression(a.getLocation(), a.toRvalueOrCompileException());
        }
        if (this.peekLiteral()) {
            return this.parseLiteral();
        }
        if (this.peekIdentifier() != null) {
            Location location = this.location();
            String[] qi = this.parseQualifiedIdentifier();
            if (this.peek("(")) {
                return new Java.MethodInvocation(this.location(), qi.length == 1 ? null : new Java.AmbiguousName(location, qi, qi.length - 1), qi[qi.length - 1], this.parseArguments());
            }
            if (this.peek("[") && this.peekNextButOne("]")) {
                Java.Type res = new Java.ReferenceType(location, qi, null);
                int brackets = this.parseBracketsOpt();
                for (int i = 0; i < brackets; ++i) {
                    res = new Java.ArrayType(res);
                }
                if (this.peek(".") && this.peekNextButOne("class")) {
                    this.read();
                    Location location2 = this.location();
                    this.read();
                    return new Java.ClassLiteral(location2, res);
                }
                return res;
            }
            return new Java.AmbiguousName(location, qi);
        }
        if (this.peekRead("this")) {
            Location location = this.location();
            if (this.peek("(")) {
                return new Java.AlternateConstructorInvocation(location, this.parseArguments());
            }
            return new Java.ThisReference(location);
        }
        if (this.peekRead("super")) {
            if (this.peek("(")) {
                return new Java.SuperConstructorInvocation(this.location(), null, this.parseArguments());
            }
            this.read(".");
            String name = this.readIdentifier();
            if (this.peek("(")) {
                return new Java.SuperclassMethodInvocation(this.location(), name, this.parseArguments());
            }
            return new Java.SuperclassFieldAccessExpression(this.location(), null, name);
        }
        if (this.peekRead("new")) {
            Location location = this.location();
            Java.Type type = this.parseType();
            if (type instanceof Java.ArrayType) {
                return new Java.NewInitializedArray(location, (Java.ArrayType)type, this.parseArrayInitializer());
            }
            if (type instanceof Java.ReferenceType && this.peek("(")) {
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peek("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, null, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location, (Java.Rvalue)null, type, arguments);
            }
            return new Java.NewArray(location, type, this.parseDimExprs(), this.parseBracketsOpt());
        }
        if (this.peek(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"}) != -1) {
            Java.Type res = this.parseType();
            int brackets = this.parseBracketsOpt();
            for (int i = 0; i < brackets; ++i) {
                res = new Java.ArrayType(res);
            }
            if (this.peek(".") && this.peekNextButOne("class")) {
                this.read();
                Location location = this.location();
                this.read();
                return new Java.ClassLiteral(location, res);
            }
            return res;
        }
        if (this.peekRead("void")) {
            if (this.peek(".") && this.peekNextButOne("class")) {
                this.read();
                Location location = this.location();
                this.read();
                return new Java.ClassLiteral(location, new Java.BasicType(location, 0));
            }
            throw this.compileException("\"void\" encountered in wrong context");
        }
        throw this.compileException("Unexpected token \"" + this.peek().value + "\" in primary");
    }

    public Java.Atom parseSelector(Java.Atom atom) throws CompileException, IOException {
        if (this.peekRead(".")) {
            if (this.peek().type == 1) {
                String identifier = this.readIdentifier();
                if (this.peek("(")) {
                    return new Java.MethodInvocation(this.location(), atom.toRvalueOrCompileException(), identifier, this.parseArguments());
                }
                return new Java.FieldAccessExpression(this.location(), atom.toRvalueOrCompileException(), identifier);
            }
            if (this.peekRead("this")) {
                Location location = this.location();
                return new Java.QualifiedThisReference(location, atom.toTypeOrCompileException());
            }
            if (this.peekRead("super")) {
                Location location = this.location();
                if (this.peek("(")) {
                    return new Java.SuperConstructorInvocation(location, atom.toRvalueOrCompileException(), this.parseArguments());
                }
                this.read(".");
                String identifier = this.readIdentifier();
                if (this.peek("(")) {
                    throw this.compileException("Qualified superclass method invocation NYI");
                }
                return new Java.SuperclassFieldAccessExpression(location, atom.toTypeOrCompileException(), identifier);
            }
            if (this.peekRead("new")) {
                Java.Rvalue lhs = atom.toRvalue();
                Location location = this.location();
                String identifier = this.readIdentifier();
                Java.RvalueMemberType type = new Java.RvalueMemberType(location, lhs, identifier);
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peek("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, lhs, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location, lhs, type, arguments);
            }
            if (this.peekRead("class")) {
                Location location = this.location();
                return new Java.ClassLiteral(location, atom.toTypeOrCompileException());
            }
            throw this.compileException("Unexpected selector '" + this.peek().value + "' after \".\"");
        }
        if (this.peekRead("[")) {
            Location location = this.location();
            Java.Rvalue index = this.parseExpression().toRvalueOrCompileException();
            this.read("]");
            return new Java.ArrayAccessExpression(location, atom.toRvalueOrCompileException(), index);
        }
        throw this.compileException("Unexpected token '" + this.peek().value + "' in selector");
    }

    public Java.Rvalue[] parseDimExprs() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        l.add(this.parseDimExpr());
        while (this.peek("[") && !this.peekNextButOne("]")) {
            l.add(this.parseDimExpr());
        }
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Rvalue parseDimExpr() throws CompileException, IOException {
        this.read("[");
        Java.Rvalue res = this.parseExpression().toRvalueOrCompileException();
        this.read("]");
        return res;
    }

    public Java.Rvalue[] parseArguments() throws CompileException, IOException {
        this.read("(");
        if (this.peekRead(")")) {
            return new Java.Rvalue[0];
        }
        Java.Rvalue[] arguments = this.parseArgumentList();
        this.read(")");
        return arguments;
    }

    public Java.Rvalue[] parseArgumentList() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        do {
            l.add(this.parseExpression().toRvalueOrCompileException());
        } while (this.peekRead(","));
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Rvalue parseLiteral() throws CompileException, IOException {
        Scanner.Token t = this.read();
        switch (t.type) {
            case 3: {
                return new Java.IntegerLiteral(t.getLocation(), t.value);
            }
            case 4: {
                return new Java.FloatingPointLiteral(t.getLocation(), t.value);
            }
            case 5: {
                return new Java.BooleanLiteral(t.getLocation(), t.value);
            }
            case 6: {
                return new Java.CharacterLiteral(t.getLocation(), t.value);
            }
            case 7: {
                return new Java.StringLiteral(t.getLocation(), t.value);
            }
            case 8: {
                return new Java.NullLiteral(t.getLocation(), t.value);
            }
        }
        throw this.compileException("Literal expected");
    }

    public Java.Statement parseExpressionStatement() throws CompileException, IOException {
        Java.Rvalue rv = this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ExpressionStatement(rv);
    }

    public Location location() {
        return this.scanner.location();
    }

    public Scanner.Token peek() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.scanner.produce();
        }
        return this.nextToken;
    }

    public Scanner.Token peekNextButOne() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.scanner.produce();
        }
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.scanner.produce();
        }
        return this.nextButOneToken;
    }

    public Scanner.Token read() throws CompileException, IOException {
        if (this.nextToken == null) {
            return this.scanner.produce();
        }
        Scanner.Token result = this.nextToken;
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = null;
        return result;
    }

    public boolean peek(String suspected) throws CompileException, IOException {
        return this.peek().value.equals(suspected);
    }

    public int peek(String[] suspected) throws CompileException, IOException {
        return Parser.indexOf(suspected, this.peek().value);
    }

    public int peek(int[] suspected) throws CompileException, IOException {
        return Parser.indexOf(suspected, this.peek().type);
    }

    public boolean peekNextButOne(String suspected) throws CompileException, IOException {
        return this.peekNextButOne().value.equals(suspected);
    }

    public void read(String expected) throws CompileException, IOException {
        String s = this.read().value;
        if (!s.equals(expected)) {
            throw this.compileException("'" + expected + "' expected instead of '" + s + "'");
        }
    }

    public int read(String[] expected) throws CompileException, IOException {
        String s = this.read().value;
        int idx = Parser.indexOf(expected, s);
        if (idx == -1) {
            throw this.compileException("One of '" + Parser.join(expected, " ") + "' expected instead of '" + s + "'");
        }
        return idx;
    }

    public boolean peekRead(String suspected) throws CompileException, IOException {
        if (this.nextToken == null) {
            Scanner.Token t = this.scanner.produce();
            if (t.value.equals(suspected)) {
                return true;
            }
            this.nextToken = t;
            return false;
        }
        if (!this.nextToken.value.equals(suspected)) {
            return false;
        }
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = null;
        return true;
    }

    public int peekRead(String[] values) throws CompileException, IOException {
        if (this.nextToken == null) {
            Scanner.Token t = this.scanner.produce();
            int idx = Parser.indexOf(values, t.value);
            if (idx != -1) {
                return idx;
            }
            this.nextToken = t;
            return -1;
        }
        int idx = Parser.indexOf(values, this.nextToken.value);
        if (idx == -1) {
            return -1;
        }
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = null;
        return idx;
    }

    public boolean peekEof() throws CompileException, IOException {
        return this.peek().type == 0;
    }

    public String peekIdentifier() throws CompileException, IOException {
        Scanner.Token t = this.peek();
        return t.type == 1 ? t.value : null;
    }

    public boolean peekLiteral() throws CompileException, IOException {
        return this.peek(new int[]{3, 4, 5, 6, 7, 8}) != -1;
    }

    public String readIdentifier() throws CompileException, IOException {
        Scanner.Token t = this.read();
        if (t.type != 1) {
            throw this.compileException("Identifier expected instead of '" + t.value + "'");
        }
        return t.value;
    }

    public String readOperator() throws CompileException, IOException {
        Scanner.Token t = this.read();
        if (t.type != 9) {
            throw this.compileException("Operator expected instead of '" + t.value + "'");
        }
        return t.value;
    }

    private static int indexOf(String[] strings, String subject) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(subject)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(int[] values, int subject) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != subject) continue;
            return i;
        }
        return -1;
    }

    private void verifyStringIsConventionalPackageName(String s, Location loc) throws CompileException {
        if (!Character.isLowerCase(s.charAt(0))) {
            this.warning("UPN", "Package name \"" + s + "\" does not begin with a lower-case letter (see JLS7 6.8.1)", loc);
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) || c == '_' || c == '.') continue;
            this.warning("PPN", "Poorly chosen package name \"" + s + "\" contains bad character '" + c + "'", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalClassOrInterfaceName(String id, Location loc) throws CompileException {
        if (!Character.isUpperCase(id.charAt(0))) {
            this.warning("UCOIN1", "Class or interface name \"" + id + "\" does not begin with an upper-case letter (see JLS7 6.8.2)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UCOIN", "Class or interface name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.2)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalMethodName(String id, Location loc) throws CompileException {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("UMN1", "Method name \"" + id + "\" does not begin with a lower-case letter (see JLS7 6.8.3)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UMN", "Method name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.3)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalFieldName(String id, Location loc) throws CompileException {
        if (Character.isUpperCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isUpperCase(c) || Character.isDigit(c) || c == '_') continue;
                this.warning("UCN", "Constant name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.5)", loc);
                return;
            }
        } else if (Character.isLowerCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c)) continue;
                this.warning("UFN", "Field name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.4)", loc);
                return;
            }
        } else {
            this.warning("UFN1", "\"" + id + "\" is neither a conventional field name (JLS7 6.8.4) nor a conventional constant name (JLS7 6.8.5)", loc);
        }
    }

    private void verifyIdentifierIsConventionalLocalVariableOrParameterName(String id, Location loc) throws CompileException {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("ULVN1", "Local variable name \"" + id + "\" does not begin with a lower-case letter (see JLS7 6.8.6)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("ULVN", "Local variable name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.6)", loc);
            return;
        }
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle, String message, Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    protected final CompileException compileException(String message) {
        return new CompileException(message, this.location());
    }

    private static String join(String[] sa, String separator) {
        if (sa == null) {
            return "(null)";
        }
        if (sa.length == 0) {
            return "(zero length array)";
        }
        StringBuilder sb = new StringBuilder(sa[0]);
        for (int i = 1; i < sa.length; ++i) {
            sb.append(separator).append(sa[i]);
        }
        return sb.toString();
    }

    public static final class InterfaceDeclarationContext
    extends Enumerator {
        public static final InterfaceDeclarationContext NAMED_TYPE_DECLARATION = new InterfaceDeclarationContext("named_type_declaration");
        public static final InterfaceDeclarationContext COMPILATION_UNIT = new InterfaceDeclarationContext("compilation_unit");

        private InterfaceDeclarationContext(String name) {
            super(name);
        }
    }

    public static final class ClassDeclarationContext
    extends Enumerator {
        public static final ClassDeclarationContext BLOCK = new ClassDeclarationContext("block");
        public static final ClassDeclarationContext TYPE_DECLARATION = new ClassDeclarationContext("type_declaration");
        public static final ClassDeclarationContext COMPILATION_UNIT = new ClassDeclarationContext("compilation_unit");

        private ClassDeclarationContext(String name) {
            super(name);
        }
    }
}

