/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NameSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;

public class NameMultimap<V> {
    private final NavigableMap<String, List<V>> map;

    private NameMultimap(NavigableMap<String, List<V>> map) {
        this.map = map;
        assert (this.map.comparator() == NameSet.COMPARATOR);
    }

    public NameMultimap() {
        this(new TreeMap<String, List<V>>(NameSet.COMPARATOR));
    }

    public void put(String name, V v) {
        ArrayList<V> list = (ArrayList<V>)this.map.get(name);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(name, list);
        }
        list.add(v);
    }

    public Collection<Map.Entry<String, V>> range(String name, boolean caseSensitive) {
        if (caseSensitive) {
            List list = (List)this.map.get(name);
            if (list != null && !list.isEmpty()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object v : list) {
                    builder.add(Pair.of(name, v));
                }
                return builder.build();
            }
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        NavigableMap<String, List<V>> m = this.map.subMap(name.toUpperCase(Locale.ROOT), true, name.toLowerCase(Locale.ROOT), true);
        for (Map.Entry entry : m.entrySet()) {
            for (Object v : (List)entry.getValue()) {
                builder.add(Pair.of(entry.getKey(), v));
            }
        }
        return builder.build();
    }

    public boolean containsKey(String name, boolean caseSensitive) {
        return !this.range(name, caseSensitive).isEmpty();
    }

    public NavigableMap<String, List<V>> map() {
        return this.map;
    }
}

