/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.TimestampString;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimestampLiteral(TimestampString ts, int precision, boolean hasTimeZone, SqlParserPos pos) {
        super(ts, hasTimeZone, SqlTypeName.TIMESTAMP, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((TimestampString)this.value, this.precision, this.hasTimeZone, pos);
    }

    @Override
    public String toString() {
        return "TIMESTAMP '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        TimestampString ts = this.getTimestamp();
        if (this.precision > 0) {
            ts = ts.round(this.precision);
        }
        return ts.toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

