/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.BiMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.HashBiMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Multimap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Sets;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptMaterialization;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptMaterializations;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Filter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Join;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Project;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.TableScan;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexShuttle;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexTableInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.graph.DirectedGraph;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.mapping.Mapping;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.mapping.MappingType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.mapping.Mappings;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.trace.CalciteLogger;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaterializedViewRule
extends RelOptRule {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger(AbstractMaterializedViewRule.class));
    public static final MaterializedViewProjectFilterRule INSTANCE_PROJECT_FILTER = new MaterializedViewProjectFilterRule(RelFactories.LOGICAL_BUILDER, true);
    public static final MaterializedViewOnlyFilterRule INSTANCE_FILTER = new MaterializedViewOnlyFilterRule(RelFactories.LOGICAL_BUILDER, true);
    public static final MaterializedViewProjectJoinRule INSTANCE_PROJECT_JOIN = new MaterializedViewProjectJoinRule(RelFactories.LOGICAL_BUILDER, true);
    public static final MaterializedViewOnlyJoinRule INSTANCE_JOIN = new MaterializedViewOnlyJoinRule(RelFactories.LOGICAL_BUILDER, true);
    public static final MaterializedViewProjectAggregateRule INSTANCE_PROJECT_AGGREGATE = new MaterializedViewProjectAggregateRule(RelFactories.LOGICAL_BUILDER, true);
    public static final MaterializedViewOnlyAggregateRule INSTANCE_AGGREGATE = new MaterializedViewOnlyAggregateRule(RelFactories.LOGICAL_BUILDER, true);
    private final boolean generateUnionRewriting;

    protected AbstractMaterializedViewRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting) {
        super(operand, relBuilderFactory, description);
        this.generateUnionRewriting = generateUnionRewriting;
    }

    protected void perform(RelOptRuleCall call, Project topProject, RelNode node) {
        ImmutableList<RelOptMaterialization> materializations;
        RexBuilder rexBuilder = node.getCluster().getRexBuilder();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPlanner planner = call.getPlanner();
        RexSimplify simplify = new RexSimplify(rexBuilder, true, planner.getExecutor() != null ? planner.getExecutor() : RexUtil.EXECUTOR);
        ImmutableList<RelOptMaterialization> immutableList = materializations = planner instanceof VolcanoPlanner ? ((VolcanoPlanner)planner).getMaterializations() : ImmutableList.of();
        if (!materializations.isEmpty()) {
            if (!this.isValidPlan(topProject, node, mq)) {
                return;
            }
            List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(node, materializations);
            if (!applicableMaterializations.isEmpty()) {
                Set<RexTableInputRef.RelTableRef> queryTableRefs = mq.getTableReferences(node);
                if (queryTableRefs == null) {
                    return;
                }
                RelOptPredicateList queryPredicateList = mq.getAllPredicates(node);
                if (queryPredicateList == null) {
                    return;
                }
                RexNode pred = simplify.simplify(RexUtil.composeConjunction(rexBuilder, queryPredicateList.pulledUpPredicates, false));
                Triple<RexNode, RexNode, RexNode> queryPreds = AbstractMaterializedViewRule.splitPredicates(rexBuilder, pred);
                EquivalenceClasses qEC = new EquivalenceClasses();
                for (RexNode conj : RelOptUtil.conjunctions((RexNode)queryPreds.getLeft())) {
                    assert (conj.isA(SqlKind.EQUALS));
                    RexCall equiCond = (RexCall)conj;
                    qEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                }
                for (RelOptMaterialization materialization : applicableMaterializations) {
                    MatchModality matchModality;
                    RelOptPredicateList viewPredicateList;
                    RelNode viewNode;
                    Project topViewProject;
                    RelNode view = materialization.tableRel;
                    if (materialization.queryRel instanceof Project) {
                        topViewProject = (Project)materialization.queryRel;
                        viewNode = topViewProject.getInput();
                    } else {
                        topViewProject = null;
                        viewNode = materialization.queryRel;
                    }
                    if (!this.isValidPlan(topViewProject, viewNode, mq) || (viewPredicateList = mq.getAllPredicates(viewNode)) == null) continue;
                    RexNode viewPred = simplify.simplify(RexUtil.composeConjunction(rexBuilder, viewPredicateList.pulledUpPredicates, false));
                    Triple<RexNode, RexNode, RexNode> viewPreds = AbstractMaterializedViewRule.splitPredicates(rexBuilder, viewPred);
                    Set<RexTableInputRef.RelTableRef> viewTableRefs = mq.getTableReferences(viewNode);
                    if (viewTableRefs == null) {
                        return;
                    }
                    ArrayListMultimap<RexTableInputRef, RexTableInputRef> compensationEquiColumns = ArrayListMultimap.create();
                    if (!queryTableRefs.equals(viewTableRefs)) {
                        if (viewTableRefs.containsAll(queryTableRefs)) {
                            matchModality = MatchModality.QUERY_PARTIAL;
                            EquivalenceClasses vEC = new EquivalenceClasses();
                            for (RexNode conj : RelOptUtil.conjunctions((RexNode)viewPreds.getLeft())) {
                                assert (conj.isA(SqlKind.EQUALS));
                                RexCall equiCond = (RexCall)conj;
                                vEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                            }
                            if (!AbstractMaterializedViewRule.compensatePartial(viewTableRefs, vEC, queryTableRefs, compensationEquiColumns)) {
                                continue;
                            }
                        } else {
                            if (!queryTableRefs.containsAll(viewTableRefs)) continue;
                            matchModality = MatchModality.VIEW_PARTIAL;
                            ViewPartialRewriting partialRewritingResult = this.compensateViewPartial(call.builder(), rexBuilder, mq, view, topProject, node, queryTableRefs, qEC, topViewProject, viewNode, viewTableRefs);
                            if (partialRewritingResult == null) continue;
                            view = partialRewritingResult.newView;
                            topViewProject = partialRewritingResult.newTopViewProject;
                            viewNode = partialRewritingResult.newViewNode;
                        }
                    } else {
                        matchModality = MatchModality.COMPLETE;
                    }
                    ArrayListMultimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> multiMapTables = ArrayListMultimap.create();
                    for (RexTableInputRef.RelTableRef queryTableRef1 : queryTableRefs) {
                        for (RexTableInputRef.RelTableRef queryTableRef2 : queryTableRefs) {
                            if (!queryTableRef1.getQualifiedName().equals(queryTableRef2.getQualifiedName())) continue;
                            multiMapTables.put(queryTableRef1, queryTableRef2);
                        }
                    }
                    List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> flatListMappings = AbstractMaterializedViewRule.generateTableMappings(multiMapTables);
                    for (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping : flatListMappings) {
                        RelNode result;
                        RexNode otherCompensationPred;
                        RexNode compensationColumnsEquiPred;
                        EquivalenceClasses currQEC = EquivalenceClasses.copy(qEC);
                        if (matchModality == MatchModality.QUERY_PARTIAL) {
                            for (Map.Entry e : compensationEquiColumns.entries()) {
                                RexTableInputRef.RelTableRef queryTableRef = (RexTableInputRef.RelTableRef)queryToViewTableMapping.inverse().get(((RexTableInputRef)e.getKey()).getTableRef());
                                RexTableInputRef queryColumnRef = RexTableInputRef.of(queryTableRef, ((RexTableInputRef)e.getKey()).getIndex(), ((RexTableInputRef)e.getKey()).getType());
                                currQEC.addEquivalenceClass(queryColumnRef, (RexTableInputRef)e.getValue());
                                queryToViewTableMapping.put(((RexTableInputRef)e.getValue()).getTableRef(), ((RexTableInputRef)e.getValue()).getTableRef());
                            }
                        }
                        RexNode viewColumnsEquiPred = RexUtil.swapTableReferences(rexBuilder, (RexNode)viewPreds.getLeft(), queryToViewTableMapping.inverse());
                        EquivalenceClasses queryBasedVEC = new EquivalenceClasses();
                        for (RexNode conj : RelOptUtil.conjunctions(viewColumnsEquiPred)) {
                            assert (conj.isA(SqlKind.EQUALS));
                            RexCall equiCond = (RexCall)conj;
                            queryBasedVEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                        }
                        Triple<RexNode, RexNode, RexNode> compensationPreds = AbstractMaterializedViewRule.computeCompensationPredicates(rexBuilder, simplify, currQEC, queryPreds, queryBasedVEC, viewPreds, queryToViewTableMapping);
                        if (compensationPreds == null && this.generateUnionRewriting) {
                            RelNode unionInputView;
                            compensationPreds = AbstractMaterializedViewRule.computeCompensationPredicates(rexBuilder, simplify, queryBasedVEC, viewPreds, currQEC, queryPreds, queryToViewTableMapping.inverse());
                            if (compensationPreds == null) continue;
                            compensationColumnsEquiPred = (RexNode)compensationPreds.getLeft();
                            otherCompensationPred = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationPreds.getMiddle(), compensationPreds.getRight()), false);
                            assert (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue());
                            RelNode unionInputQuery = this.rewriteQuery(call.builder(), rexBuilder, simplify, mq, compensationColumnsEquiPred, otherCompensationPred, topProject, node, queryToViewTableMapping, queryBasedVEC, currQEC);
                            if (unionInputQuery == null || (unionInputView = this.rewriteView(call.builder(), rexBuilder, mq, matchModality, true, view, topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC)) == null || (result = this.createUnion(call.builder(), rexBuilder, topProject, unionInputQuery, unionInputView)) == null) continue;
                            call.transformTo(result);
                            continue;
                        }
                        if (compensationPreds == null) continue;
                        compensationColumnsEquiPred = (RexNode)compensationPreds.getLeft();
                        otherCompensationPred = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationPreds.getMiddle(), compensationPreds.getRight()), false);
                        if (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue()) {
                            List<RexNode> viewExprs;
                            List<RexNode> list = viewExprs = topViewProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, view) : topViewProject.getChildExps();
                            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, viewNode, viewExprs, queryToViewTableMapping.inverse(), queryBasedVEC, false, compensationColumnsEquiPred)) == null || !otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, viewNode, viewExprs, queryToViewTableMapping.inverse(), currQEC, true, otherCompensationPred)) == null) continue;
                        }
                        RexNode viewCompensationPred = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred), false);
                        RelBuilder builder = call.builder();
                        builder.push(view);
                        if (!viewCompensationPred.isAlwaysTrue()) {
                            builder.filter(simplify.simplify(viewCompensationPred));
                        }
                        if ((result = this.rewriteView(builder, rexBuilder, mq, matchModality, false, builder.build(), topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC)) == null) continue;
                        call.transformTo(result);
                    }
                }
            }
        }
    }

    protected abstract boolean isValidPlan(Project var1, RelNode var2, RelMetadataQuery var3);

    protected abstract ViewPartialRewriting compensateViewPartial(RelBuilder var1, RexBuilder var2, RelMetadataQuery var3, RelNode var4, Project var5, RelNode var6, Set<RexTableInputRef.RelTableRef> var7, EquivalenceClasses var8, Project var9, RelNode var10, Set<RexTableInputRef.RelTableRef> var11);

    protected abstract RelNode rewriteQuery(RelBuilder var1, RexBuilder var2, RexSimplify var3, RelMetadataQuery var4, RexNode var5, RexNode var6, Project var7, RelNode var8, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var9, EquivalenceClasses var10, EquivalenceClasses var11);

    protected abstract RelNode createUnion(RelBuilder var1, RexBuilder var2, RelNode var3, RelNode var4, RelNode var5);

    protected abstract RelNode rewriteView(RelBuilder var1, RexBuilder var2, RelMetadataQuery var3, MatchModality var4, boolean var5, RelNode var6, Project var7, RelNode var8, Project var9, RelNode var10, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var11, EquivalenceClasses var12);

    private static List<RexNode> extractReferences(RexBuilder rexBuilder, RelNode node) {
        ImmutableList.Builder exprs = ImmutableList.builder();
        if (node instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)node;
            for (int i = 0; i < aggregate.getGroupCount(); ++i) {
                exprs.add(rexBuilder.makeInputRef(aggregate, i));
            }
        } else {
            for (int i = 0; i < node.getRowType().getFieldCount(); ++i) {
                exprs.add(rexBuilder.makeInputRef(node, i));
            }
        }
        return exprs.build();
    }

    private static List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> generateTableMappings(Multimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> multiMapTables) {
        if (multiMapTables.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableCollection result = ImmutableList.of(HashBiMap.create());
        for (Map.Entry<RexTableInputRef.RelTableRef, Collection<RexTableInputRef.RelTableRef>> e : multiMapTables.asMap().entrySet()) {
            if (e.getValue().size() == 1) {
                RexTableInputRef.RelTableRef target = e.getValue().iterator().next();
                for (BiMap m : result) {
                    m.put(e.getKey(), target);
                }
                continue;
            }
            ImmutableList.Builder newResult = ImmutableList.builder();
            for (RexTableInputRef.RelTableRef target : e.getValue()) {
                for (BiMap m : result) {
                    if (m.containsValue(target)) continue;
                    HashBiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> newM = HashBiMap.create(m);
                    newM.put(e.getKey(), target);
                    newResult.add(newM);
                }
            }
            result = newResult.build();
        }
        return result;
    }

    private static boolean isValidRelNodePlan(RelNode node, RelMetadataQuery mq) {
        Multimap<Class<? extends RelNode>, RelNode> m = mq.getNodeTypes(node);
        for (Class<? extends RelNode> c : m.keySet()) {
            if (TableScan.class.isAssignableFrom(c) || Project.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || Join.class.isAssignableFrom(c)) continue;
            return false;
        }
        return true;
    }

    private static Triple<RexNode, RexNode, RexNode> splitPredicates(RexBuilder rexBuilder, RexNode pred) {
        ArrayList<RexNode> equiColumnsPreds = new ArrayList<RexNode>();
        ArrayList<RexNode> rangePreds = new ArrayList<RexNode>();
        ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
        block4: for (RexNode e : RelOptUtil.conjunctions(pred)) {
            switch (e.getKind()) {
                case EQUALS: {
                    RexCall eqCall = (RexCall)e;
                    if (RexUtil.isReferenceOrAccess(eqCall.getOperands().get(0), false) && RexUtil.isReferenceOrAccess(eqCall.getOperands().get(1), false)) {
                        equiColumnsPreds.add(e);
                        continue block4;
                    }
                    if (RexUtil.isReferenceOrAccess(eqCall.getOperands().get(0), false) && RexUtil.isConstant(eqCall.getOperands().get(1)) || RexUtil.isReferenceOrAccess(eqCall.getOperands().get(1), false) && RexUtil.isConstant(eqCall.getOperands().get(0))) {
                        rangePreds.add(e);
                        continue block4;
                    }
                    residualPreds.add(e);
                    continue block4;
                }
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall rangeCall = (RexCall)e;
                    if (RexUtil.isReferenceOrAccess(rangeCall.getOperands().get(0), false) && RexUtil.isConstant(rangeCall.getOperands().get(1)) || RexUtil.isReferenceOrAccess(rangeCall.getOperands().get(1), false) && RexUtil.isConstant(rangeCall.getOperands().get(0))) {
                        rangePreds.add(e);
                        continue block4;
                    }
                    residualPreds.add(e);
                    continue block4;
                }
            }
            residualPreds.add(e);
        }
        return ImmutableTriple.of((Object)RexUtil.composeConjunction(rexBuilder, equiColumnsPreds, false), (Object)RexUtil.composeConjunction(rexBuilder, rangePreds, false), (Object)RexUtil.composeConjunction(rexBuilder, residualPreds, false));
    }

    private static boolean compensatePartial(Set<RexTableInputRef.RelTableRef> sourceTableRefs, EquivalenceClasses sourceEC, Set<RexTableInputRef.RelTableRef> targetTableRefs, Multimap<RexTableInputRef, RexTableInputRef> compensationEquiColumns) {
        DefaultDirectedGraph<RexTableInputRef.RelTableRef, Edge> graph = DefaultDirectedGraph.create(Edge.FACTORY);
        ArrayListMultimap<List<String>, RexTableInputRef.RelTableRef> tableVNameToTableRefs = ArrayListMultimap.create();
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : sourceTableRefs) {
            graph.addVertex(tRef);
            tableVNameToTableRefs.put(tRef.getQualifiedName(), tRef);
            if (targetTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
            List<RelReferentialConstraint> constraints = tRef.getTable().getReferentialConstraints();
            for (RelReferentialConstraint constraint : constraints) {
                Collection parentTableRefs = tableVNameToTableRefs.get(constraint.getTargetQualifiedName());
                for (RexTableInputRef.RelTableRef parentTRef : parentTableRefs) {
                    boolean canBeRewritten = true;
                    ArrayListMultimap<RexTableInputRef, RexTableInputRef> equiColumns = ArrayListMultimap.create();
                    for (int pos = 0; pos < constraint.getNumColumns(); ++pos) {
                        int foreignKeyPos = constraint.getColumnPairs().get((int)pos).source;
                        RelDataType foreignKeyColumnType = tRef.getTable().getRowType().getFieldList().get(foreignKeyPos).getType();
                        RexTableInputRef foreignKeyColumnRef = RexTableInputRef.of(tRef, foreignKeyPos, foreignKeyColumnType);
                        int uniqueKeyPos = constraint.getColumnPairs().get((int)pos).target;
                        RexTableInputRef uniqueKeyColumnRef = RexTableInputRef.of(parentTRef, uniqueKeyPos, parentTRef.getTable().getRowType().getFieldList().get(uniqueKeyPos).getType());
                        if (foreignKeyColumnType.isNullable() || !sourceEC.getEquivalenceClassesMap().containsKey(uniqueKeyColumnRef) || !sourceEC.getEquivalenceClassesMap().get(uniqueKeyColumnRef).contains(foreignKeyColumnRef)) {
                            canBeRewritten = false;
                            break;
                        }
                        equiColumns.put(foreignKeyColumnRef, uniqueKeyColumnRef);
                    }
                    if (!canBeRewritten) continue;
                    Edge edge = (Edge)graph.getEdge(tRef, parentTRef);
                    if (edge == null) {
                        edge = (Edge)graph.addEdge(tRef, parentTRef);
                    }
                    edge.equiColumns.putAll(equiColumns);
                }
            }
        }
        boolean done = false;
        do {
            ArrayList<RexTableInputRef.RelTableRef> nodesToRemove = new ArrayList<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
                if (graph.getInwardEdges(tRef).size() != 1 || !graph.getOutwardEdges(tRef).isEmpty()) continue;
                nodesToRemove.add(tRef);
                if (compensationEquiColumns == null || !extraTableRefs.contains(tRef)) continue;
                compensationEquiColumns.putAll(((Edge)graph.getInwardEdges((RexTableInputRef.RelTableRef)tRef).get((int)0)).equiColumns);
            }
            if (!nodesToRemove.isEmpty()) {
                graph.removeAllVertices(nodesToRemove);
                continue;
            }
            done = true;
        } while (!done);
        return Collections.disjoint(graph.vertexSet(), extraTableRefs);
    }

    private static Triple<RexNode, RexNode, RexNode> computeCompensationPredicates(RexBuilder rexBuilder, RexSimplify simplify, EquivalenceClasses sourceEC, Triple<RexNode, RexNode, RexNode> sourcePreds, EquivalenceClasses targetEC, Triple<RexNode, RexNode, RexNode> targetPreds, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> sourceToTargetTableMapping) {
        RexNode viewResidualPred;
        RexNode viewRangePred;
        RexNode compensationColumnsEquiPred = AbstractMaterializedViewRule.generateEquivalenceClasses(rexBuilder, sourceEC, targetEC);
        if (compensationColumnsEquiPred == null) {
            return null;
        }
        RexNode queryRangePred = RexUtil.swapColumnReferences(rexBuilder, (RexNode)sourcePreds.getMiddle(), sourceEC.getEquivalenceClassesMap());
        RexNode compensationRangePred = SubstitutionVisitor.splitFilter(simplify, queryRangePred, viewRangePred = RexUtil.swapTableColumnReferences(rexBuilder, (RexNode)targetPreds.getMiddle(), sourceToTargetTableMapping.inverse(), sourceEC.getEquivalenceClassesMap()));
        if (compensationRangePred == null) {
            return null;
        }
        RexNode queryResidualPred = RexUtil.swapColumnReferences(rexBuilder, (RexNode)sourcePreds.getRight(), sourceEC.getEquivalenceClassesMap());
        RexNode compensationResidualPred = SubstitutionVisitor.splitFilter(simplify, queryResidualPred, viewResidualPred = RexUtil.swapTableColumnReferences(rexBuilder, (RexNode)targetPreds.getRight(), sourceToTargetTableMapping.inverse(), sourceEC.getEquivalenceClassesMap()));
        if (compensationResidualPred == null) {
            return null;
        }
        return ImmutableTriple.of((Object)compensationColumnsEquiPred, (Object)compensationRangePred, (Object)compensationResidualPred);
    }

    private static RexNode generateEquivalenceClasses(RexBuilder rexBuilder, EquivalenceClasses sourceEC, EquivalenceClasses targetEC) {
        List<Set<RexTableInputRef>> targetEquivalenceClasses;
        if (sourceEC.getEquivalenceClasses().isEmpty() && targetEC.getEquivalenceClasses().isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (sourceEC.getEquivalenceClasses().isEmpty() && !targetEC.getEquivalenceClasses().isEmpty()) {
            return null;
        }
        List<Set<RexTableInputRef>> sourceEquivalenceClasses = sourceEC.getEquivalenceClasses();
        Multimap<Integer, Integer> mapping = AbstractMaterializedViewRule.extractPossibleMapping(sourceEquivalenceClasses, targetEquivalenceClasses = targetEC.getEquivalenceClasses());
        if (mapping == null) {
            return null;
        }
        RexNode compensationPredicate = rexBuilder.makeLiteral(true);
        for (int i = 0; i < sourceEquivalenceClasses.size(); ++i) {
            if (!mapping.containsKey(i)) {
                Iterator<RexTableInputRef> it = sourceEquivalenceClasses.get(i).iterator();
                RexTableInputRef e0 = it.next();
                while (it.hasNext()) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e0, it.next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
                continue;
            }
            for (int j : mapping.get(i)) {
                HashSet difference = new HashSet(sourceEquivalenceClasses.get(i));
                difference.removeAll((Collection)targetEquivalenceClasses.get(j));
                for (RexTableInputRef e : difference) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e, targetEquivalenceClasses.get(j).iterator().next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
            }
        }
        return compensationPredicate;
    }

    private static Multimap<Integer, Integer> extractPossibleMapping(List<Set<RexTableInputRef>> sourceEquivalenceClasses, List<Set<RexTableInputRef>> targetEquivalenceClasses) {
        ArrayListMultimap<Integer, Integer> mapping = ArrayListMultimap.create();
        for (int i = 0; i < targetEquivalenceClasses.size(); ++i) {
            boolean foundQueryEquivalenceClass = false;
            Set<RexTableInputRef> viewEquivalenceClass = targetEquivalenceClasses.get(i);
            for (int j = 0; j < sourceEquivalenceClasses.size(); ++j) {
                Set<RexTableInputRef> queryEquivalenceClass = sourceEquivalenceClasses.get(j);
                if (!queryEquivalenceClass.containsAll(viewEquivalenceClass)) continue;
                mapping.put(j, i);
                foundQueryEquivalenceClass = true;
                break;
            }
            if (foundQueryEquivalenceClass) continue;
            return null;
        }
        return mapping;
    }

    private static RexNode rewriteExpression(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, RexNode exprToRewrite) {
        List<RexNode> rewrittenExprs = AbstractMaterializedViewRule.rewriteExpressions(rexBuilder, mq, node, nodeExprs, tableMapping, ec, swapTableColumn, ImmutableList.of(exprToRewrite));
        if (rewrittenExprs == null) {
            return null;
        }
        assert (rewrittenExprs.size() == 1);
        return rewrittenExprs.get(0);
    }

    private static List<RexNode> rewriteExpressions(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, List<RexNode> exprsToRewrite) {
        NodeLineage nodeLineage = swapTableColumn ? AbstractMaterializedViewRule.generateSwapTableColumnReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs) : AbstractMaterializedViewRule.generateSwapColumnTableReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs);
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(exprsToRewrite.size());
        for (RexNode exprToRewrite : exprsToRewrite) {
            RexNode rewrittenExpr = AbstractMaterializedViewRule.replaceWithOriginalReferences(rexBuilder, nodeExprs, nodeLineage, exprToRewrite);
            if (RexUtil.containsTableInputRef(rewrittenExpr) != null) {
                return null;
            }
            rewrittenExprs.add(rewrittenExpr);
        }
        return rewrittenExprs;
    }

    private static NodeLineage generateSwapTableColumnReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<String, Integer> exprsLineage = new HashMap<String, Integer>();
        HashMap<String, Integer> exprsLineageLosslessCasts = new HashMap<String, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            assert (s.size() == 1);
            RexNode e = RexUtil.swapTableColumnReferences(rexBuilder, s.iterator().next(), tableMapping, ec.getEquivalenceClassesMap());
            exprsLineage.put(e.toString(), i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0).toString(), i);
        }
        return NodeLineage.of(exprsLineage, exprsLineageLosslessCasts);
    }

    private static NodeLineage generateSwapColumnTableReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<String, Integer> exprsLineage = new HashMap<String, Integer>();
        HashMap<String, Integer> exprsLineageLosslessCasts = new HashMap<String, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            assert (s.size() == 1);
            RexNode e = RexUtil.swapColumnTableReferences(rexBuilder, s.iterator().next(), ec.getEquivalenceClassesMap(), tableMapping);
            exprsLineage.put(e.toString(), i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0).toString(), i);
        }
        return NodeLineage.of(exprsLineage, exprsLineageLosslessCasts);
    }

    private static Multimap<Integer, Integer> generateMapping(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, RelNode target, ImmutableBitSet positions, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses sourceEC) {
        Map<RexTableInputRef, Set<RexTableInputRef>> equivalenceClassesMap = sourceEC.getEquivalenceClassesMap();
        ArrayListMultimap<String, Integer> exprsLineage = ArrayListMultimap.create();
        for (int i = 0; i < target.getRowType().getFieldCount(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(target, rexBuilder.makeInputRef(target, i));
            if (s == null) continue;
            assert (s.size() == 1);
            exprsLineage.put(RexUtil.swapTableColumnReferences(rexBuilder, s.iterator().next(), tableMapping.inverse(), equivalenceClassesMap).toString(), i);
        }
        ArrayListMultimap<Integer, Integer> m = ArrayListMultimap.create();
        for (int i : positions) {
            Set<RexNode> s = mq.getExpressionLineage(node, rexBuilder.makeInputRef(node, i));
            if (s == null) {
                return null;
            }
            assert (s.size() == 1);
            Collection c = exprsLineage.get(RexUtil.swapColumnReferences(rexBuilder, s.iterator().next(), equivalenceClassesMap).toString());
            if (c == null) {
                return null;
            }
            for (Integer j : c) {
                m.put(i, j);
            }
        }
        return m;
    }

    private static RexNode replaceWithOriginalReferences(final RexBuilder rexBuilder, final List<RexNode> nodeExprs, final NodeLineage nodeLineage, RexNode exprToRewrite) {
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall call) {
                RexNode rw = this.replace(call);
                return rw != null ? rw : super.visitCall(call);
            }

            @Override
            public RexNode visitTableInputRef(RexTableInputRef inputRef) {
                RexNode rw = this.replace(inputRef);
                return rw != null ? rw : super.visitTableInputRef(inputRef);
            }

            private RexNode replace(RexNode e) {
                Integer pos = (Integer)nodeLineage.exprsLineage.get(e.toString());
                if (pos != null) {
                    return rexBuilder.makeInputRef(e.getType(), (int)pos);
                }
                pos = (Integer)nodeLineage.exprsLineageLosslessCasts.get(e.toString());
                if (pos != null) {
                    return rexBuilder.makeCast(e.getType(), rexBuilder.makeInputRef(((RexNode)nodeExprs.get(pos)).getType(), (int)pos));
                }
                return null;
            }
        };
        return visitor.apply(exprToRewrite);
    }

    private static RexNode shuttleReferences(final RexBuilder rexBuilder, RexNode node, final Mapping mapping) {
        try {
            RexShuttle visitor = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int pos = mapping.getTargetOpt(inputRef.getIndex());
                    if (pos != -1) {
                        return rexBuilder.makeInputRef(inputRef.getType(), pos);
                    }
                    throw Util.FoundOne.NULL;
                }
            };
            return visitor.apply(node);
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return null;
        }
    }

    private static enum MatchModality {
        COMPLETE,
        VIEW_PARTIAL,
        QUERY_PARTIAL;

    }

    private static class ViewPartialRewriting {
        private final RelNode newView;
        private final Project newTopViewProject;
        private final RelNode newViewNode;

        private ViewPartialRewriting(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            this.newView = newView;
            this.newTopViewProject = newTopViewProject;
            this.newViewNode = newViewNode;
        }

        protected static ViewPartialRewriting of(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            return new ViewPartialRewriting(newView, newTopViewProject, newViewNode);
        }
    }

    private static class Edge
    extends DefaultEdge {
        public static final DirectedGraph.EdgeFactory<RexTableInputRef.RelTableRef, Edge> FACTORY = new DirectedGraph.EdgeFactory<RexTableInputRef.RelTableRef, Edge>(){

            @Override
            public Edge createEdge(RexTableInputRef.RelTableRef source, RexTableInputRef.RelTableRef target) {
                return new Edge(source, target);
            }
        };
        final Multimap<RexTableInputRef, RexTableInputRef> equiColumns = ArrayListMultimap.create();

        public Edge(RexTableInputRef.RelTableRef source, RexTableInputRef.RelTableRef target) {
            super(source, target);
        }

        public String toString() {
            return "{" + this.source + " -> " + this.target + "}";
        }
    }

    private static class NodeLineage {
        private final Map<String, Integer> exprsLineage;
        private final Map<String, Integer> exprsLineageLosslessCasts;

        private NodeLineage(Map<String, Integer> exprsLineage, Map<String, Integer> exprsLineageLosslessCasts) {
            this.exprsLineage = Collections.unmodifiableMap(exprsLineage);
            this.exprsLineageLosslessCasts = Collections.unmodifiableMap(exprsLineageLosslessCasts);
        }

        protected static NodeLineage of(Map<String, Integer> exprsLineage, Map<String, Integer> exprsLineageLosslessCasts) {
            return new NodeLineage(exprsLineage, exprsLineageLosslessCasts);
        }
    }

    private static class EquivalenceClasses {
        private final Map<RexTableInputRef, Set<RexTableInputRef>> nodeToEquivalenceClass = new HashMap<RexTableInputRef, Set<RexTableInputRef>>();
        private Map<RexTableInputRef, Set<RexTableInputRef>> cacheEquivalenceClassesMap = ImmutableMap.of();
        private List<Set<RexTableInputRef>> cacheEquivalenceClasses = ImmutableList.of();

        protected EquivalenceClasses() {
        }

        protected void addEquivalenceClass(RexTableInputRef p1, RexTableInputRef p2) {
            this.cacheEquivalenceClassesMap = null;
            this.cacheEquivalenceClasses = null;
            Set<RexTableInputRef> c1 = this.nodeToEquivalenceClass.get(p1);
            Set<RexTableInputRef> c2 = this.nodeToEquivalenceClass.get(p2);
            if (c1 != null && c2 != null) {
                if (c1.size() < c2.size()) {
                    c1 = c2;
                    p1 = p2;
                }
                for (RexTableInputRef newRef : c2) {
                    c1.add(newRef);
                    this.nodeToEquivalenceClass.put(newRef, c1);
                }
            } else if (c1 != null) {
                c1.add(p2);
                this.nodeToEquivalenceClass.put(p2, c1);
            } else if (c2 != null) {
                c2.add(p1);
                this.nodeToEquivalenceClass.put(p1, c2);
            } else {
                LinkedHashSet<RexTableInputRef> equivalenceClass = new LinkedHashSet<RexTableInputRef>();
                equivalenceClass.add(p1);
                equivalenceClass.add(p2);
                this.nodeToEquivalenceClass.put(p1, equivalenceClass);
                this.nodeToEquivalenceClass.put(p2, equivalenceClass);
            }
        }

        protected Map<RexTableInputRef, Set<RexTableInputRef>> getEquivalenceClassesMap() {
            if (this.cacheEquivalenceClassesMap == null) {
                this.cacheEquivalenceClassesMap = ImmutableMap.copyOf(this.nodeToEquivalenceClass);
            }
            return this.cacheEquivalenceClassesMap;
        }

        protected List<Set<RexTableInputRef>> getEquivalenceClasses() {
            if (this.cacheEquivalenceClasses == null) {
                HashSet<RexTableInputRef> visited = new HashSet<RexTableInputRef>();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Set<RexTableInputRef> set : this.nodeToEquivalenceClass.values()) {
                    if (!Collections.disjoint(visited, set)) continue;
                    builder.add(set);
                    visited.addAll(set);
                }
                this.cacheEquivalenceClasses = builder.build();
            }
            return this.cacheEquivalenceClasses;
        }

        protected static EquivalenceClasses copy(EquivalenceClasses ec) {
            EquivalenceClasses newEc = new EquivalenceClasses();
            for (Map.Entry<RexTableInputRef, Set<RexTableInputRef>> e : ec.nodeToEquivalenceClass.entrySet()) {
                newEc.nodeToEquivalenceClass.put(e.getKey(), Sets.newLinkedHashSet((Iterable)e.getValue()));
            }
            newEc.cacheEquivalenceClassesMap = null;
            newEc.cacheEquivalenceClasses = null;
            return newEc;
        }
    }

    public static class MaterializedViewOnlyAggregateRule
    extends MaterializedViewAggregateRule {
        public MaterializedViewOnlyAggregateRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewOnlyAggregateRule.operand(Aggregate.class, MaterializedViewOnlyAggregateRule.any()), relBuilderFactory, "MaterializedViewAggregateRule(Aggregate)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            this.perform(call, null, aggregate);
        }
    }

    public static class MaterializedViewProjectAggregateRule
    extends MaterializedViewAggregateRule {
        public MaterializedViewProjectAggregateRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewProjectAggregateRule.operand(Project.class, MaterializedViewProjectAggregateRule.operand(Aggregate.class, MaterializedViewProjectAggregateRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewAggregateRule(Project-Aggregate)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Aggregate aggregate = (Aggregate)call.rel(1);
            this.perform(call, project, aggregate);
        }
    }

    private static abstract class MaterializedViewAggregateRule
    extends AbstractMaterializedViewRule {
        protected MaterializedViewAggregateRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting) {
            super(operand, relBuilderFactory, description, generateUnionRewriting);
        }

        @Override
        protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
            if (!(node instanceof Aggregate)) {
                return false;
            }
            Aggregate aggregate = (Aggregate)node;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                return false;
            }
            return AbstractMaterializedViewRule.isValidRelNodePlan(aggregate.getInput(), mq);
        }

        @Override
        protected ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
            int i;
            HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
                if (viewTableRefs.contains(tRef)) continue;
                extraTableRefs.add(tRef);
            }
            Collection<RelNode> tableScanNodes = mq.getNodeTypes(node).get(TableScan.class);
            ArrayList<RelNode> newRels = new ArrayList<RelNode>();
            block1: for (RexTableInputRef.RelTableRef tRef : extraTableRefs) {
                int i2 = 0;
                for (RelNode relNode : tableScanNodes) {
                    if (!tRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || tRef.getEntityNumber() != i2++) continue;
                    newRels.add(relNode);
                    continue block1;
                }
            }
            assert (extraTableRefs.size() == newRels.size());
            relBuilder.push(input);
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode newView = relBuilder.build();
            Aggregate aggregateViewNode = (Aggregate)viewNode;
            relBuilder.push(aggregateViewNode.getInput());
            int offset = 0;
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
                offset += newRel.getRowType().getFieldCount();
            }
            ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
            groupSet.addAll(aggregateViewNode.getGroupSet());
            groupSet.addAll(ImmutableBitSet.range(aggregateViewNode.getInput().getRowType().getFieldCount(), aggregateViewNode.getInput().getRowType().getFieldCount() + offset));
            Aggregate newViewNode = aggregateViewNode.copy(aggregateViewNode.getTraitSet(), relBuilder.build(), aggregateViewNode.indicator, groupSet.build(), null, aggregateViewNode.getAggCallList());
            relBuilder.push(newViewNode);
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            if (topViewProject != null) {
                nodes.addAll(topViewProject.getChildExps());
                fieldNames.addAll(topViewProject.getRowType().getFieldNames());
                for (i = aggregateViewNode.getRowType().getFieldCount(); i < newViewNode.getRowType().getFieldCount(); ++i) {
                    int idx = i - aggregateViewNode.getAggCallList().size();
                    nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                    fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
                }
            } else {
                for (i = 0; i < newViewNode.getRowType().getFieldCount(); ++i) {
                    int idx = i < aggregateViewNode.getGroupCount() ? i : (i < aggregateViewNode.getRowType().getFieldCount() ? i + offset : i - aggregateViewNode.getAggCallList().size());
                    nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                    fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
                }
            }
            relBuilder.project(nodes, fieldNames, true);
            Project newTopViewProject = (Project)relBuilder.build();
            return ViewPartialRewriting.of(newView, newTopViewProject, newViewNode);
        }

        @Override
        protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses viewEC, EquivalenceClasses queryEC) {
            Aggregate aggregate = (Aggregate)node;
            RelNode aggregateInput = aggregate.getInput(0);
            List queryExprs = AbstractMaterializedViewRule.extractReferences(rexBuilder, aggregateInput);
            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, aggregateInput, queryExprs, queryToViewTableMapping, queryEC, false, compensationColumnsEquiPred)) == null) {
                return null;
            }
            if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, aggregateInput, queryExprs, queryToViewTableMapping, viewEC, true, otherCompensationPred)) == null) {
                return null;
            }
            RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred), false));
            relBuilder.push(aggregateInput);
            relBuilder.filter(simplify.simplify(queryCompensationPred));
            return aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(relBuilder.build()));
        }

        @Override
        protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
            relBuilder.push(unionInputQuery);
            relBuilder.push(unionInputView);
            relBuilder.union(true);
            ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
            ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
            for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
                RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
                exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
                nameList.add(field.getName());
            }
            relBuilder.project(exprList, nameList);
            Aggregate aggregate = (Aggregate)unionInputQuery;
            ImmutableBitSet groupSet = ImmutableBitSet.range(aggregate.getGroupCount());
            ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
            for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
                AggregateCall aggCall = aggregate.getAggCallList().get(i);
                if (aggCall.isDistinct()) {
                    return null;
                }
                aggregateCalls.add(relBuilder.aggregateCall(SubstitutionVisitor.getRollup(aggCall.getAggregation()), aggCall.isDistinct(), null, aggCall.name, ImmutableList.of(rexBuilder.makeInputRef(relBuilder.peek(), aggregate.getGroupCount() + i))));
            }
            RelNode result = relBuilder.aggregate(relBuilder.groupKey(groupSet, false, (ImmutableList<ImmutableBitSet>)null), (Iterable<RelBuilder.AggCall>)aggregateCalls).build();
            if (topProject != null) {
                return topProject.copy(topProject.getTraitSet(), ImmutableList.of(result));
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses queryEC) {
            int i;
            boolean bl;
            void var19_29;
            Multimap m;
            Aggregate queryAggregate = (Aggregate)node;
            Aggregate viewAggregate = (Aggregate)viewNode;
            ImmutableBitSet.Builder indexes = ImmutableBitSet.builder();
            ImmutableBitSet references = null;
            if (topProject != null && !unionRewriting) {
                RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(new LinkedHashSet<RelDataTypeField>());
                for (RexNode rexNode : topProject.getChildExps()) {
                    rexNode.accept(inputFinder);
                }
                references = inputFinder.inputBitSet.build();
                for (int i2 = 0; i2 < queryAggregate.getGroupCount(); ++i2) {
                    indexes.set(queryAggregate.getGroupSet().nth(i2));
                }
                for (int i2 = 0; i2 < queryAggregate.getAggCallList().size(); ++i2) {
                    if (!references.get(queryAggregate.getGroupCount() + i2)) continue;
                    for (int inputIdx : queryAggregate.getAggCallList().get(i2).getArgList()) {
                        indexes.set(inputIdx);
                    }
                }
            } else {
                for (int i3 = 0; i3 < queryAggregate.getGroupCount(); ++i3) {
                    indexes.set(queryAggregate.getGroupSet().nth(i3));
                }
                for (AggregateCall queryAggCall : queryAggregate.getAggCallList()) {
                    for (int inputIdx : queryAggCall.getArgList()) {
                        indexes.set(inputIdx);
                    }
                }
            }
            if ((m = AbstractMaterializedViewRule.generateMapping(rexBuilder, mq, queryAggregate.getInput(), viewAggregate.getInput(), indexes.build(), queryToViewTableMapping, queryEC)) == null) {
                return null;
            }
            Mapping aggregateMapping = Mappings.create(MappingType.FUNCTION, queryAggregate.getRowType().getFieldCount(), viewAggregate.getRowType().getFieldCount());
            boolean bl2 = false;
            while (var19_29 < queryAggregate.getGroupCount()) {
                Collection c = m.get(queryAggregate.getGroupSet().nth((int)var19_29));
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    int targetIdx = viewAggregate.getGroupSet().indexOf(j);
                    if (targetIdx == -1) continue;
                    aggregateMapping.set((int)var19_29, targetIdx);
                    break;
                }
                if (aggregateMapping.getTargetOpt((int)var19_29) == -1) {
                    return null;
                }
                ++var19_29;
            }
            boolean bl3 = false;
            block9: for (int idx = 0; idx < queryAggregate.getAggCallList().size(); ++idx) {
                if (references != null && !references.get(queryAggregate.getGroupCount() + idx)) continue;
                AggregateCall queryAggCall = queryAggregate.getAggCallList().get(idx);
                if (queryAggCall.filterArg >= 0) {
                    return null;
                }
                ArrayList queryAggCallIndexes = new ArrayList();
                for (int aggCallIdx : queryAggCall.getArgList()) {
                    queryAggCallIndexes.add(m.get(aggCallIdx).iterator().next());
                }
                for (int j = 0; j < viewAggregate.getAggCallList().size(); ++j) {
                    AggregateCall viewAggCall = viewAggregate.getAggCallList().get(j);
                    if (queryAggCall.getAggregation() != viewAggCall.getAggregation() || queryAggCall.isDistinct() != viewAggCall.isDistinct() || queryAggCall.getArgList().size() != viewAggCall.getArgList().size() || queryAggCall.getType() != viewAggCall.getType() || viewAggCall.filterArg >= 0 || !queryAggCallIndexes.equals(viewAggCall.getArgList())) continue;
                    aggregateMapping.set(queryAggregate.getGroupCount() + idx, viewAggregate.getGroupCount() + j);
                    if (!queryAggCall.isDistinct()) continue block9;
                    bl = true;
                    continue block9;
                }
            }
            Mapping rewritingMapping = null;
            RelNode result = relBuilder.push(input).build();
            if (queryAggregate.getGroupCount() != viewAggregate.getGroupCount() || matchModality == MatchModality.VIEW_PARTIAL) {
                if (bl) {
                    return null;
                }
                rewritingMapping = Mappings.create(MappingType.FUNCTION, topViewProject != null ? topViewProject.getRowType().getFieldCount() : viewAggregate.getRowType().getFieldCount(), queryAggregate.getRowType().getFieldCount());
                ImmutableBitSet.Builder groupSetB = ImmutableBitSet.builder();
                for (int i6 = 0; i6 < queryAggregate.getGroupCount(); ++i6) {
                    int targetIdx = aggregateMapping.getTargetOpt(i6);
                    if (targetIdx == -1) {
                        return null;
                    }
                    if (topViewProject != null) {
                        boolean added = false;
                        for (int k = 0; k < topViewProject.getChildExps().size(); ++k) {
                            int ref;
                            RexNode n = topViewProject.getChildExps().get(k);
                            if (!n.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n).getIndex()) != targetIdx) continue;
                            groupSetB.set(k);
                            rewritingMapping.set(k, i6);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        return null;
                    }
                    groupSetB.set(targetIdx);
                    rewritingMapping.set(targetIdx, i6);
                }
                ImmutableBitSet groupSet = groupSetB.build();
                ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
                for (int i7 = 0; i7 < queryAggregate.getAggCallList().size(); ++i7) {
                    if (references != null && !references.get(queryAggregate.getGroupCount() + i7)) continue;
                    int sourceIdx = queryAggregate.getGroupCount() + i7;
                    int targetIdx = aggregateMapping.getTargetOpt(sourceIdx);
                    if (targetIdx == -1) {
                        return null;
                    }
                    AggregateCall queryAggCall = queryAggregate.getAggCallList().get(i7);
                    if (topViewProject != null) {
                        boolean added = false;
                        for (int k = 0; k < topViewProject.getChildExps().size(); ++k) {
                            int ref;
                            RexNode n = topViewProject.getChildExps().get(k);
                            if (!n.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n).getIndex()) != targetIdx) continue;
                            aggregateCalls.add(relBuilder.aggregateCall(SubstitutionVisitor.getRollup(queryAggCall.getAggregation()), queryAggCall.isDistinct(), null, queryAggCall.name, ImmutableList.of(rexBuilder.makeInputRef(input, k))));
                            rewritingMapping.set(k, sourceIdx);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        return null;
                    }
                    aggregateCalls.add(relBuilder.aggregateCall(SubstitutionVisitor.getRollup(queryAggCall.getAggregation()), queryAggCall.isDistinct(), null, queryAggCall.name, ImmutableList.of(rexBuilder.makeInputRef(input, targetIdx))));
                    rewritingMapping.set(targetIdx, sourceIdx);
                }
                result = relBuilder.push(result).aggregate(relBuilder.groupKey(groupSet, false, (ImmutableList<ImmutableBitSet>)null), (Iterable<RelBuilder.AggCall>)aggregateCalls).build();
                ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
                Mapping inverseMapping = rewritingMapping.inverse();
                for (int i5 = 0; i5 < queryAggregate.getGroupCount(); ++i5) {
                    projects.add(rexBuilder.makeInputRef(result, groupSet.indexOf(inverseMapping.getTarget(i5))));
                }
                for (int i3 = 0; i3 < queryAggregate.getAggCallList().size(); ++i3) {
                    projects.add(rexBuilder.makeInputRef(result, queryAggregate.getGroupCount() + i3));
                }
                result = relBuilder.push(result).project(projects).build();
            }
            ArrayList<RexNode> topExprs = new ArrayList<RexNode>();
            if (topProject != null && !unionRewriting) {
                topExprs.addAll(topProject.getChildExps());
            } else {
                for (int pos = 0; pos < queryAggregate.getRowType().getFieldCount(); ++pos) {
                    topExprs.add(rexBuilder.makeInputRef(queryAggregate, pos));
                }
            }
            ArrayList<String> viewExprs = new ArrayList<String>();
            if (topViewProject != null) {
                for (i = 0; i < topViewProject.getChildExps().size(); ++i) {
                    viewExprs.add(topViewProject.getChildExps().get(i).toString());
                }
            } else {
                for (i = 0; i < viewAggregate.getRowType().getFieldCount(); ++i) {
                    viewExprs.add(rexBuilder.makeInputRef(viewAggregate, i).toString());
                }
            }
            ArrayList<RexInputRef> rewrittenExprs = new ArrayList<RexInputRef>(topExprs.size());
            for (RexNode expr : topExprs) {
                RexNode rewrittenExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, expr, aggregateMapping);
                if (rewrittenExpr == null) {
                    return null;
                }
                int pos = viewExprs.indexOf(rewrittenExpr.toString());
                if (pos == -1) {
                    return null;
                }
                if (rewritingMapping != null && (pos = rewritingMapping.getTargetOpt(pos)) == -1) {
                    return null;
                }
                rewrittenExprs.add(rexBuilder.makeInputRef(result, pos));
            }
            return relBuilder.push(result).project(rewrittenExprs).build();
        }
    }

    public static class MaterializedViewOnlyFilterRule
    extends MaterializedViewJoinRule {
        public MaterializedViewOnlyFilterRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewOnlyFilterRule.operand(Filter.class, MaterializedViewOnlyFilterRule.any()), relBuilderFactory, "MaterializedViewJoinRule(Filter)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            this.perform(call, null, filter);
        }
    }

    public static class MaterializedViewOnlyJoinRule
    extends MaterializedViewJoinRule {
        public MaterializedViewOnlyJoinRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewOnlyJoinRule.operand(Join.class, MaterializedViewOnlyJoinRule.any()), relBuilderFactory, "MaterializedViewJoinRule(Join)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            this.perform(call, null, join);
        }
    }

    public static class MaterializedViewProjectFilterRule
    extends MaterializedViewJoinRule {
        public MaterializedViewProjectFilterRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewProjectFilterRule.operand(Project.class, MaterializedViewProjectFilterRule.operand(Filter.class, MaterializedViewProjectFilterRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewJoinRule(Project-Filter)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            this.perform(call, project, filter);
        }
    }

    public static class MaterializedViewProjectJoinRule
    extends MaterializedViewJoinRule {
        public MaterializedViewProjectJoinRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting) {
            super(MaterializedViewProjectJoinRule.operand(Project.class, MaterializedViewProjectJoinRule.operand(Join.class, MaterializedViewProjectJoinRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewJoinRule(Project-Join)", generateUnionRewriting);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            this.perform(call, project, join);
        }
    }

    private static abstract class MaterializedViewJoinRule
    extends AbstractMaterializedViewRule {
        protected MaterializedViewJoinRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting) {
            super(operand, relBuilderFactory, description, generateUnionRewriting);
        }

        @Override
        protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
            return AbstractMaterializedViewRule.isValidRelNodePlan(node, mq);
        }

        @Override
        protected ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
            for (RelNode relNode : node.getInputs()) {
                if (!mq.getTableReferences(relNode).containsAll(viewTableRefs)) continue;
                return null;
            }
            HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
                if (viewTableRefs.contains(tRef)) continue;
                extraTableRefs.add(tRef);
            }
            Collection<RelNode> collection = mq.getNodeTypes(node).get(TableScan.class);
            ArrayList<RelNode> newRels = new ArrayList<RelNode>();
            block2: for (RexTableInputRef.RelTableRef relTableRef : extraTableRefs) {
                int i = 0;
                for (RelNode relNode : collection) {
                    if (!relTableRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || relTableRef.getEntityNumber() != i++) continue;
                    newRels.add(relNode);
                    continue block2;
                }
            }
            assert (extraTableRefs.size() == newRels.size());
            relBuilder.push(input);
            for (RelNode relNode : newRels) {
                relBuilder.push(relNode);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode newView = relBuilder.build();
            relBuilder.push(topViewProject != null ? topViewProject : viewNode);
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode relNode = relBuilder.build();
            return ViewPartialRewriting.of(newView, null, relNode);
        }

        @Override
        protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> viewToQueryTableMapping, EquivalenceClasses viewEC, EquivalenceClasses queryEC) {
            List queryExprs = AbstractMaterializedViewRule.extractReferences(rexBuilder, node);
            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, node, queryExprs, viewToQueryTableMapping.inverse(), queryEC, false, compensationColumnsEquiPred)) == null) {
                return null;
            }
            if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, node, queryExprs, viewToQueryTableMapping.inverse(), viewEC, true, otherCompensationPred)) == null) {
                return null;
            }
            RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred), false));
            relBuilder.push(node);
            relBuilder.filter(simplify.simplify(queryCompensationPred));
            if (topProject != null) {
                return topProject.copy(topProject.getTraitSet(), ImmutableList.of(relBuilder.build()));
            }
            return relBuilder.build();
        }

        @Override
        protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
            relBuilder.push(unionInputQuery);
            relBuilder.push(unionInputView);
            relBuilder.union(true);
            ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
            ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
            for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
                RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
                exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
                nameList.add(field.getName());
            }
            relBuilder.project(exprList, nameList);
            return relBuilder.build();
        }

        @Override
        protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses queryEC) {
            List exprs = topProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, node) : topProject.getChildExps();
            ArrayList<RexNode> exprsLineage = new ArrayList<RexNode>(exprs.size());
            for (RexNode expr : exprs) {
                Set<RexNode> s = mq.getExpressionLineage(node, expr);
                if (s == null) {
                    return null;
                }
                assert (s.size() == 1);
                exprsLineage.add(s.iterator().next());
            }
            List viewExprs = topViewProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, viewNode) : topViewProject.getChildExps();
            List rewrittenExprs = AbstractMaterializedViewRule.rewriteExpressions(rexBuilder, mq, viewNode, viewExprs, queryToViewTableMapping.inverse(), queryEC, true, exprsLineage);
            if (rewrittenExprs == null) {
                return null;
            }
            return relBuilder.push(input).project(rewrittenExprs).build();
        }
    }
}

