/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOReader
extends PTransform<PCollection<String>, PCollection<BeamRecord>>
implements Serializable {
    private String filePattern;
    protected BeamRecordSqlType beamRecordSqlType;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOReader(BeamRecordSqlType beamRecordSqlType, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.beamRecordSqlType = beamRecordSqlType;
        this.csvFormat = csvFormat;
    }

    public PCollection<BeamRecord> expand(PCollection<String> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, BeamRecord>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                String str = (String)ctx.element();
                ctx.output((Object)BeamTableUtils.csvLine2BeamRecord(BeamTextCSVTableIOReader.this.csvFormat, str, BeamTextCSVTableIOReader.this.beamRecordSqlType));
            }
        }));
    }
}

