/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOReader;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOWriter;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamTextCSVTable
extends BeamTextTable {
    private static final Logger LOG = LoggerFactory.getLogger(BeamTextCSVTable.class);
    private String filePattern;
    private CSVFormat csvFormat;

    public BeamTextCSVTable(BeamRecordSqlType beamSqlRowType, String filePattern) {
        this(beamSqlRowType, filePattern, CSVFormat.DEFAULT);
    }

    public BeamTextCSVTable(BeamRecordSqlType beamRecordSqlType, String filePattern, CSVFormat csvFormat) {
        super(beamRecordSqlType, filePattern);
        this.filePattern = filePattern;
        this.csvFormat = csvFormat;
    }

    @Override
    public PCollection<BeamRecord> buildIOReader(Pipeline pipeline) {
        return (PCollection)((PCollection)PBegin.in((Pipeline)pipeline).apply("decodeRecord", (PTransform)TextIO.read().from(this.filePattern))).apply("parseCSVLine", (PTransform)new BeamTextCSVTableIOReader(this.beamRecordSqlType, this.filePattern, this.csvFormat));
    }

    @Override
    public PTransform<? super PCollection<BeamRecord>, PDone> buildIOWriter() {
        return new BeamTextCSVTableIOWriter(this.beamRecordSqlType, this.filePattern, this.csvFormat);
    }

    public CSVFormat getCsvFormat() {
        return this.csvFormat;
    }

    public String getFilePattern() {
        return this.filePattern;
    }
}

