/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta;

import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.meta.Column;

final class AutoValue_Column
extends Column {
    private final String name;
    private final Integer type;
    private final String comment;
    private final boolean primaryKey;

    private AutoValue_Column(String name, Integer type, @Nullable String comment, boolean primaryKey) {
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.primaryKey = primaryKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return "Column{name=" + this.name + ", type=" + this.type + ", comment=" + this.comment + ", primaryKey=" + this.primaryKey + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Column) {
            Column that = (Column)o;
            return this.name.equals(that.getName()) && this.type.equals(that.getType()) && (this.comment == null ? that.getComment() == null : this.comment.equals(that.getComment())) && this.primaryKey == that.isPrimaryKey();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.comment == null ? 0 : this.comment.hashCode();
        h *= 1000003;
        return h ^= this.primaryKey ? 1231 : 1237;
    }

    static final class Builder
    extends Column.Builder {
        private String name;
        private Integer type;
        private String comment;
        private Boolean primaryKey;

        Builder() {
        }

        @Override
        public Column.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Column.Builder type(Integer type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public Column.Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Column.Builder primaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public Column build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.primaryKey == null) {
                missing = missing + " primaryKey";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Column(this.name, this.type, this.comment, this.primaryKey);
        }
    }
}

