/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionExecutor;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;

public class BeamSqlProjectFn
extends DoFn<BeamRecord, BeamRecord> {
    private String stepName;
    private BeamSqlExpressionExecutor executor;
    private BeamRecordSqlType outputRowType;

    public BeamSqlProjectFn(String stepName, BeamSqlExpressionExecutor executor, BeamRecordSqlType outputRowType) {
        this.stepName = stepName;
        this.executor = executor;
        this.outputRowType = outputRowType;
    }

    @DoFn.Setup
    public void setup() {
        this.executor.prepare();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
        BeamRecord inputRow = (BeamRecord)c.element();
        List<Object> results = this.executor.execute(inputRow, window);
        ArrayList<Object> fieldsValue = new ArrayList<Object>(results.size());
        for (int idx = 0; idx < results.size(); ++idx) {
            fieldsValue.add(BeamTableUtils.autoCastField(this.outputRowType.getFieldTypeByIndex(idx), results.get(idx)));
        }
        BeamRecord outRow = new BeamRecord((BeamRecordType)this.outputRowType, fieldsValue);
        c.output((Object)outRow);
    }

    @DoFn.Teardown
    public void close() {
        this.executor.close();
    }
}

