/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NlsString;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public final class BeamTableUtils {
    public static BeamRecord csvLine2BeamRecord(CSVFormat csvFormat, String line, BeamRecordSqlType beamRecordSqlType) {
        ArrayList<Object> fieldsValue = new ArrayList<Object>(beamRecordSqlType.getFieldCount());
        try (StringReader reader = new StringReader(line);){
            CSVParser parser = csvFormat.parse((Reader)reader);
            CSVRecord rawRecord = (CSVRecord)parser.getRecords().get(0);
            if (rawRecord.size() != beamRecordSqlType.getFieldCount()) {
                throw new IllegalArgumentException(String.format("Expect %d fields, but actually %d", beamRecordSqlType.getFieldCount(), rawRecord.size()));
            }
            for (int idx = 0; idx < beamRecordSqlType.getFieldCount(); ++idx) {
                String raw = rawRecord.get(idx);
                fieldsValue.add(BeamTableUtils.autoCastField(beamRecordSqlType.getFieldTypeByIndex(idx), raw));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("decodeRecord failed!", e);
        }
        return new BeamRecord((BeamRecordType)beamRecordSqlType, fieldsValue);
    }

    public static String beamRecord2CsvLine(BeamRecord row, CSVFormat csvFormat) {
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = csvFormat.print((Appendable)writer);){
            for (int i = 0; i < row.getFieldCount(); ++i) {
                printer.print((Object)row.getFieldValue(i).toString());
            }
            printer.println();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("encodeRecord failed!", e);
        }
        return writer.toString();
    }

    public static Object autoCastField(int fieldType, Object rawObj) {
        if (rawObj == null) {
            return null;
        }
        SqlTypeName columnType = CalciteUtils.toCalciteType(fieldType);
        if (rawObj instanceof String && SqlTypeName.NUMERIC_TYPES.contains((Object)columnType) || rawObj instanceof BigDecimal && columnType != SqlTypeName.DECIMAL) {
            String raw = rawObj.toString();
            switch (columnType) {
                case TINYINT: {
                    return Byte.valueOf(raw);
                }
                case SMALLINT: {
                    return Short.valueOf(raw);
                }
                case INTEGER: {
                    return Integer.valueOf(raw);
                }
                case BIGINT: {
                    return Long.valueOf(raw);
                }
                case FLOAT: {
                    return Float.valueOf(raw);
                }
                case DOUBLE: {
                    return Double.valueOf(raw);
                }
            }
            throw new UnsupportedOperationException(String.format("Column type %s is not supported yet!", new Object[]{columnType}));
        }
        if (SqlTypeName.CHAR_TYPES.contains((Object)columnType)) {
            if (rawObj instanceof NlsString) {
                return ((NlsString)rawObj).getValue();
            }
            return rawObj;
        }
        return rawObj;
    }
}

