/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlExtractExpression
extends BeamSqlExpression {
    private static final Map<TimeUnitRange, Integer> typeMapping = new HashMap<TimeUnitRange, Integer>();

    public BeamSqlExtractExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.BIGINT);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && this.opType(1) == SqlTypeName.BIGINT;
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        Long time = (Long)this.opValueEvaluated(1, inputRow, window);
        TimeUnitRange unit = (TimeUnitRange)((Object)((BeamSqlPrimitive)this.op(0)).getValue());
        switch (unit) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                Long timeByDay = time / 1000L / 3600L / 24L;
                Long extracted = DateTimeUtils.unixDateExtract(unit, timeByDay);
                return BeamSqlPrimitive.of(this.outputType, extracted);
            }
            case DOY: 
            case DOW: 
            case WEEK: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(time));
                return BeamSqlPrimitive.of(this.outputType, Long.valueOf(calendar.get(typeMapping.get((Object)unit))));
            }
            case QUARTER: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(time));
                long ret = calendar.get(2) / 3;
                if (ret * 3L < (long)calendar.get(2)) {
                    ++ret;
                }
                return BeamSqlPrimitive.of(this.outputType, ret);
            }
        }
        throw new UnsupportedOperationException("Extract for time unit: " + (Object)((Object)unit) + " not supported!");
    }

    static {
        typeMapping.put(TimeUnitRange.DOW, 7);
        typeMapping.put(TimeUnitRange.DOY, 6);
        typeMapping.put(TimeUnitRange.WEEK, 3);
    }
}

