/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.SqlTypeUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DateTime;

public class BeamSqlDatetimePlusExpression
extends BeamSqlExpression {
    private static final Set<SqlTypeName> SUPPORTED_INTERVAL_TYPES = ImmutableSet.of(SqlTypeName.INTERVAL_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_YEAR, new SqlTypeName[0]);

    public BeamSqlDatetimePlusExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.TIMESTAMP);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && SqlTypeName.TIMESTAMP.equals((Object)((BeamSqlExpression)this.operands.get(0)).getOutputType()) && SUPPORTED_INTERVAL_TYPES.contains((Object)((BeamSqlExpression)this.operands.get(1)).getOutputType());
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        DateTime timestamp = this.getTimestampOperand(inputRow, window);
        BeamSqlPrimitive intervalOperandPrimitive = this.getIntervalOperand(inputRow, window);
        SqlTypeName intervalOperandType = intervalOperandPrimitive.getOutputType();
        int intervalMultiplier = this.getIntervalMultiplier(intervalOperandPrimitive);
        DateTime newDate = this.addInterval(timestamp, intervalOperandType, intervalMultiplier);
        return BeamSqlPrimitive.of(SqlTypeName.TIMESTAMP, newDate.toDate());
    }

    private int getIntervalMultiplier(BeamSqlPrimitive intervalOperandPrimitive) {
        BigDecimal intervalOperandValue = intervalOperandPrimitive.getDecimal();
        BigDecimal multiplier = intervalOperandValue.divide(TimeUnitUtils.timeUnitInternalMultiplier(intervalOperandPrimitive.getOutputType()), 2);
        return multiplier.intValueExact();
    }

    private BeamSqlPrimitive getIntervalOperand(BeamRecord inputRow, BoundedWindow window) {
        return SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SUPPORTED_INTERVAL_TYPES).get().evaluate(inputRow, window);
    }

    private DateTime getTimestampOperand(BeamRecord inputRow, BoundedWindow window) {
        BeamSqlPrimitive timestampOperandPrimitive = SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.TIMESTAMP).get().evaluate(inputRow, window);
        return new DateTime((Object)timestampOperandPrimitive.getDate());
    }

    private DateTime addInterval(DateTime dateTime, SqlTypeName intervalType, int numberOfIntervals) {
        switch (intervalType) {
            case INTERVAL_SECOND: {
                return dateTime.plusSeconds(numberOfIntervals);
            }
            case INTERVAL_MINUTE: {
                return dateTime.plusMinutes(numberOfIntervals);
            }
            case INTERVAL_HOUR: {
                return dateTime.plusHours(numberOfIntervals);
            }
            case INTERVAL_DAY: {
                return dateTime.plusDays(numberOfIntervals);
            }
            case INTERVAL_MONTH: {
                return dateTime.plusMonths(numberOfIntervals);
            }
            case INTERVAL_YEAR: {
                return dateTime.plusYears(numberOfIntervals);
            }
        }
        throw new IllegalArgumentException("Adding " + intervalType.getName() + " to date is not supported");
    }
}

