/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class BeamSqlCastExpression
extends BeamSqlExpression {
    private static final int index = 0;
    private static final String outputTimestampFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String outputDateFormat = "yyyy-MM-dd";
    private static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{DateTimeFormat.forPattern((String)"yy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yy.MM.dd").getParser(), DateTimeFormat.forPattern((String)"yyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssz").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss z").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSSz").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS z").getParser()}).toFormatter().withPivotYear(2020);

    public BeamSqlCastExpression(List<BeamSqlExpression> operands, SqlTypeName castType) {
        super(operands, castType);
    }

    @Override
    public boolean accept() {
        return this.numberOfOperands() == 1;
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        SqlTypeName castOutputType = this.getOutputType();
        switch (castOutputType) {
            case INTEGER: {
                return BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.toInt(this.opValueEvaluated(0, inputRow, window)));
            }
            case DOUBLE: {
                return BeamSqlPrimitive.of(SqlTypeName.DOUBLE, SqlFunctions.toDouble(this.opValueEvaluated(0, inputRow, window)));
            }
            case SMALLINT: {
                return BeamSqlPrimitive.of(SqlTypeName.SMALLINT, SqlFunctions.toShort(this.opValueEvaluated(0, inputRow, window)));
            }
            case TINYINT: {
                return BeamSqlPrimitive.of(SqlTypeName.TINYINT, SqlFunctions.toByte((Number)this.opValueEvaluated(0, inputRow, window)));
            }
            case BIGINT: {
                return BeamSqlPrimitive.of(SqlTypeName.BIGINT, SqlFunctions.toLong(this.opValueEvaluated(0, inputRow, window)));
            }
            case DECIMAL: {
                return BeamSqlPrimitive.of(SqlTypeName.DECIMAL, SqlFunctions.toBigDecimal(this.opValueEvaluated(0, inputRow, window)));
            }
            case FLOAT: {
                return BeamSqlPrimitive.of(SqlTypeName.FLOAT, Float.valueOf(SqlFunctions.toFloat(this.opValueEvaluated(0, inputRow, window))));
            }
            case CHAR: 
            case VARCHAR: {
                return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, this.opValueEvaluated(0, inputRow, window).toString());
            }
            case DATE: {
                return BeamSqlPrimitive.of(SqlTypeName.DATE, this.toDate(this.opValueEvaluated(0, inputRow, window), outputDateFormat));
            }
            case TIMESTAMP: {
                return BeamSqlPrimitive.of(SqlTypeName.TIMESTAMP, this.toTimeStamp(this.opValueEvaluated(0, inputRow, window), outputTimestampFormat));
            }
        }
        throw new UnsupportedOperationException(String.format("Cast to type %s not supported", new Object[]{castOutputType}));
    }

    private Date toDate(Object inputDate, String outputFormat) {
        try {
            return Date.valueOf(dateTimeFormatter.parseLocalDate(inputDate.toString()).toString(outputFormat));
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Can't be cast to type 'Date'");
        }
    }

    private Timestamp toTimeStamp(Object inputTimestamp, String outputFormat) {
        try {
            return Timestamp.valueOf(dateTimeFormatter.parseDateTime(inputTimestamp.toString()).secondOfMinute().roundCeilingCopy().toString(outputFormat));
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Can't be cast to type 'Timestamp'");
        }
    }
}

