/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.sql.BeamSqlRecordHelper;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;

public class BeamRecordSqlType
extends BeamRecordType {
    private static final Map<Integer, Class> JAVA_CLASSES = ImmutableMap.builder().put(-6, Byte.class).put(5, Short.class).put(4, Integer.class).put(-5, Long.class).put(6, Float.class).put(8, Double.class).put(3, BigDecimal.class).put(16, Boolean.class).put(1, String.class).put(12, String.class).put(92, GregorianCalendar.class).put(91, Date.class).put(93, Date.class).build();
    private static final Map<Integer, Coder> CODERS = ImmutableMap.builder().put(-6, ByteCoder.of()).put(5, (ByteCoder)BeamSqlRecordHelper.ShortCoder.of()).put(4, (ByteCoder)BigEndianIntegerCoder.of()).put(-5, (ByteCoder)BigEndianLongCoder.of()).put(6, (ByteCoder)BeamSqlRecordHelper.FloatCoder.of()).put(8, (ByteCoder)BeamSqlRecordHelper.DoubleCoder.of()).put(3, (ByteCoder)BigDecimalCoder.of()).put(16, (ByteCoder)BeamSqlRecordHelper.BooleanCoder.of()).put(1, (ByteCoder)StringUtf8Coder.of()).put(12, (ByteCoder)StringUtf8Coder.of()).put(92, (ByteCoder)BeamSqlRecordHelper.TimeCoder.of()).put(91, (ByteCoder)BeamSqlRecordHelper.DateCoder.of()).put(93, (ByteCoder)BeamSqlRecordHelper.DateCoder.of()).build();
    public List<Integer> fieldTypes;

    protected BeamRecordSqlType(List<String> fieldsName, List<Coder> fieldsCoder) {
        super(fieldsName, fieldsCoder);
    }

    private BeamRecordSqlType(List<String> fieldsName, List<Integer> fieldTypes, List<Coder> fieldsCoder) {
        super(fieldsName, fieldsCoder);
        this.fieldTypes = fieldTypes;
    }

    public static BeamRecordSqlType create(List<String> fieldNames, List<Integer> fieldTypes) {
        if (fieldNames.size() != fieldTypes.size()) {
            throw new IllegalStateException("the sizes of 'dataType' and 'fieldTypes' must match.");
        }
        ArrayList<Coder> fieldCoders = new ArrayList<Coder>(fieldTypes.size());
        for (Integer fieldType : fieldTypes) {
            if (!CODERS.containsKey(fieldType)) {
                throw new UnsupportedOperationException("Data type: " + fieldType + " not supported yet!");
            }
            fieldCoders.add(CODERS.get(fieldType));
        }
        return new BeamRecordSqlType(fieldNames, fieldTypes, fieldCoders);
    }

    public void validateValueType(int index, Object fieldValue) throws IllegalArgumentException {
        if (null == fieldValue) {
            return;
        }
        int fieldType = this.fieldTypes.get(index);
        Class javaClazz = JAVA_CLASSES.get(fieldType);
        if (javaClazz == null) {
            throw new IllegalArgumentException("Data type: " + fieldType + " not supported yet!");
        }
        if (!fieldValue.getClass().equals(javaClazz)) {
            throw new IllegalArgumentException(String.format("[%s](%s) doesn't match type [%s]", fieldValue, fieldValue.getClass(), fieldType));
        }
    }

    public List<Integer> getFieldTypes() {
        return Collections.unmodifiableList(this.fieldTypes);
    }

    public Integer getFieldTypeByIndex(int index) {
        return this.fieldTypes.get(index);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BeamRecordSqlType) {
            BeamRecordSqlType ins = (BeamRecordSqlType)((Object)obj);
            return this.fieldTypes.equals(ins.getFieldTypes()) && this.getFieldNames().equals(ins.getFieldNames());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.getFieldNames().hashCode() + this.getFieldTypes().hashCode();
    }

    public String toString() {
        return "BeamRecordSqlType [fieldNames=" + this.getFieldNames() + ", fieldTypes=" + this.fieldTypes + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<String> fieldNames = ImmutableList.builder();
        private ImmutableList.Builder<Integer> fieldTypes = ImmutableList.builder();

        public Builder withField(String fieldName, Integer fieldType) {
            this.fieldNames.add((Object)fieldName);
            this.fieldTypes.add((Object)fieldType);
            return this;
        }

        public Builder withTinyIntField(String fieldName) {
            return this.withField(fieldName, -6);
        }

        public Builder withSmallIntField(String fieldName) {
            return this.withField(fieldName, 5);
        }

        public Builder withIntegerField(String fieldName) {
            return this.withField(fieldName, 4);
        }

        public Builder withBigIntField(String fieldName) {
            return this.withField(fieldName, -5);
        }

        public Builder withFloatField(String fieldName) {
            return this.withField(fieldName, 6);
        }

        public Builder withDoubleField(String fieldName) {
            return this.withField(fieldName, 8);
        }

        public Builder withDecimalField(String fieldName) {
            return this.withField(fieldName, 3);
        }

        public Builder withBooleanField(String fieldName) {
            return this.withField(fieldName, 16);
        }

        public Builder withCharField(String fieldName) {
            return this.withField(fieldName, 1);
        }

        public Builder withVarcharField(String fieldName) {
            return this.withField(fieldName, 12);
        }

        public Builder withTimeField(String fieldName) {
            return this.withField(fieldName, 92);
        }

        public Builder withDateField(String fieldName) {
            return this.withField(fieldName, 91);
        }

        public Builder withTimestampField(String fieldName) {
            return this.withField(fieldName, 93);
        }

        private Builder() {
        }

        public BeamRecordSqlType build() {
            return BeamRecordSqlType.create((List<String>)((Object)this.fieldNames.build()), (List<Integer>)((Object)this.fieldTypes.build()));
        }
    }
}

