/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDynamicParam;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.BitString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.TimestampString;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BeamSqlUnparseContext
extends SqlImplementor.SimpleContext {
    private static final CharSequenceTranslator ESCAPE_FOR_ZETA_SQL = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())}).with(new CharSequenceTranslator[]{JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
    private Map<String, RelDataType> nullParams = new HashMap<String, RelDataType>();

    public BeamSqlUnparseContext(IntFunction<SqlNode> field) {
        super(BeamBigQuerySqlDialect.DEFAULT, field);
    }

    public Map<String, RelDataType> getNullParams() {
        return this.nullParams;
    }

    public SqlNode toSql(RexProgram program, RexNode rex) {
        if (rex.getKind().equals((Object)SqlKind.LITERAL)) {
            RexLiteral literal = (RexLiteral)rex;
            SqlTypeName name = literal.getTypeName();
            SqlTypeFamily family = name.getFamily();
            if (SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)name)) {
                TimestampString timestampString = (TimestampString)literal.getValueAs(TimestampString.class);
                return new SqlDateTimeLiteral(timestampString, SqlImplementor.POS);
            }
            if (SqlTypeFamily.BINARY.equals((Object)family)) {
                ByteString byteString = (ByteString)literal.getValueAs(ByteString.class);
                BitString bitString = BitString.createFromHexString((String)byteString.toString(16));
                return new SqlByteStringLiteral(bitString, SqlImplementor.POS);
            }
            if (SqlTypeFamily.CHARACTER.equals((Object)family)) {
                String escaped = ESCAPE_FOR_ZETA_SQL.translate((CharSequence)literal.getValueAs(String.class));
                return SqlLiteral.createCharString((String)escaped, (SqlParserPos)SqlImplementor.POS);
            }
            if (SqlTypeName.SYMBOL.equals((Object)literal.getTypeName())) {
                Enum symbol = (Enum)literal.getValueAs(Enum.class);
                if (TimeUnitRange.DOW.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFWEEK");
                }
                if (TimeUnitRange.DOY.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFYEAR");
                }
                if (TimeUnitRange.WEEK.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "ISOWEEK");
                }
            }
        } else if (rex.getKind().equals((Object)SqlKind.DYNAMIC_PARAM)) {
            RexDynamicParam param = (RexDynamicParam)rex;
            int index = param.getIndex();
            String name = "null_param_" + index;
            this.nullParams.put(name, param.getType());
            return new NamedDynamicParam(index, SqlImplementor.POS, name);
        }
        return super.toSql(program, rex);
    }

    private static class NamedDynamicParam
    extends SqlDynamicParam {
        private final String newName;

        NamedDynamicParam(int index, SqlParserPos pos, String newName) {
            super(index, pos);
            this.newName = newName;
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.literal("@" + this.newName);
        }
    }

    private static class ReplaceLiteral
    extends SqlLiteral {
        private final String newValue;

        ReplaceLiteral(RexLiteral literal, SqlParserPos pos, String newValue) {
            super((Object)literal.getValue(), literal.getTypeName(), pos);
            this.newValue = newValue;
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.literal(this.newValue);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ReplaceLiteral)) {
                return false;
            }
            if (!this.newValue.equals(((ReplaceLiteral)((Object)obj)).newValue)) {
                return false;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class SqlByteStringLiteral
    extends SqlLiteral {
        SqlByteStringLiteral(BitString bytes, SqlParserPos pos) {
            super((Object)bytes, SqlTypeName.BINARY, pos);
        }

        public SqlByteStringLiteral clone(SqlParserPos pos) {
            return new SqlByteStringLiteral((BitString)this.value, pos);
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            assert (this.value instanceof BitString);
            StringBuilder builder = new StringBuilder("B'");
            for (byte b : ((BitString)this.value).getAsByteArray()) {
                builder.append(String.format("\\x%02X", b));
            }
            builder.append("'");
            writer.literal(builder.toString());
        }
    }

    private static class SqlDateTimeLiteral
    extends SqlLiteral {
        private final TimestampString timestampString;

        SqlDateTimeLiteral(TimestampString timestampString, SqlParserPos pos) {
            super((Object)timestampString, SqlTypeName.TIMESTAMP, pos);
            this.timestampString = timestampString;
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.literal("DATETIME '" + this.timestampString.toString() + "'");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SqlDateTimeLiteral that = (SqlDateTimeLiteral)((Object)o);
            return Objects.equals(this.timestampString, that.timestampString);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.timestampString);
        }
    }
}

