/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.CustomTableResolver;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
public abstract class FullNameTableProvider
implements TableProvider,
CustomTableResolver {
    private List<TableName> knownTables = new ArrayList<TableName>();

    protected FullNameTableProvider() {
    }

    public abstract Table getTableByFullName(TableName var1);

    @Override
    public void registerKnownTableNames(List<TableName> tableNames) {
        this.knownTables.addAll(tableNames);
    }

    @Override
    public TableProvider getSubProvider(String name) {
        List<TableName> tablesToLookFor = this.knownTables.stream().filter(TableName::isCompound).filter(tableName -> tableName.getPrefix().equals(name)).collect(Collectors.toList());
        return tablesToLookFor.size() > 0 ? new TableNameTrackingProvider(1, tablesToLookFor) : null;
    }

    class TableNameTrackingProvider
    extends InMemoryMetaTableProvider {
        int schemaLevel;
        List<TableName> tableNames;

        TableNameTrackingProvider(int schemaLevel, List<TableName> tableNames) {
            this.schemaLevel = schemaLevel;
            this.tableNames = tableNames;
        }

        @Override
        public TableProvider getSubProvider(String name) {
            List<TableName> matchingTables = this.tableNames.stream().filter(TableName::isCompound).filter(tableName -> tableName.getPath().size() > this.schemaLevel).filter(tableName -> tableName.getPath().get(this.schemaLevel).equals(name)).collect(Collectors.toList());
            return matchingTables.size() > 0 ? new TableNameTrackingProvider(this.schemaLevel + 1, matchingTables) : null;
        }

        @Override
        public String getTableType() {
            return "google.cloud.datacatalog.subprovider";
        }

        @Override
        public @Nullable Table getTable(String name) {
            Optional<TableName> matchingTable = this.tableNames.stream().filter(tableName -> tableName.getTableName().equals(name)).findFirst();
            TableName fullTableName = matchingTable.orElseThrow(() -> new IllegalStateException("Unexpected table '" + name + "' requested. Current schema level is " + this.schemaLevel + ". Current known table names: " + this.tableNames.toString()));
            return FullNameTableProvider.this.getTableByFullName(fullTableName);
        }

        @Override
        public synchronized BeamSqlTable buildBeamSqlTable(Table table) {
            return FullNameTableProvider.this.buildBeamSqlTable(table);
        }
    }
}

