/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class CEPOperator
implements Serializable {
    private final CEPKind cepKind;
    private static final Map<SqlKind, CEPKind> CEPKindTable = ImmutableMap.builder().put((Object)SqlKind.SUM, (Object)CEPKind.SUM).put((Object)SqlKind.COUNT, (Object)CEPKind.COUNT).put((Object)SqlKind.AVG, (Object)CEPKind.AVG).put((Object)SqlKind.FIRST, (Object)CEPKind.FIRST).put((Object)SqlKind.LAST, (Object)CEPKind.LAST).put((Object)SqlKind.PREV, (Object)CEPKind.PREV).put((Object)SqlKind.NEXT, (Object)CEPKind.NEXT).put((Object)SqlKind.EQUALS, (Object)CEPKind.EQUALS).put((Object)SqlKind.NOT_EQUALS, (Object)CEPKind.NOT_EQUALS).put((Object)SqlKind.GREATER_THAN, (Object)CEPKind.GREATER_THAN).put((Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)CEPKind.GREATER_THAN_OR_EQUAL).put((Object)SqlKind.LESS_THAN, (Object)CEPKind.LESS_THAN).put((Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)CEPKind.LESS_THAN_OR_EQUAL).put((Object)SqlKind.TIMES, (Object)CEPKind.TIMES).put((Object)SqlKind.DIVIDE, (Object)CEPKind.DIVIDE).put((Object)SqlKind.PLUS, (Object)CEPKind.PLUS).put((Object)SqlKind.MINUS, (Object)CEPKind.MINUS).build();

    private CEPOperator(CEPKind cepKind) {
        this.cepKind = cepKind;
    }

    public CEPKind getCepKind() {
        return this.cepKind;
    }

    public static CEPOperator of(SqlOperator op) {
        SqlKind opKind = op.getKind();
        return new CEPOperator(CEPKindTable.getOrDefault(opKind, CEPKind.NONE));
    }

    public String toString() {
        return this.cepKind.name();
    }
}

