/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamKafkaJsonTable
extends BeamKafkaTable {
    public BeamKafkaJsonTable(@UnknownKeyFor @NonNull @Initialized Schema beamSchema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics) {
        super(beamSchema, bootstrapServers, topics);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> getPTransformForInput() {
        ObjectMapper objectMapper = RowJsonUtils.newObjectMapperWith((RowJson.RowJsonDeserializer)RowJson.RowJsonDeserializer.forSchema((Schema)this.schema));
        return new JsonRecorderDecoder(this.schema, objectMapper);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> getPTransformForOutput() {
        ObjectMapper objectMapper = RowJsonUtils.newObjectMapperWith((RowJson.RowJsonSerializer)RowJson.RowJsonSerializer.forSchema((Schema)this.schema));
        return new JsonRecorderEncoder(objectMapper);
    }

    private static class JsonRecorderEncoder
    extends PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> {
        private final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper;

        public JsonRecorderEncoder(@UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            return (PCollection)input.apply("encodeJsonRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, KV<byte[], byte[]>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output((Object)KV.of((Object)new byte[0], (Object)RowJsonUtils.rowToJson((ObjectMapper)objectMapper, (Row)((Row)c.element())).getBytes(StandardCharsets.UTF_8)));
                }
            }));
        }
    }

    private static class JsonRecorderDecoder
    extends PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper;

        public JsonRecorderDecoder(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper) {
            this.schema = schema;
            this.objectMapper = objectMapper;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
            return ((PCollection)input.apply("decodeJsonRecord", (PTransform)ParDo.of((DoFn)new DoFn<KV<byte[], byte[]>, Row>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    String rowInString = new String((byte[])((KV)c.element()).getValue(), StandardCharsets.UTF_8);
                    Row row = RowJsonUtils.jsonToRow((ObjectMapper)objectMapper, (String)rowInString);
                    c.output((Object)row);
                }
            }))).setRowSchema(this.schema);
        }
    }
}

