/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datastore;

import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.provider.SchemaIOTableProviderWrapper;
import org.apache.beam.sdk.io.gcp.datastore.DataStoreV1SchemaIOProvider;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataStoreV1TableProvider
extends SchemaIOTableProviderWrapper {
    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaIOProvider getSchemaIOProvider() {
        return new DataStoreV1SchemaIOProvider();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "datastoreV1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized SchemaIO schemaIO) {
        DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO dataStoreV1SchemaIO = (DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO)schemaIO;
        long count = DatastoreIO.v1().read().withProjectId(dataStoreV1SchemaIO.getProjectId()).getNumEntities(options, dataStoreV1SchemaIO.getKind(), null);
        if (count < 0L) {
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
        return BeamTableStatistics.createBoundedTableStatistics(Double.valueOf(count));
    }
}

