/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udaf;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Combine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
public class StringAgg {

    public static class StringAggString
    extends Combine.CombineFn<String, String, String> {
        private static final @UnknownKeyFor @NonNull @Initialized String delimiter = ",";

        public @UnknownKeyFor @NonNull @Initialized String createAccumulator() {
            return "";
        }

        public @UnknownKeyFor @NonNull @Initialized String addInput(@UnknownKeyFor @NonNull @Initialized String curString, @UnknownKeyFor @NonNull @Initialized String nextString) {
            if (!nextString.isEmpty()) {
                curString = !curString.isEmpty() ? curString + delimiter + nextString : nextString;
            }
            return curString;
        }

        public @UnknownKeyFor @NonNull @Initialized String mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public @UnknownKeyFor @NonNull @Initialized String extractOutput(@UnknownKeyFor @NonNull @Initialized String output) {
            return output;
        }
    }
}

