/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Static;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

abstract class SqlDropObject
extends SqlDrop
implements SqlExecutableStatement {
    protected final @UnknownKeyFor @NonNull @Initialized SqlIdentifier name;

    SqlDropObject(@UnknownKeyFor @NonNull @Initialized SqlOperator operator, @UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean ifExists, @UnknownKeyFor @NonNull @Initialized SqlIdentifier name) {
        super(operator, pos, ifExists);
        this.name = name;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        List path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        switch (this.getKind()) {
            case DROP_TABLE: {
                boolean existed;
                if (schema.schema instanceof BeamCalciteSchema) {
                    BeamCalciteSchema beamSchema = (BeamCalciteSchema)schema.schema;
                    beamSchema.getTableProvider().dropTable(this.name.getSimple());
                    existed = true;
                } else {
                    existed = schema.removeTable(this.name.getSimple());
                }
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(this.name.getSimple()));
            }
            default: {
                throw new AssertionError(this.getKind());
            }
        }
    }
}

