/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperator;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPPattern;
import org.apache.beam.sdk.extensions.sql.impl.cep.Quantifier;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class NFA
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized State startState;
    private @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized StateLocator> currentRuns;
    private final @UnknownKeyFor @NonNull @Initialized Schema upstreamSchema;

    private NFA(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPPattern> patterns, @UnknownKeyFor @NonNull @Initialized Schema upstreamSchema) {
        this.startState = this.loadStates(patterns);
        this.currentRuns = new ArrayList();
        this.upstreamSchema = upstreamSchema;
    }

    public static @UnknownKeyFor @NonNull @Initialized NFA compile(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPPattern> patterns, @UnknownKeyFor @NonNull @Initialized Schema outSchema) {
        return new NFA(patterns, outSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized Row>> processNewRow(@UnknownKeyFor @NonNull @Initialized Row inputRow) {
        Event inputEvent = new Event(inputRow, this.upstreamSchema);
        ArrayList<StateLocator> nextStateLocators = new ArrayList<StateLocator>();
        EventPointer nullPtr = new EventPointer(new ArrayList<Integer>(), "");
        this.currentRuns.add(new StateLocator(nullPtr, this.startState, this.startState, 0, null));
        ArrayList<StateLocator> kleenePlusLocators = new ArrayList<StateLocator>();
        for (StateLocator locator : this.currentRuns) {
            if (!locator.isKleenePlusSecondary()) continue;
            if (locator.getCurState().getNextState().isFinal) {
                return this.processOutput(locator);
            }
            StateLocator proceedLocator = locator.proceedIgnore();
            kleenePlusLocators.add(proceedLocator);
        }
        this.currentRuns.addAll(kleenePlusLocators);
        for (StateLocator currentLocator : this.currentRuns) {
            StateLocator takeLocator;
            boolean split = false;
            StateLocator proceedLocator = currentLocator.proceed(inputEvent);
            if (proceedLocator != null) {
                if (proceedLocator.atFinal()) {
                    this.currentRuns.clear();
                    State iterState = this.startState;
                    while (!iterState.isFinal) {
                        iterState.reset();
                        iterState = iterState.getNextState();
                    }
                    this.currentRuns.add(new StateLocator(nullPtr, this.startState, this.startState, 0, null));
                    return this.processOutput(proceedLocator);
                }
                nextStateLocators.add(proceedLocator);
                split = true;
            }
            if ((takeLocator = currentLocator.take(inputEvent, split)) == null) continue;
            nextStateLocators.add(takeLocator);
        }
        this.currentRuns = nextStateLocators;
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized Row>> processOutput(@UnknownKeyFor @NonNull @Initialized StateLocator locator) {
        HashMap<String, ArrayList<Row>> rows = new HashMap<String, ArrayList<Row>>();
        EventPointer iterPointer = locator.getPointer().copy();
        Event curEvent = locator.getCurrentEvent();
        while (curEvent != null) {
            String patternVar = iterPointer.getPatternVar();
            if (rows.containsKey(patternVar)) {
                ArrayList<Row> patternArray = rows.get(patternVar);
                patternArray.add(curEvent.getRow());
            } else {
                ArrayList<Row> newPatternArray = new ArrayList<Row>();
                newPatternArray.add(curEvent.getRow());
                rows.put(patternVar, newPatternArray);
            }
            if ((curEvent = curEvent.findEvent(iterPointer)) == null) continue;
            iterPointer = curEvent.getPrevPointer(iterPointer);
        }
        for (ArrayList i : rows.values()) {
            Collections.reverse(i);
        }
        return rows;
    }

    private static @UnknownKeyFor @NonNull @Initialized State setNextStatesAndAssignIndices(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized State> states) {
        for (int i = 0; i < states.size() - 1; ++i) {
            State currentState = states.get(i);
            State nextState = states.get(i + 1);
            if (currentState.isKleenePlus()) {
                State secondaryState = currentState.getNextState();
                secondaryState.setNextState(nextState);
                continue;
            }
            currentState.setNextState(nextState);
        }
        return states.get(0);
    }

    private @UnknownKeyFor @NonNull @Initialized State loadStates(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPPattern> patterns) {
        ArrayList<State> states = new ArrayList<State>();
        for (int i = 0; i < patterns.size(); ++i) {
            boolean startState = i == 0;
            CEPPattern currentPattern = patterns.get(i);
            CEPCall condition = currentPattern.getPatternCondition();
            Quantifier quantifier = currentPattern.getQuantifier();
            if (quantifier.toString().equals("+")) {
                State primaryState = new State(currentPattern.getPatternVar(), Quantifier.PLUS, condition, startState, false, false);
                State secondaryState = new State(currentPattern.getPatternVar(), Quantifier.PLUS, condition, startState, false, true);
                primaryState.setNextState(secondaryState);
                states.add(primaryState);
                continue;
            }
            State newState = new State(currentPattern.getPatternVar(), quantifier, condition, startState, false, false);
            states.add(newState);
        }
        State theFinalState = new State("", Quantifier.NONE, null, false, true, false);
        states.add(theFinalState);
        State beginState = NFA.setNextStatesAndAssignIndices(states);
        return beginState;
    }

    private static class State
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized int index = 0;
        private final @UnknownKeyFor @NonNull @Initialized String patternVar;
        private final @UnknownKeyFor @NonNull @Initialized Quantifier quant;
        private final @UnknownKeyFor @NonNull @Initialized CEPOperation condition;
        private @UnknownKeyFor @NonNull @Initialized State nextState = null;
        public final @UnknownKeyFor @NonNull @Initialized boolean isStart;
        public final @UnknownKeyFor @NonNull @Initialized boolean isFinal;
        private final @UnknownKeyFor @NonNull @Initialized boolean isKleenePlusSecondary;

        State(@UnknownKeyFor @NonNull @Initialized String patternVar, @UnknownKeyFor @NonNull @Initialized Quantifier quant, @UnknownKeyFor @NonNull @Initialized CEPOperation condition, @UnknownKeyFor @NonNull @Initialized boolean isStart, @UnknownKeyFor @NonNull @Initialized boolean isFinal, @UnknownKeyFor @NonNull @Initialized boolean isKleenePlusSecondary) {
            this.patternVar = patternVar;
            this.quant = quant;
            this.condition = condition;
            this.isStart = isStart;
            this.isFinal = isFinal;
            this.isKleenePlusSecondary = isKleenePlusSecondary;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPatternVar() {
            return this.patternVar;
        }

        public @UnknownKeyFor @NonNull @Initialized int assignIndex() {
            return ++this.index;
        }

        public void reset() {
            this.index = 0;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasTake() {
            return this.isKleenePlusSecondary;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasProceed() {
            return !this.isFinal;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isKleenePlusSecondary() {
            return this.isKleenePlusSecondary;
        }

        public @UnknownKeyFor @NonNull @Initialized CEPOperation getTakeCondition() {
            if (!this.hasTake()) {
                throw new IllegalStateException("The state does not have a take edge.");
            }
            return this.condition;
        }

        public @UnknownKeyFor @NonNull @Initialized CEPOperation getProceedCondition() {
            if (!this.hasProceed()) {
                throw new IllegalStateException("The state does not have a proceed edge.");
            }
            if (!this.isKleenePlusSecondary) {
                return this.condition;
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Quantifier getQuantifier() {
            return this.quant;
        }

        public void setNextState(@UnknownKeyFor @NonNull @Initialized State theNextState) {
            if (this == theNextState) {
                return;
            }
            this.nextState = theNextState;
        }

        public @UnknownKeyFor @NonNull @Initialized State getNextState() {
            return this.nextState;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isKleenePlus() {
            return this.quant.toString().equals("+") || this.quant.toString().equals("+?");
        }
    }

    private static class StateLocator
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized EventPointer ptr;
        private @UnknownKeyFor @NonNull @Initialized State startState;
        private @UnknownKeyFor @NonNull @Initialized State curState;
        private @UnknownKeyFor @NonNull @Initialized int takeCount = 0;
        private @UnknownKeyFor @NonNull @Initialized Event curEvent = null;

        StateLocator(@UnknownKeyFor @NonNull @Initialized EventPointer ptr, @UnknownKeyFor @NonNull @Initialized State startState, @UnknownKeyFor @NonNull @Initialized State curState, @UnknownKeyFor @NonNull @Initialized int takeCount, @UnknownKeyFor @NonNull @Initialized Event curEvent) {
            this.ptr = ptr;
            this.startState = startState;
            this.curState = curState;
            this.takeCount = takeCount;
            this.curEvent = curEvent;
        }

        public @UnknownKeyFor @NonNull @Initialized State getCurState() {
            return this.curState;
        }

        public @UnknownKeyFor @NonNull @Initialized EventPointer getPointer() {
            return this.ptr;
        }

        public @UnknownKeyFor @NonNull @Initialized Event getCurrentEvent() {
            return this.curEvent;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean atFinal() {
            return this.curState.isFinal;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isKleenePlusSecondary() {
            return this.curState.isKleenePlusSecondary();
        }

        public @UnknownKeyFor @NonNull @Initialized StateLocator proceedIgnore() {
            if (this.isKleenePlusSecondary()) {
                EventPointer newPtr = this.ptr.getNewProceedPointer(0, this.curState.getPatternVar());
                return new StateLocator(newPtr, this.startState, this.curState.getNextState(), 0, this.curEvent);
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized StateLocator proceed(@UnknownKeyFor @NonNull @Initialized Event inputEvent) {
            if (this.curState.hasProceed()) {
                CEPCall condition = (CEPCall)this.curState.getProceedCondition();
                String patternVar = this.curState.getPatternVar();
                if (this.evalCondition(inputEvent, condition)) {
                    if (this.curState == this.startState && this.curEvent == null) {
                        int ptrValue = this.curState.assignIndex();
                        ArrayList<Integer> ptrArray = new ArrayList<Integer>();
                        ptrArray.add(ptrValue);
                        EventPointer eventPointer = new EventPointer(ptrArray, patternVar);
                        inputEvent.addPrevEvent(eventPointer, null);
                        return new StateLocator(eventPointer, this.startState, this.curState.getNextState(), 0, inputEvent);
                    }
                    EventPointer newPtr = this.ptr.getNewProceedPointer(0, patternVar);
                    inputEvent.addPrevEvent(newPtr, this.curEvent);
                    return new StateLocator(newPtr, this.startState, this.curState.getNextState(), 0, inputEvent);
                }
                return null;
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized StateLocator take(@UnknownKeyFor @NonNull @Initialized Event inputEvent, @UnknownKeyFor @NonNull @Initialized boolean split) {
            if (this.curState.hasTake()) {
                if (this.evalCondition(inputEvent, this.curState.getTakeCondition())) {
                    if (split) {
                        int ptrValue = this.curState.assignIndex();
                        EventPointer newPtr = this.ptr.getNewTakePointer(ptrValue);
                        inputEvent.addPrevEvent(newPtr, this.curEvent);
                        return new StateLocator(newPtr, this.startState, this.curState, this.takeCount + 1, inputEvent);
                    }
                    EventPointer newPtr = this.ptr.copy();
                    inputEvent.addPrevEvent(newPtr, this.curEvent);
                    return new StateLocator(newPtr, this.startState, this.curState, this.takeCount + 1, inputEvent);
                }
                return null;
            }
            return null;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean evalCondition(@UnknownKeyFor @NonNull @Initialized Event inputEvent, @UnknownKeyFor @NonNull @Initialized CEPOperation operation) {
            if (operation == null) {
                return true;
            }
            CEPCall condition = (CEPCall)operation;
            CEPKind comparator = condition.getOperator().getCepKind();
            CEPOperation leftSide = condition.getOperands().get(0);
            CEPOperation rightSide = condition.getOperands().get(1);
            CEPLiteral leftSideValue = this.evalLeftSideCondition(leftSide, inputEvent);
            CEPLiteral rightSideValue = this.evalRightSideCondition(rightSide, inputEvent);
            if (leftSideValue == null) {
                return false;
            }
            if (rightSideValue == null) {
                return true;
            }
            switch (comparator) {
                case EQUALS: {
                    return leftSideValue.compareTo(rightSideValue) == 0;
                }
                case NOT_EQUALS: {
                    return leftSideValue.compareTo(rightSideValue) != 0;
                }
                case GREATER_THAN: {
                    return leftSideValue.compareTo(rightSideValue) > 0;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return leftSideValue.compareTo(rightSideValue) >= 0;
                }
                case LESS_THAN: {
                    return leftSideValue.compareTo(rightSideValue) < 0;
                }
                case LESS_THAN_OR_EQUAL: {
                    return leftSideValue.compareTo(rightSideValue) <= 0;
                }
            }
            throw new IllegalStateException("the comparator is not supported: " + comparator.toString());
        }

        private @UnknownKeyFor @NonNull @Initialized CEPLiteral evalLeftSideCondition(@UnknownKeyFor @NonNull @Initialized CEPOperation inputOperation, @UnknownKeyFor @NonNull @Initialized Event inputEvent) {
            if (inputOperation instanceof CEPLiteral) {
                return (CEPLiteral)inputOperation;
            }
            if (inputOperation.getClass() == CEPFieldRef.class) {
                return inputEvent.toCEPLiteral((CEPFieldRef)inputOperation);
            }
            if (inputOperation.getClass() == CEPCall.class) {
                CEPCall call = (CEPCall)inputOperation;
                CEPOperator operator = call.getOperator();
                List<CEPOperation> operands = call.getOperands();
                switch (operator.getCepKind()) {
                    case LAST: {
                        return this.last(operands.get(0), this.evalLeftSideCondition(operands.get(1), inputEvent), inputEvent);
                    }
                    case PLUS: {
                        return this.plus(this.evalLeftSideCondition(operands.get(0), inputEvent), this.evalLeftSideCondition(operands.get(1), inputEvent));
                    }
                }
                throw new UnsupportedOperationException("the function is not supported for now: " + operator.getCepKind().toString());
            }
            throw new IllegalStateException("the left side CEP operation is not legal: " + inputOperation.getClass().toString());
        }

        private @UnknownKeyFor @NonNull @Initialized CEPLiteral evalRightSideCondition(@UnknownKeyFor @NonNull @Initialized CEPOperation inputOperation, @UnknownKeyFor @NonNull @Initialized Event inputEvent) {
            if (inputOperation instanceof CEPLiteral) {
                return (CEPLiteral)inputOperation;
            }
            if (inputOperation.getClass() == CEPCall.class) {
                CEPCall call = (CEPCall)inputOperation;
                CEPOperator operator = call.getOperator();
                List<CEPOperation> operands = call.getOperands();
                switch (operator.getCepKind()) {
                    case PLUS: {
                        return this.plus(this.evalRightSideCondition(operands.get(0), inputEvent), this.evalRightSideCondition(operands.get(1), inputEvent));
                    }
                    case PREV: {
                        return this.prev(operands.get(0), (CEPLiteral)operands.get(1), this.ptr, this.curEvent, inputEvent);
                    }
                }
                throw new UnsupportedOperationException("the function is not supported for now: " + operator.getCepKind().toString());
            }
            throw new IllegalStateException("the right side CEP operation is not legal: " + inputOperation.getClass().toString());
        }

        private @UnknownKeyFor @NonNull @Initialized CEPLiteral prev(@UnknownKeyFor @NonNull @Initialized CEPOperation opr1, @UnknownKeyFor @NonNull @Initialized CEPLiteral opr2, @UnknownKeyFor @NonNull @Initialized EventPointer curPointer, @UnknownKeyFor @NonNull @Initialized Event curEvent, @UnknownKeyFor @NonNull @Initialized Event inputEvent) {
            if (opr1.getClass() != CEPFieldRef.class) {
                throw new IllegalStateException("the first argument of the PREV operation should be a field reference. Provided: " + opr1.getClass().toString());
            }
            if (opr2.getTypeName() != Schema.TypeName.DECIMAL) {
                throw new IllegalStateException("the second argument of the prev operation should be a decimal. Provided: " + opr2.getClass().toString());
            }
            if (opr2.getDecimal().intValue() == 0) {
                return inputEvent.toCEPLiteral((CEPFieldRef)opr1);
            }
            if (curEvent == null) {
                return null;
            }
            CEPFieldRef fieldRef = (CEPFieldRef)opr1;
            String alpha = fieldRef.getAlpha();
            int lastNumber = opr2.getDecimal().intValue();
            EventPointer iterPointer = curPointer.copy();
            while (curEvent != null && iterPointer.getPatternVar().equals(alpha) && lastNumber > 0) {
                iterPointer = curEvent.getPrevPointer(iterPointer);
                curEvent = curEvent.findEvent(iterPointer);
            }
            if (curEvent != null) {
                return curEvent.toCEPLiteral(fieldRef);
            }
            return null;
        }

        private @UnknownKeyFor @NonNull @Initialized CEPLiteral last(@UnknownKeyFor @NonNull @Initialized CEPOperation opr1, @UnknownKeyFor @NonNull @Initialized CEPLiteral opr2, @UnknownKeyFor @NonNull @Initialized Event inputEvent) {
            if (opr1.getClass() != CEPFieldRef.class) {
                throw new IllegalStateException("the first argument of the PREV operation should be a field reference. Provided: " + opr1.getClass().toString());
            }
            if (opr2.getTypeName() != Schema.TypeName.DECIMAL) {
                throw new IllegalStateException("the second argument of the prev operation should be a decimal. Provided: " + opr2.getClass().toString());
            }
            return inputEvent.toCEPLiteral((CEPFieldRef)opr1);
        }

        private @UnknownKeyFor @NonNull @Initialized CEPLiteral plus(@UnknownKeyFor @NonNull @Initialized CEPLiteral opr1, @UnknownKeyFor @NonNull @Initialized CEPLiteral opr2) {
            Schema.TypeName type1 = opr1.getTypeName();
            Schema.TypeName type2 = opr2.getTypeName();
            if (type1.isNumericType() && type1 == type2) {
                switch (type1) {
                    case BYTE: {
                        return CEPLiteral.of(opr1.getByte() + opr2.getByte());
                    }
                    case INT16: {
                        return CEPLiteral.of(opr1.getInt16() + opr2.getInt16());
                    }
                    case INT32: {
                        return CEPLiteral.of(opr1.getInt32() + opr2.getInt32());
                    }
                    case INT64: {
                        return CEPLiteral.of(opr1.getInt64() + opr2.getInt64());
                    }
                    case DECIMAL: {
                        return CEPLiteral.of(opr1.getDecimal().add(opr2.getDecimal()));
                    }
                    case FLOAT: {
                        return CEPLiteral.of(Float.valueOf(opr1.getFloat().floatValue() + opr2.getFloat().floatValue()));
                    }
                    case DOUBLE: {
                        return CEPLiteral.of(opr1.getDouble() + opr2.getDouble());
                    }
                }
                throw new UnsupportedOperationException("Type is not supported: " + type1.toString());
            }
            throw new IllegalStateException("Types do not match: " + type1.toString() + ", " + type2.toString());
        }
    }

    private static class EventPointer
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> ptrValues;
        private final @UnknownKeyFor @NonNull @Initialized String patternVar;

        EventPointer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> ptrValues, @UnknownKeyFor @NonNull @Initialized String patternVar) {
            this.ptrValues = ptrValues;
            this.patternVar = patternVar;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canTrim() {
            return this.ptrValues.size() > 1;
        }

        public void trim() {
            if (!this.isProceedPointer()) {
                throw new IllegalStateException("the null event pointer cannot be trimmed.");
            }
            this.ptrValues = this.ptrValues.subList(0, this.ptrValues.size() - 1);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canDecrement() {
            if (this.isNull()) {
                return false;
            }
            int lastValue = this.ptrValues.get(this.ptrValues.size() - 1);
            return lastValue > 0;
        }

        public void decrement() {
            if (!this.canDecrement()) {
                throw new IllegalStateException("the event pointer cannot be decremented.");
            }
            if (this.isProceedPointer()) {
                throw new IllegalStateException("the event pointer cannot be decremented.");
            }
            ArrayList<Integer> newPtrValue = new ArrayList<Integer>(this.ptrValues.subList(0, this.ptrValues.size() - 1));
            int lastValue = this.ptrValues.get(this.ptrValues.size() - 1) - 1;
            newPtrValue.add(lastValue);
            this.ptrValues = newPtrValue;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object other) {
            if (!(other instanceof EventPointer)) {
                return false;
            }
            EventPointer otherPointer = (EventPointer)other;
            return this.ptrValues.equals(otherPointer.ptrValues);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isProceedPointer() {
            if (this.ptrValues.isEmpty()) {
                return false;
            }
            int lastPtrValue = this.ptrValues.get(this.ptrValues.size() - 1);
            return lastPtrValue == 0;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.ptrValues.hashCode();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isNull() {
            return this.ptrValues.isEmpty() && this.patternVar.equals("");
        }

        public @UnknownKeyFor @NonNull @Initialized String getPatternVar() {
            return this.patternVar;
        }

        public @UnknownKeyFor @NonNull @Initialized EventPointer copy() {
            ArrayList<Integer> newPtrValue = new ArrayList<Integer>(this.ptrValues);
            return new EventPointer(newPtrValue, this.patternVar);
        }

        public @UnknownKeyFor @NonNull @Initialized EventPointer getNewProceedPointer(@UnknownKeyFor @NonNull @Initialized int value, @UnknownKeyFor @NonNull @Initialized String patternVar) {
            ArrayList<Integer> newPtrValue = new ArrayList<Integer>(this.ptrValues);
            newPtrValue.add(value);
            return new EventPointer(newPtrValue, patternVar);
        }

        public @UnknownKeyFor @NonNull @Initialized EventPointer getNewTakePointer(@UnknownKeyFor @NonNull @Initialized int value) {
            ArrayList<Integer> newPtrValue = new ArrayList<Integer>(this.ptrValues);
            newPtrValue.set(newPtrValue.size() - 1, value);
            return new EventPointer(newPtrValue, this.patternVar);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            ArrayList<String> ptrValuesCopy = new ArrayList<String>();
            for (Integer i : this.ptrValues) {
                ptrValuesCopy.add(i.toString());
            }
            return String.join((CharSequence)".", ptrValuesCopy);
        }
    }

    private static class Event
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized EventPointer, @UnknownKeyFor @NonNull @Initialized Event> prevEvents = new HashMap();
        private @UnknownKeyFor @NonNull @Initialized Row row;
        private @UnknownKeyFor @NonNull @Initialized Schema upstreamSchema;

        Event(@UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized Schema upstreamSchema) {
            this.row = inputRow;
            this.upstreamSchema = upstreamSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized CEPLiteral toCEPLiteral(@UnknownKeyFor @NonNull @Initialized CEPFieldRef fieldRef) {
            int fieldIndex = fieldRef.getIndex();
            Schema.Field field = this.upstreamSchema.getField(fieldIndex);
            Schema.FieldType type = field.getType();
            switch (type.getTypeName()) {
                case BYTE: {
                    return CEPLiteral.of(this.row.getByte(fieldIndex));
                }
                case INT16: {
                    return CEPLiteral.of(this.row.getInt16(fieldIndex));
                }
                case INT32: {
                    return CEPLiteral.of(this.row.getInt32(fieldIndex));
                }
                case INT64: {
                    return CEPLiteral.of(this.row.getInt64(fieldIndex));
                }
                case DECIMAL: {
                    return CEPLiteral.of(this.row.getDecimal(fieldIndex));
                }
                case FLOAT: {
                    return CEPLiteral.of(this.row.getFloat(fieldIndex));
                }
                case DOUBLE: {
                    return CEPLiteral.of(this.row.getDouble(fieldIndex));
                }
                case DATETIME: {
                    return CEPLiteral.of(this.row.getDateTime(fieldIndex));
                }
                case BOOLEAN: {
                    return CEPLiteral.of(this.row.getBoolean(fieldIndex));
                }
                case STRING: {
                    return CEPLiteral.of(this.row.getString(fieldIndex));
                }
            }
            throw new UnsupportedOperationException("The type is not supported: " + type.getTypeName().toString());
        }

        private @UnknownKeyFor @NonNull @Initialized Event findEvent(@UnknownKeyFor @NonNull @Initialized EventPointer eventPointer) {
            return this.prevEvents.getOrDefault(eventPointer, null);
        }

        private @UnknownKeyFor @NonNull @Initialized EventPointer findEventPointer(@UnknownKeyFor @NonNull @Initialized EventPointer pointer) {
            for (EventPointer i : this.prevEvents.keySet()) {
                if (!i.equals(pointer)) continue;
                return i.copy();
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized EventPointer getPrevPointer(@UnknownKeyFor @NonNull @Initialized EventPointer curPointer) {
            if (curPointer.isNull()) {
                return null;
            }
            if (curPointer.isProceedPointer()) {
                while (this.findEvent(curPointer) == null && curPointer.canTrim()) {
                    curPointer.trim();
                }
                return this.findEventPointer(curPointer);
            }
            while (this.findEvent(curPointer) == null) {
                if (curPointer.canDecrement()) {
                    curPointer.decrement();
                    continue;
                }
                return null;
            }
            return curPointer;
        }

        public @UnknownKeyFor @NonNull @Initialized Row getRow() {
            return this.row;
        }

        public void addPrevEvent(@UnknownKeyFor @NonNull @Initialized EventPointer ptr, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Event prevEvent) {
            this.prevEvents.put(ptr, prevEvent);
        }
    }
}

