/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.util.List;
import org.apache.beam.sdk.extensions.protobuf.ProtoMessageSchema;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamKafkaProtoTable
extends BeamKafkaTable {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> protoClass;

    public BeamKafkaProtoTable(@UnknownKeyFor @NonNull @Initialized Schema messageSchema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> protoClass) {
        super(BeamKafkaProtoTable.inferAndVerifySchema(protoClass, messageSchema), bootstrapServers, topics);
        this.protoClass = protoClass;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> getPTransformForInput() {
        return new ProtoRecorderDecoder(this.schema, this.protoClass);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> getPTransformForOutput() {
        return new ProtoRecorderEncoder(this.protoClass);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema inferAndVerifySchema(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> protoClass, @UnknownKeyFor @NonNull @Initialized Schema messageSchema) {
        Schema inferredSchema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(protoClass));
        if (!messageSchema.equivalent(inferredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from protobuf class.%nProtobuf class: '%s'%nInferred schema: '%s'", messageSchema, protoClass.getName(), inferredSchema));
        }
        return inferredSchema;
    }

    private static class ProtoRecorderEncoder
    extends PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz;

        public ProtoRecorderEncoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            this.clazz = clazz;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            SimpleFunction toBytesFn = ProtoMessageSchema.getRowToProtoBytesFn(this.clazz);
            return (PCollection)((PCollection)input.apply("Encode proto bytes to row", (PTransform)MapElements.via((SimpleFunction)toBytesFn))).apply("Bytes to KV", (PTransform)MapElements.via((SimpleFunction)new BytesToKV()));
        }

        private static class BytesToKV
        extends SimpleFunction<byte[], KV<byte[], byte[]>> {
            private BytesToKV() {
            }

            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
                return KV.of((Object)new byte[0], (Object)bytes);
            }
        }
    }

    private static class ProtoRecorderDecoder
    extends PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz;

        ProtoRecorderDecoder(@UnknownKeyFor @NonNull @Initialized Schema schema, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            this.schema = schema;
            this.clazz = clazz;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
            SimpleFunction toRowFn = ProtoMessageSchema.getProtoBytesToRowFn(this.clazz);
            return ((PCollection)((PCollection)input.apply("decodeProtoRecord", (PTransform)MapElements.via((SimpleFunction)new KvToBytes()))).apply("Map bytes to rows", (PTransform)MapElements.via((SimpleFunction)toRowFn))).setRowSchema(this.schema);
        }

        private static class KvToBytes
        extends SimpleFunction<KV<byte[], byte[]>, byte[]> {
            private KvToBytes() {
            }

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> kv) {
                return (byte[])kv.getValue();
            }
        }
    }
}

