/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Filter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Project;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamBasicAggregationRule
extends RelOptRule {
    public static final @UnknownKeyFor @NonNull @Initialized BeamBasicAggregationRule INSTANCE = new BeamBasicAggregationRule(Aggregate.class, RelFactories.LOGICAL_BUILDER);

    public BeamBasicAggregationRule(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Aggregate> aggregateClass, @UnknownKeyFor @NonNull @Initialized RelBuilderFactory relBuilderFactory) {
        super(BeamBasicAggregationRule.operand(aggregateClass, (RelOptRuleOperand)BeamBasicAggregationRule.operand(RelNode.class, (RelOptRuleOperandChildren)BeamBasicAggregationRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    public void onMatch(@UnknownKeyFor @NonNull @Initialized RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode relNode = call.rel(1);
        if ((relNode instanceof Project || relNode instanceof Calc || relNode instanceof Filter) && (BeamBasicAggregationRule.isWindowed(relNode) || BeamBasicAggregationRule.hasWindowedParents(relNode))) {
            return;
        }
        RelNode newTableScan = relNode.copy(relNode.getTraitSet(), relNode.getInputs());
        call.transformTo((RelNode)new BeamAggregationRel(aggregate.getCluster(), aggregate.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE), BeamBasicAggregationRule.convert((RelNode)newTableScan, (RelTraitSet)newTableScan.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE)), aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList(), null, -1));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isWindowed(@UnknownKeyFor @NonNull @Initialized RelNode node) {
        List<Object> projects = null;
        if (node instanceof Project) {
            projects = new ArrayList(((Project)node).getProjects());
        } else if (node instanceof Calc) {
            projects = ((Calc)node).getProgram().getProjectList().stream().map(rexLocalRef -> (RexNode)((Calc)node).getProgram().getExprList().get(rexLocalRef.getIndex())).collect(Collectors.toList());
        }
        if (projects != null) {
            for (RexNode projNode : projects) {
                SqlKind sqlKind;
                if (!(projNode instanceof RexCall) || (sqlKind = ((RexCall)projNode).op.kind) != SqlKind.SESSION && sqlKind != SqlKind.HOP && sqlKind != SqlKind.TUMBLE) continue;
                return true;
            }
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasWindowedParents(@UnknownKeyFor @NonNull @Initialized RelNode node) {
        ArrayList parents = new ArrayList();
        for (RelNode inputNode : node.getInputs()) {
            if (!(inputNode instanceof RelSubset)) continue;
            parents.addAll(((RelSubset)inputNode).getParentRels());
            parents.addAll(((RelSubset)inputNode).getRelList());
        }
        for (RelNode parent : parents) {
            if (!BeamBasicAggregationRule.isWindowed(parent)) continue;
            return true;
        }
        return false;
    }
}

