/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStatsMetadata;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSqlRelUtils {
    public static @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        return BeamSqlRelUtils.toPCollection(pipeline, node, new HashMap<Integer, PCollection<Row>>());
    }

    private static @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> buildPCollectionList(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputRels, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> cache) {
        if (inputRels.isEmpty()) {
            return PCollectionList.empty((Pipeline)pipeline);
        }
        return PCollectionList.of((Iterable)inputRels.stream().map(input -> BeamSqlRelUtils.toPCollection(pipeline, (BeamRelNode)input, cache)).collect(Collectors.toList()));
    }

    static @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BeamRelNode node, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> cache) {
        PCollection output = cache.get(node.getId());
        if (output != null) {
            return output;
        }
        String name = node.getClass().getSimpleName() + "_" + node.getId();
        PCollectionList<Row> input = BeamSqlRelUtils.buildPCollectionList(node.getPCollectionInputs(), pipeline, cache);
        PTransform<PCollectionList<Row>, PCollection<Row>> transform = node.buildPTransform();
        output = (PCollection)Pipeline.applyTransform((String)name, input, transform);
        cache.put(node.getId(), (PCollection<Row>)output);
        return output;
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamRelNode getBeamRelInput(@UnknownKeyFor @NonNull @Initialized RelNode input) {
        if (input instanceof RelSubset) {
            input = ((RelSubset)input).getBest();
        }
        return (BeamRelNode)input;
    }

    public static @UnknownKeyFor @NonNull @Initialized RelNode getInput(@UnknownKeyFor @NonNull @Initialized RelNode input) {
        RelNode result = input;
        if (input instanceof RelSubset) {
            result = ((RelSubset)input).getBest();
            result = result == null ? ((RelSubset)input).getOriginal() : result;
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized NodeStats getNodeStats(@UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        input = BeamSqlRelUtils.getInput(input);
        return ((NodeStatsMetadata)input.metadata(NodeStatsMetadata.class, mq)).getNodeStats();
    }
}

