/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CEPCall
extends CEPOperation {
    private final @UnknownKeyFor @NonNull @Initialized CEPOperator operator;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPOperation> operands;

    private CEPCall(@UnknownKeyFor @NonNull @Initialized CEPOperator operator, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPOperation> operands) {
        this.operator = operator;
        this.operands = operands;
    }

    public @UnknownKeyFor @NonNull @Initialized CEPOperator getOperator() {
        return this.operator;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPOperation> getOperands() {
        return this.operands;
    }

    public static @UnknownKeyFor @NonNull @Initialized CEPCall of(@UnknownKeyFor @NonNull @Initialized RexCall operation) {
        SqlOperator call = operation.getOperator();
        CEPOperator myOp = CEPOperator.of(call);
        ArrayList<CEPOperation> operandsList = new ArrayList<CEPOperation>();
        for (RexNode i : operation.getOperands()) {
            if (i.getClass() == RexCall.class) {
                CEPCall callToAdd = CEPCall.of((RexCall)i);
                operandsList.add(callToAdd);
                continue;
            }
            if (i.getClass() == RexLiteral.class) {
                RexLiteral lit = (RexLiteral)i;
                CEPLiteral litToAdd = CEPLiteral.of(lit);
                operandsList.add(litToAdd);
                continue;
            }
            if (i.getClass() == RexPatternFieldRef.class) {
                RexPatternFieldRef fieldRef = (RexPatternFieldRef)i;
                CEPFieldRef fieldRefToAdd = CEPFieldRef.of(fieldRef);
                operandsList.add(fieldRefToAdd);
                continue;
            }
            throw new UnsupportedOperationException("RexNode not supported: " + i.getClass().getName());
        }
        return new CEPCall(myOp, operandsList);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        ArrayList<String> operandStrings = new ArrayList<String>();
        for (CEPOperation i : this.operands) {
            operandStrings.add(i.toString());
        }
        return this.operator.toString() + "(" + String.join((CharSequence)", ", operandStrings) + ")";
    }
}

