/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.avro;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.avro.GenericRecordWriteConverter;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;

public class AvroTable
extends SchemaBaseBeamTable
implements Serializable {
    private final String filePattern;
    private final String tableName;

    public AvroTable(String tableName, org.apache.beam.sdk.schemas.Schema beamSchema, String filePattern) {
        super(beamSchema);
        this.filePattern = filePattern;
        this.tableName = tableName;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)((PCollection)begin.apply("AvroIORead", (PTransform)AvroIO.readGenericRecords((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.schema, (String)this.tableName, null)).withBeamSchemas(true).from(this.filePattern))).apply("GenericRecordToRow", Convert.toRows());
    }

    public PDone buildIOWriter(PCollection<Row> input) {
        GenericRecordWriteConverter writeConverter = GenericRecordWriteConverter.builder().beamSchema(this.schema).build();
        return (PDone)((PCollection)input.apply("GenericRecordToRow", (PTransform)writeConverter)).apply("AvroIOWrite", (PTransform)AvroIO.writeGenericRecords((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.schema, (String)this.tableName, null)).to(this.filePattern).withoutSharding());
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.BOUNDED_UNKNOWN;
    }
}

