/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_TVFSlidingWindowFn;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;

@AutoValue
public abstract class TVFSlidingWindowFn
extends NonMergingWindowFn<Object, IntervalWindow> {
    public abstract Duration getSize();

    public abstract Duration getPeriod();

    public static TVFSlidingWindowFn of(Duration size, Duration period) {
        return new AutoValue_TVFSlidingWindowFn(size, period);
    }

    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        Row curRow = (Row)c.element();
        return Arrays.asList(new IntervalWindow(curRow.getDateTime("window_start").toInstant(), curRow.getDateTime("window_end").toInstant()));
    }

    public boolean isCompatible(WindowFn<?, ?> other) {
        return ((Object)((Object)this)).equals(other);
    }

    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
        throw new UnsupportedOperationException("TVFSlidingWindow does not support side input windows.");
    }
}

