/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Schemas;

public class BeamCalciteSchema
implements Schema {
    private JdbcConnection connection;
    private TableProvider tableProvider;
    private Map<String, BeamCalciteSchema> subSchemas;

    BeamCalciteSchema(JdbcConnection jdbcConnection, TableProvider tableProvider) {
        this.connection = jdbcConnection;
        this.tableProvider = tableProvider;
        this.subSchemas = new HashMap<String, BeamCalciteSchema>();
    }

    public TableProvider getTableProvider() {
        return this.tableProvider;
    }

    public Map<String, String> getPipelineOptions() {
        return this.connection.getPipelineOptionsMap();
    }

    public void setPipelineOption(String key, String value) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.put(key, value);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removePipelineOption(String key) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.remove(key);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removeAllPipelineOptions() {
        this.connection.setPipelineOptionsMap(Collections.emptyMap());
    }

    public boolean isMutable() {
        return true;
    }

    public Schema snapshot(SchemaVersion version) {
        return this;
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression((SchemaPlus)parentSchema, (String)name, this.getClass());
    }

    public Set<String> getTableNames() {
        return this.tableProvider.getTables().keySet();
    }

    public RelProtoDataType getType(String name) {
        return null;
    }

    public Set<String> getTypeNames() {
        return Collections.emptySet();
    }

    public org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table getTable(String name) {
        Table table = this.tableProvider.getTable(name);
        if (table == null) {
            return null;
        }
        return new BeamCalciteTable(this.tableProvider.buildBeamSqlTable(table), this.getPipelineOptions(), this.connection.getPipelineOptions());
    }

    public Set<String> getFunctionNames() {
        return Collections.emptySet();
    }

    public Collection<Function> getFunctions(String name) {
        return Collections.emptySet();
    }

    public Set<String> getSubSchemaNames() {
        return this.tableProvider.getSubProviders();
    }

    public Schema getSubSchema(String name) {
        if (!this.subSchemas.containsKey(name)) {
            TableProvider subProvider = this.tableProvider.getSubProvider(name);
            BeamCalciteSchema subSchema = subProvider == null ? null : new BeamCalciteSchema(this.connection, subProvider);
            this.subSchemas.put(name, subSchema);
        }
        return this.subSchemas.get(name);
    }
}

