/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamUnnestRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.SingleRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;

public class BeamUnnestRule
extends RelOptRule {
    public static final BeamUnnestRule INSTANCE = new BeamUnnestRule();

    private BeamUnnestRule() {
        super(BeamUnnestRule.operand(LogicalCorrelate.class, (RelOptRuleOperand)BeamUnnestRule.operand(RelNode.class, (RelOptRuleOperandChildren)BeamUnnestRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{BeamUnnestRule.operand(SingleRel.class, (RelOptRuleOperandChildren)BeamUnnestRule.any())}), "BeamUnnestRule");
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode project;
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        RelNode outer = call.rel(1);
        RelNode uncollect = call.rel(2);
        if (correlate.getCorrelationId().getId() != 0) {
            return;
        }
        if (correlate.getRequiredColumns().cardinality() != 1) {
            return;
        }
        if (correlate.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (!(uncollect instanceof Uncollect)) {
            if ((uncollect = ((SingleRel)uncollect).getInput()) instanceof RelSubset) {
                uncollect = ((RelSubset)uncollect).getOriginal();
            }
            if (!(uncollect instanceof Uncollect)) {
                return;
            }
        }
        if ((project = ((Uncollect)uncollect).getInput()) instanceof RelSubset) {
            project = ((RelSubset)project).getOriginal();
        }
        if (!(project instanceof LogicalProject)) {
            return;
        }
        if (((LogicalProject)project).getProjects().size() != 1) {
            return;
        }
        RexNode exp = (RexNode)((LogicalProject)project).getProjects().get(0);
        if (!(exp instanceof RexFieldAccess)) {
            return;
        }
        int fieldIndex = ((RexFieldAccess)exp).getField().getIndex();
        call.transformTo((RelNode)new BeamUnnestRel(correlate.getCluster(), correlate.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE), outer, call.rel(2).getRowType(), fieldIndex));
    }
}

