/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.function.IntFunction;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.BitString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.commons.lang.StringEscapeUtils;

public class BeamSqlUnparseContext
extends SqlImplementor.SimpleContext {
    public BeamSqlUnparseContext(IntFunction<SqlNode> field) {
        super(BeamBigQuerySqlDialect.DEFAULT, field);
    }

    public SqlNode toSql(RexProgram program, RexNode rex) {
        if (rex.getKind().equals((Object)SqlKind.LITERAL)) {
            RexLiteral literal = (RexLiteral)rex;
            SqlTypeFamily family = literal.getTypeName().getFamily();
            if (SqlTypeFamily.BINARY.equals((Object)family)) {
                ByteString byteString = (ByteString)literal.getValueAs(ByteString.class);
                BitString bitString = BitString.createFromHexString((String)byteString.toString(16));
                return new SqlByteStringLiteral(bitString, SqlImplementor.POS);
            }
            if (SqlTypeFamily.CHARACTER.equals((Object)family)) {
                String escaped = StringEscapeUtils.escapeJava((String)((String)literal.getValueAs(String.class)));
                return SqlLiteral.createCharString((String)escaped, (SqlParserPos)SqlImplementor.POS);
            }
            if (SqlTypeName.SYMBOL.equals((Object)literal.getTypeName())) {
                Enum symbol = (Enum)literal.getValueAs(Enum.class);
                if (TimeUnitRange.DOW.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFWEEK");
                }
                if (TimeUnitRange.DOY.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFYEAR");
                }
                if (TimeUnitRange.WEEK.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "ISOWEEK");
                }
            }
        }
        return super.toSql(program, rex);
    }

    private static class ReplaceLiteral
    extends SqlLiteral {
        private final String newValue;

        ReplaceLiteral(RexLiteral literal, SqlParserPos pos, String newValue) {
            super((Object)literal.getValue(), literal.getTypeName(), pos);
            this.newValue = newValue;
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.literal(this.newValue);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplaceLiteral)) {
                return false;
            }
            if (!this.newValue.equals(((ReplaceLiteral)((Object)obj)).newValue)) {
                return false;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class SqlByteStringLiteral
    extends SqlLiteral {
        SqlByteStringLiteral(BitString bytes, SqlParserPos pos) {
            super((Object)bytes, SqlTypeName.BINARY, pos);
        }

        public SqlByteStringLiteral clone(SqlParserPos pos) {
            return new SqlByteStringLiteral((BitString)this.value, pos);
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            assert (this.value instanceof BitString);
            StringBuilder builder = new StringBuilder("B'");
            for (byte b : ((BitString)this.value).getAsByteArray()) {
                builder.append(String.format("\\x%02X", b));
            }
            builder.append("'");
            writer.literal(builder.toString());
        }
    }
}

