/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Set;
import org.apache.beam.sdk.extensions.joinlibrary.Join;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamJoinRel;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamJoinTransforms;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.joda.time.Duration;

public class BeamCoGBKJoinRel
extends BeamJoinRel {
    public BeamCoGBKJoinRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new StandardJoin();
    }

    private <T> void verifySupportedTrigger(PCollection<T> pCollection) {
        WindowingStrategy windowingStrategy = pCollection.getWindowingStrategy();
        if (PCollection.IsBounded.UNBOUNDED.equals((Object)pCollection.isBounded()) && !this.triggersOncePerWindow(windowingStrategy)) {
            throw new UnsupportedOperationException("Joining unbounded PCollections is currently only supported for non-global windows with triggers that are known to produce output once per window,such as the default trigger with zero allowed lateness. In these cases Beam can guarantee it joins all input elements once per window. " + windowingStrategy + " is not supported");
        }
    }

    private boolean triggersOncePerWindow(WindowingStrategy windowingStrategy) {
        Trigger trigger = windowingStrategy.getTrigger();
        return !(windowingStrategy.getWindowFn() instanceof GlobalWindows) && trigger instanceof DefaultTrigger && Duration.ZERO.equals((Object)windowingStrategy.getAllowedLateness());
    }

    private PCollection<Row> standardJoin(PCollection<KV<Row, Row>> extractedLeftRows, PCollection<KV<Row, Row>> extractedRightRows, Schema leftSchema, Schema rightSchema) {
        PCollection joinedRows = null;
        switch (this.joinType) {
            case LEFT: {
                Schema rigthNullSchema = this.buildNullSchema(rightSchema);
                Row rightNullRow = Row.nullRow((Schema)rigthNullSchema);
                extractedRightRows = BeamCoGBKJoinRel.setValueCoder(extractedRightRows, SchemaCoder.of((Schema)rigthNullSchema));
                joinedRows = Join.leftOuterJoin(extractedLeftRows, extractedRightRows, (Object)rightNullRow);
                break;
            }
            case RIGHT: {
                Schema leftNullSchema = this.buildNullSchema(leftSchema);
                Row leftNullRow = Row.nullRow((Schema)leftNullSchema);
                extractedLeftRows = BeamCoGBKJoinRel.setValueCoder(extractedLeftRows, SchemaCoder.of((Schema)leftNullSchema));
                joinedRows = Join.rightOuterJoin(extractedLeftRows, extractedRightRows, (Object)leftNullRow);
                break;
            }
            case FULL: {
                Schema leftNullSchema = this.buildNullSchema(leftSchema);
                Schema rightNullSchema = this.buildNullSchema(rightSchema);
                Row leftNullRow = Row.nullRow((Schema)leftNullSchema);
                Row rightNullRow = Row.nullRow((Schema)rightNullSchema);
                extractedLeftRows = BeamCoGBKJoinRel.setValueCoder(extractedLeftRows, SchemaCoder.of((Schema)leftNullSchema));
                extractedRightRows = BeamCoGBKJoinRel.setValueCoder(extractedRightRows, SchemaCoder.of((Schema)rightNullSchema));
                joinedRows = Join.fullOuterJoin(extractedLeftRows, extractedRightRows, (Object)leftNullRow, (Object)rightNullRow);
                break;
            }
            default: {
                joinedRows = Join.innerJoin(extractedLeftRows, extractedRightRows);
            }
        }
        Schema schema = CalciteUtils.toSchema(this.getRowType());
        return ((PCollection)joinedRows.apply("JoinParts2WholeRow", (PTransform)MapElements.via((SimpleFunction)new BeamJoinTransforms.JoinParts2WholeRow(schema)))).setRowSchema(schema);
    }

    public org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BeamCoGBKJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    private class StandardJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private StandardJoin() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Schema leftSchema = CalciteUtils.toSchema(BeamCoGBKJoinRel.this.left.getRowType());
            Schema rightSchema = CalciteUtils.toSchema(BeamCoGBKJoinRel.this.right.getRowType());
            PCollectionList keyedInputs = (PCollectionList)pinput.apply((PTransform)new BeamJoinRel.ExtractJoinKeys());
            PCollection extractedLeftRows = keyedInputs.get(0);
            PCollection extractedRightRows = keyedInputs.get(1);
            WindowFn leftWinFn = extractedLeftRows.getWindowingStrategy().getWindowFn();
            WindowFn rightWinFn = extractedRightRows.getWindowingStrategy().getWindowFn();
            try {
                leftWinFn.verifyCompatibility(rightWinFn);
            }
            catch (IncompatibleWindowException e) {
                throw new IllegalArgumentException("WindowFns must match for a bounded-vs-bounded/unbounded-vs-unbounded join.", e);
            }
            BeamCoGBKJoinRel.this.verifySupportedTrigger(extractedLeftRows);
            BeamCoGBKJoinRel.this.verifySupportedTrigger(extractedRightRows);
            return BeamCoGBKJoinRel.this.standardJoin((PCollection<KV<Row, Row>>)extractedLeftRows, (PCollection<KV<Row, Row>>)extractedRightRows, leftSchema, rightSchema);
        }
    }
}

