/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.TextRowCountEstimator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TextTable
extends SchemaBaseBeamTable {
    private final PTransform<PCollection<String>, PCollection<Row>> readConverter;
    private final PTransform<PCollection<Row>, PCollection<String>> writeConverter;
    private static final TextRowCountEstimator.SamplingStrategy DEFAULT_SAMPLING_STRATEGY = new TextRowCountEstimator.LimitNumberOfTotalBytes(0x100000L);
    private final String filePattern;
    private BeamTableStatistics rowCountStatistics = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(TextTable.class);

    public TextTable(Schema schema, String filePattern, PTransform<PCollection<String>, PCollection<Row>> readConverter, PTransform<PCollection<Row>, PCollection<String>> writeConverter) {
        super(schema);
        this.filePattern = filePattern;
        this.readConverter = readConverter;
        this.writeConverter = writeConverter;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        if (this.rowCountStatistics == null) {
            this.rowCountStatistics = TextTable.getTextRowEstimate(options, this.getFilePattern());
        }
        return this.rowCountStatistics;
    }

    private static BeamTableStatistics getTextRowEstimate(PipelineOptions options, String filePattern) {
        TextRowCountEstimator textRowCountEstimator = TextRowCountEstimator.builder().setFilePattern(filePattern).setSamplingStrategy(DEFAULT_SAMPLING_STRATEGY).build();
        try {
            Double rows = textRowCountEstimator.estimateRowCount(options);
            return BeamTableStatistics.createBoundedTableStatistics(rows);
        }
        catch (IOException | TextRowCountEstimator.NoEstimationException e) {
            LOGGER.warn("Could not get the row count for the text table " + filePattern, e);
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)((PCollection)begin.apply("ReadTextFiles", (PTransform)TextIO.read().from(this.filePattern))).apply("StringToRow", this.readConverter);
    }

    public PDone buildIOWriter(PCollection<Row> input) {
        return (PDone)((PCollection)input.apply("RowToString", this.writeConverter)).apply("WriteTextFiles", (PTransform)TextIO.write().withDelimiter(new char[0]).to(this.filePattern));
    }
}

