/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubJsonTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.RowToPubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTagList;

@Internal
@Experimental
class PubsubIOJsonTable
extends BaseBeamTable
implements Serializable {
    protected final PubsubJsonTableProvider.PubsubIOTableConfiguration config;

    private PubsubIOJsonTable(PubsubJsonTableProvider.PubsubIOTableConfiguration config) {
        this.config = config;
    }

    static PubsubIOJsonTable withConfiguration(PubsubJsonTableProvider.PubsubIOTableConfiguration config) {
        return new PubsubIOJsonTable(config);
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    @Override
    public Schema getSchema() {
        return this.config.getSchema();
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)begin.apply("readFromPubsub", this.readMessagesWithAttributes())).apply("parseMessageToRow", this.createParserParDo());
        rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG).setRowSchema(this.getSchema());
        if (this.config.useDlq()) {
            rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply(this.writeMessagesToDlq());
        }
        return rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG);
    }

    private ParDo.MultiOutput<PubsubMessage, Row> createParserParDo() {
        return ParDo.of((DoFn)PubsubMessageToRow.builder().messageSchema(this.getSchema()).useDlq(this.config.useDlq()).useFlatSchema(this.config.getUseFlatSchema()).build()).withOutputTags(PubsubMessageToRow.MAIN_TAG, this.config.useDlq() ? TupleTagList.of(PubsubMessageToRow.DLQ_TAG) : TupleTagList.empty());
    }

    private PubsubIO.Read<PubsubMessage> readMessagesWithAttributes() {
        PubsubIO.Read read = PubsubIO.readMessagesWithAttributes().fromTopic(this.config.getTopic());
        return this.config.useTimestampAttribute() ? read.withTimestampAttribute(this.config.getTimestampAttribute()) : read;
    }

    private PubsubIO.Write<PubsubMessage> writeMessagesToDlq() {
        PubsubIO.Write write = PubsubIO.writeMessages().to(this.config.getDeadLetterQueue());
        return this.config.useTimestampAttribute() ? write.withTimestampAttribute(this.config.getTimestampAttribute()) : write;
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        if (!this.config.getUseFlatSchema()) {
            throw new UnsupportedOperationException("Writing to a Pubsub topic is only supported for flattened schemas");
        }
        return ((PCollection)input.apply((PTransform)RowToPubsubMessage.fromTableConfig(this.config))).apply(this.createPubsubMessageWrite());
    }

    private PubsubIO.Write<PubsubMessage> createPubsubMessageWrite() {
        PubsubIO.Write write = PubsubIO.writeMessages().to(this.config.getTopic());
        if (this.config.useTimestampAttribute()) {
            write = write.withTimestampAttribute(this.config.getTimestampAttribute());
        }
        return write;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.UNBOUNDED_UNKNOWN;
    }
}

