/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udf;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.sdk.extensions.sql.impl.udf.UDF;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.function.Strict;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BuiltinStringFunctions
extends BeamBuiltinFunctionProvider {
    @UDF(funcName="ENDS_WITH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public Boolean endsWith(String str1, String str2) {
        return str1.endsWith(str2);
    }

    @UDF(funcName="STARTS_WITH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public Boolean startsWith(String str1, String str2) {
        return str1.startsWith(str2);
    }

    @UDF(funcName="LENGTH", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.INT64)
    @Strict
    public Long lengthString(String str) {
        return str.length();
    }

    @UDF(funcName="LENGTH", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.INT64)
    @Strict
    public Long lengthBytes(byte[] bytes) {
        return bytes.length;
    }

    @UDF(funcName="REVERSE", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public String reverseString(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    @UDF(funcName="REVERSE", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] reverseBytes(byte[] bytes) {
        byte[] ret = Arrays.copyOf(bytes, bytes.length);
        ArrayUtils.reverse((byte[])ret);
        return ret;
    }

    @UDF(funcName="FROM_HEX", parameterArray={Schema.TypeName.STRING}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] fromHex(String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    @UDF(funcName="TO_HEX", parameterArray={Schema.TypeName.BYTES}, returnType=Schema.TypeName.STRING)
    @Strict
    public String toHex(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64}, returnType=Schema.TypeName.STRING)
    @Strict
    public String lpad(String originalValue, Long returnLength) {
        return this.lpad(originalValue, returnLength, " ");
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64, Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public String lpad(String originalValue, Long returnLength, String pattern) {
        if (returnLength < -1L || pattern.isEmpty()) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        if ((long)originalValue.length() == returnLength) {
            return originalValue;
        }
        if ((long)originalValue.length() < returnLength) {
            return StringUtils.leftPad((String)originalValue, (int)Math.toIntExact(returnLength), (String)pattern);
        }
        return originalValue.substring(0, Math.toIntExact(returnLength));
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] lpad(byte[] originalValue, Long returnLength) {
        return this.lpad(originalValue, returnLength, " ".getBytes(StandardCharsets.UTF_8));
    }

    @UDF(funcName="LPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64, Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] lpad(byte[] originalValue, Long returnLength, byte[] pattern) {
        if (returnLength < -1L || pattern.length == 0) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        int returnLengthInt = Math.toIntExact(returnLength);
        if (originalValue.length == returnLengthInt) {
            return originalValue;
        }
        if (originalValue.length < returnLengthInt) {
            byte[] ret = new byte[returnLengthInt];
            int paddingOff = 0;
            int paddingLeftBytes = returnLengthInt - originalValue.length;
            this.byteArrayPadding(ret, pattern, paddingOff, paddingLeftBytes);
            System.arraycopy(originalValue, 0, ret, returnLengthInt - originalValue.length, originalValue.length);
            return ret;
        }
        byte[] ret = new byte[returnLengthInt];
        System.arraycopy(originalValue, 0, ret, 0, returnLengthInt);
        return ret;
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64}, returnType=Schema.TypeName.STRING)
    @Strict
    public String rpad(String originalValue, Long returnLength) {
        return this.lpad(originalValue, returnLength, " ");
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.STRING, Schema.TypeName.INT64, Schema.TypeName.STRING}, returnType=Schema.TypeName.STRING)
    @Strict
    public String rpad(String originalValue, Long returnLength, String pattern) {
        if (returnLength < -1L || pattern.isEmpty()) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        if ((long)originalValue.length() == returnLength) {
            return originalValue;
        }
        if ((long)originalValue.length() < returnLength) {
            return StringUtils.rightPad((String)originalValue, (int)Math.toIntExact(returnLength), (String)pattern);
        }
        return originalValue.substring(0, Math.toIntExact(returnLength));
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] rpad(byte[] originalValue, Long returnLength) {
        return this.lpad(originalValue, returnLength, " ".getBytes(StandardCharsets.UTF_8));
    }

    @UDF(funcName="RPAD", parameterArray={Schema.TypeName.BYTES, Schema.TypeName.INT64, Schema.TypeName.BYTES}, returnType=Schema.TypeName.BYTES)
    @Strict
    public byte[] rpad(byte[] originalValue, Long returnLength, byte[] pattern) {
        if (returnLength < -1L || pattern.length == 0) {
            throw new IllegalArgumentException("returnLength cannot be 0 or pattern cannot be empty.");
        }
        int returnLengthInt = Math.toIntExact(returnLength);
        if (originalValue.length == returnLengthInt) {
            return originalValue;
        }
        if (originalValue.length < returnLengthInt) {
            byte[] ret = new byte[returnLengthInt];
            System.arraycopy(originalValue, 0, ret, 0, originalValue.length);
            int paddingOff = originalValue.length;
            int paddingLeftBytes = returnLengthInt - originalValue.length;
            this.byteArrayPadding(ret, pattern, paddingOff, paddingLeftBytes);
            return ret;
        }
        byte[] ret = new byte[returnLengthInt];
        System.arraycopy(originalValue, 0, ret, 0, returnLengthInt);
        return ret;
    }

    private void byteArrayPadding(byte[] dest, byte[] pattern, int paddingOff, int paddingLeftBytes) {
        while (paddingLeftBytes > 0) {
            if (paddingLeftBytes >= pattern.length) {
                System.arraycopy(pattern, 0, dest, paddingOff, pattern.length);
                paddingLeftBytes -= pattern.length;
                paddingOff += pattern.length;
                continue;
            }
            System.arraycopy(pattern, 0, dest, paddingOff, paddingLeftBytes);
            paddingLeftBytes = 0;
        }
    }
}

