/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import java.util.Objects;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;

public class BeamCostModel
implements RelOptCost {
    private static final double RATE_IMPORTANCE = 3600.0;
    static final BeamCostModel INFINITY = new BeamCostModel(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final BeamCostModel HUGE = new BeamCostModel(Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final BeamCostModel ZERO = new BeamCostModel(0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final BeamCostModel TINY = new BeamCostModel(1.0, 0.001){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    public static final Factory FACTORY = new Factory();
    final double cpu;
    final double cpuRate;

    BeamCostModel(double cpu, double cpuRate) {
        this.cpu = Math.max(cpu, 0.0);
        this.cpuRate = Math.max(cpuRate, 0.0);
    }

    public double getCpu() {
        return this.cpu;
    }

    public boolean isInfinite() {
        return this.equals(INFINITY) || this.cpu == Double.POSITIVE_INFINITY || this.cpuRate == Double.POSITIVE_INFINITY;
    }

    public double getIo() {
        return 0.0;
    }

    public double getCpuRate() {
        return this.cpuRate;
    }

    public boolean isLe(RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (this.isInfinite() || that.isInfinite()) {
            return that.isInfinite();
        }
        return BeamCostModel.getCostCombination(this) <= BeamCostModel.getCostCombination(that);
    }

    public boolean isLt(RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (that.isInfinite() || this.isInfinite()) {
            return !this.isInfinite();
        }
        return BeamCostModel.getCostCombination(this) < BeamCostModel.getCostCombination(that);
    }

    private static double getCostCombination(BeamCostModel cost) {
        return cost.cpu + cost.cpuRate * 3600.0;
    }

    public double getRows() {
        return 0.0;
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.cpuRate);
    }

    public boolean equals(RelOptCost other) {
        return other instanceof BeamCostModel && this.cpu == ((BeamCostModel)other).cpu && this.cpuRate == ((BeamCostModel)other).cpuRate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeamCostModel) {
            return this.equals((BeamCostModel)obj);
        }
        return false;
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof BeamCostModel)) {
            return false;
        }
        BeamCostModel that = (BeamCostModel)other;
        return Math.abs(this.cpu - that.cpu) < 1.0E-5 && Math.abs(this.cpuRate - that.cpuRate) < 1.0E-5;
    }

    public BeamCostModel minus(RelOptCost other) {
        if (this.equals(INFINITY)) {
            return this;
        }
        BeamCostModel that = (BeamCostModel)other;
        return new BeamCostModel(this.cpu - that.cpu, this.cpuRate - that.cpuRate);
    }

    public BeamCostModel multiplyBy(double factor) {
        if (this.equals(INFINITY)) {
            return this;
        }
        return new BeamCostModel(this.cpu * factor, this.cpuRate * factor);
    }

    public double divideBy(RelOptCost cost) {
        BeamCostModel that = (BeamCostModel)cost;
        if (BeamCostModel.getCostCombination(this) != 0.0 && !Double.isInfinite(BeamCostModel.getCostCombination(this)) && BeamCostModel.getCostCombination(that) != 0.0 && !Double.isInfinite(BeamCostModel.getCostCombination(that))) {
            return BeamCostModel.getCostCombination(this) / BeamCostModel.getCostCombination(that);
        }
        return 1.0;
    }

    public BeamCostModel plus(RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (this.equals(INFINITY) || that.equals(INFINITY)) {
            return INFINITY;
        }
        return new BeamCostModel(this.cpu + that.cpu, this.cpuRate + that.cpuRate);
    }

    public String toString() {
        return "{" + this.cpu + " cpu, " + this.cpuRate + " cpuRate }";
    }

    public static BeamCostModel convertRelOptCost(RelOptCost ic) {
        BeamCostModel inputCost = ic instanceof BeamCostModel ? (BeamCostModel)ic : FACTORY.makeCost(ic.getRows(), ic.getCpu(), ic.getIo());
        return inputCost;
    }

    public static class Factory
    implements RelOptCostFactory {
        public BeamCostModel makeCost(double dRows, double dCpu, double dIo) {
            return INFINITY;
        }

        public BeamCostModel makeCost(double dCpu, double dCpuRate) {
            return new BeamCostModel(dCpu, dCpuRate);
        }

        public BeamCostModel makeHugeCost() {
            return HUGE;
        }

        public BeamCostModel makeInfiniteCost() {
            return INFINITY;
        }

        public BeamCostModel makeTinyCost() {
            return TINY;
        }

        public BeamCostModel makeZeroCost() {
            return ZERO;
        }
    }
}

