// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * A subquery in an expression (not a FROM clause).  The subquery runs
 * in the context of a single input row and produces a single output value.
 * Correlated subqueries can be thought of like functions, with a parameter
 * list.  The &lt;parameter_list&gt; gives the set of ResolvedColumns from outside
 * the subquery that are used inside.
 * Inside the subquery, the only allowed references to values outside the
 * subquery are to the named ColumnRefs listed in &lt;parameter_list&gt;.
 * Any reference to one of these parameters will be represented as a
 * ResolvedColumnRef with &lt;is_correlated&gt; set to true.
 * These parameters are only visible through one level of expression
 * subquery.  An expression subquery inside an expression has to list
 * parameters again if parameters from the outer query are passed down
 * further.  (This does not apply for table subqueries inside an expression
 * subquery.  Table subqueries are never indicated in the resolved AST, so
 * Scan nodes inside an expression query may have come from a nested table
 * subquery, and they can still reference the expression subquery's
 * parameters.)
 * An empty &lt;parameter_list&gt; means that the subquery is uncorrelated.  It is
 * permissable to run an uncorrelated subquery only once and reuse the result.
 * TODO Do we want to specify semantics more firmly here?
 * The semantics vary based on SubqueryType:
 *   SCALAR
 *     Usage: ( &lt;subquery&gt; )
 *     If the subquery produces zero rows, the output value is NULL.
 *     If the subquery produces exactly one row, that row is the output value.
 *     If the subquery produces more than one row, raise a runtime error.
 *   ARRAY
 *     Usage: ARRAY( &lt;subquery&gt; )
 *     The subquery produces an array value with zero or more rows, with
 *     one array element per subquery row produced.
 *   EXISTS
 *     Usage: EXISTS( &lt;subquery&gt; )
 *     The output type is always bool.  The result is true if the subquery
 *     produces at least one row, and false otherwise.
 *   IN
 *     Usage: &lt;in_expr&gt; [NOT] IN ( &lt;subquery&gt; )
 *     The output type is always bool.  The result is true when &lt;in_expr&gt; is
 *     equal to at least one row, and false otherwise.  The &lt;subquery&gt; row
 *     contains only one column, and the types of &lt;in_expr&gt; and the
 *     subquery column must exactly match a built-in signature for the
 *     '$equals' comparison function (they must be the same type or one
 *     must be INT64 and the other UINT64).  NOT will be expressed as a $not
 *     FunctionCall wrapping this SubqueryExpr.
 * The subquery for a SCALAR or ARRAY or IN subquery must have exactly one
 * output column.
 * The output type for a SCALAR or ARRAY subquery is that column's type or
 * an array of that column's type.  (The subquery scan may include a Project
 * with a MakeStruct or MakeProto expression to construct a single value
 * from multiple columns.)
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedSubqueryExprProto}
 */
public  final class ResolvedSubqueryExprProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedSubqueryExprProto)
    ResolvedSubqueryExprProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedSubqueryExprProto.newBuilder() to construct.
  private ResolvedSubqueryExprProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedSubqueryExprProto() {
    subqueryType_ = 0;
    parameterList_ = java.util.Collections.emptyList();
    hintList_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResolvedSubqueryExprProto(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            com.google.zetasql.ResolvedExprProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000001) == 0x00000001)) {
              subBuilder = parent_.toBuilder();
            }
            parent_ = input.readMessage(com.google.zetasql.ResolvedExprProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(parent_);
              parent_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000001;
            break;
          }
          case 16: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType value = com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(2, rawValue);
            } else {
              bitField0_ |= 0x00000002;
              subqueryType_ = rawValue;
            }
            break;
          }
          case 26: {
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              parameterList_ = new java.util.ArrayList<com.google.zetasql.ResolvedColumnRefProto>();
              mutable_bitField0_ |= 0x00000004;
            }
            parameterList_.add(
                input.readMessage(com.google.zetasql.ResolvedColumnRefProto.PARSER, extensionRegistry));
            break;
          }
          case 34: {
            com.google.zetasql.AnyResolvedExprProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000004) == 0x00000004)) {
              subBuilder = inExpr_.toBuilder();
            }
            inExpr_ = input.readMessage(com.google.zetasql.AnyResolvedExprProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(inExpr_);
              inExpr_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000004;
            break;
          }
          case 42: {
            com.google.zetasql.AnyResolvedScanProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000008) == 0x00000008)) {
              subBuilder = subquery_.toBuilder();
            }
            subquery_ = input.readMessage(com.google.zetasql.AnyResolvedScanProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(subquery_);
              subquery_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000008;
            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              hintList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>();
              mutable_bitField0_ |= 0x00000020;
            }
            hintList_.add(
                input.readMessage(com.google.zetasql.ResolvedOptionProto.PARSER, extensionRegistry));
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        parameterList_ = java.util.Collections.unmodifiableList(parameterList_);
      }
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        hintList_ = java.util.Collections.unmodifiableList(hintList_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedSubqueryExprProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedSubqueryExprProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedSubqueryExprProto.class, com.google.zetasql.ResolvedSubqueryExprProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedExprProto parent_;
  /**
   * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
   */
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) == 0x00000001);
  }
  /**
   * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedExprProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedExprProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedExprProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedExprProto.getDefaultInstance() : parent_;
  }

  public static final int SUBQUERY_TYPE_FIELD_NUMBER = 2;
  private int subqueryType_;
  /**
   * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
   */
  public boolean hasSubqueryType() {
    return ((bitField0_ & 0x00000002) == 0x00000002);
  }
  /**
   * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
   */
  public com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType getSubqueryType() {
    @SuppressWarnings("deprecation")
    com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType result = com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType.valueOf(subqueryType_);
    return result == null ? com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType.SCALAR : result;
  }

  public static final int PARAMETER_LIST_FIELD_NUMBER = 3;
  private java.util.List<com.google.zetasql.ResolvedColumnRefProto> parameterList_;
  /**
   * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedColumnRefProto> getParameterListList() {
    return parameterList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedColumnRefProtoOrBuilder> 
      getParameterListOrBuilderList() {
    return parameterList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
   */
  public int getParameterListCount() {
    return parameterList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
   */
  public com.google.zetasql.ResolvedColumnRefProto getParameterList(int index) {
    return parameterList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
   */
  public com.google.zetasql.ResolvedColumnRefProtoOrBuilder getParameterListOrBuilder(
      int index) {
    return parameterList_.get(index);
  }

  public static final int IN_EXPR_FIELD_NUMBER = 4;
  private com.google.zetasql.AnyResolvedExprProto inExpr_;
  /**
   * <pre>
   * Field is only populated for subquery of type IN.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
   */
  public boolean hasInExpr() {
    return ((bitField0_ & 0x00000004) == 0x00000004);
  }
  /**
   * <pre>
   * Field is only populated for subquery of type IN.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
   */
  public com.google.zetasql.AnyResolvedExprProto getInExpr() {
    return inExpr_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : inExpr_;
  }
  /**
   * <pre>
   * Field is only populated for subquery of type IN.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
   */
  public com.google.zetasql.AnyResolvedExprProtoOrBuilder getInExprOrBuilder() {
    return inExpr_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : inExpr_;
  }

  public static final int SUBQUERY_FIELD_NUMBER = 5;
  private com.google.zetasql.AnyResolvedScanProto subquery_;
  /**
   * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
   */
  public boolean hasSubquery() {
    return ((bitField0_ & 0x00000008) == 0x00000008);
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
   */
  public com.google.zetasql.AnyResolvedScanProto getSubquery() {
    return subquery_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : subquery_;
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
   */
  public com.google.zetasql.AnyResolvedScanProtoOrBuilder getSubqueryOrBuilder() {
    return subquery_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : subquery_;
  }

  public static final int HINT_LIST_FIELD_NUMBER = 6;
  private java.util.List<com.google.zetasql.ResolvedOptionProto> hintList_;
  /**
   * <pre>
   * Note: Hints currently happen only for EXISTS or IN subquery but
   * not for ARRAY or SCALAR subquery.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedOptionProto> getHintListList() {
    return hintList_;
  }
  /**
   * <pre>
   * Note: Hints currently happen only for EXISTS or IN subquery but
   * not for ARRAY or SCALAR subquery.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
      getHintListOrBuilderList() {
    return hintList_;
  }
  /**
   * <pre>
   * Note: Hints currently happen only for EXISTS or IN subquery but
   * not for ARRAY or SCALAR subquery.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
   */
  public int getHintListCount() {
    return hintList_.size();
  }
  /**
   * <pre>
   * Note: Hints currently happen only for EXISTS or IN subquery but
   * not for ARRAY or SCALAR subquery.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
   */
  public com.google.zetasql.ResolvedOptionProto getHintList(int index) {
    return hintList_.get(index);
  }
  /**
   * <pre>
   * Note: Hints currently happen only for EXISTS or IN subquery but
   * not for ARRAY or SCALAR subquery.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
   */
  public com.google.zetasql.ResolvedOptionProtoOrBuilder getHintListOrBuilder(
      int index) {
    return hintList_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    if (hasParent()) {
      if (!getParent().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    for (int i = 0; i < getParameterListCount(); i++) {
      if (!getParameterList(i).isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    if (hasInExpr()) {
      if (!getInExpr().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    if (hasSubquery()) {
      if (!getSubquery().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    for (int i = 0; i < getHintListCount(); i++) {
      if (!getHintList(i).isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) == 0x00000001)) {
      output.writeMessage(1, getParent());
    }
    if (((bitField0_ & 0x00000002) == 0x00000002)) {
      output.writeEnum(2, subqueryType_);
    }
    for (int i = 0; i < parameterList_.size(); i++) {
      output.writeMessage(3, parameterList_.get(i));
    }
    if (((bitField0_ & 0x00000004) == 0x00000004)) {
      output.writeMessage(4, getInExpr());
    }
    if (((bitField0_ & 0x00000008) == 0x00000008)) {
      output.writeMessage(5, getSubquery());
    }
    for (int i = 0; i < hintList_.size(); i++) {
      output.writeMessage(6, hintList_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) == 0x00000001)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getParent());
    }
    if (((bitField0_ & 0x00000002) == 0x00000002)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, subqueryType_);
    }
    for (int i = 0; i < parameterList_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, parameterList_.get(i));
    }
    if (((bitField0_ & 0x00000004) == 0x00000004)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getInExpr());
    }
    if (((bitField0_ & 0x00000008) == 0x00000008)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getSubquery());
    }
    for (int i = 0; i < hintList_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, hintList_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.zetasql.ResolvedSubqueryExprProto)) {
      return super.equals(obj);
    }
    com.google.zetasql.ResolvedSubqueryExprProto other = (com.google.zetasql.ResolvedSubqueryExprProto) obj;

    boolean result = true;
    result = result && (hasParent() == other.hasParent());
    if (hasParent()) {
      result = result && getParent()
          .equals(other.getParent());
    }
    result = result && (hasSubqueryType() == other.hasSubqueryType());
    if (hasSubqueryType()) {
      result = result && subqueryType_ == other.subqueryType_;
    }
    result = result && getParameterListList()
        .equals(other.getParameterListList());
    result = result && (hasInExpr() == other.hasInExpr());
    if (hasInExpr()) {
      result = result && getInExpr()
          .equals(other.getInExpr());
    }
    result = result && (hasSubquery() == other.hasSubquery());
    if (hasSubquery()) {
      result = result && getSubquery()
          .equals(other.getSubquery());
    }
    result = result && getHintListList()
        .equals(other.getHintListList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasParent()) {
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
    }
    if (hasSubqueryType()) {
      hash = (37 * hash) + SUBQUERY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + subqueryType_;
    }
    if (getParameterListCount() > 0) {
      hash = (37 * hash) + PARAMETER_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getParameterListList().hashCode();
    }
    if (hasInExpr()) {
      hash = (37 * hash) + IN_EXPR_FIELD_NUMBER;
      hash = (53 * hash) + getInExpr().hashCode();
    }
    if (hasSubquery()) {
      hash = (37 * hash) + SUBQUERY_FIELD_NUMBER;
      hash = (53 * hash) + getSubquery().hashCode();
    }
    if (getHintListCount() > 0) {
      hash = (37 * hash) + HINT_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getHintListList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedSubqueryExprProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedSubqueryExprProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A subquery in an expression (not a FROM clause).  The subquery runs
   * in the context of a single input row and produces a single output value.
   * Correlated subqueries can be thought of like functions, with a parameter
   * list.  The &lt;parameter_list&gt; gives the set of ResolvedColumns from outside
   * the subquery that are used inside.
   * Inside the subquery, the only allowed references to values outside the
   * subquery are to the named ColumnRefs listed in &lt;parameter_list&gt;.
   * Any reference to one of these parameters will be represented as a
   * ResolvedColumnRef with &lt;is_correlated&gt; set to true.
   * These parameters are only visible through one level of expression
   * subquery.  An expression subquery inside an expression has to list
   * parameters again if parameters from the outer query are passed down
   * further.  (This does not apply for table subqueries inside an expression
   * subquery.  Table subqueries are never indicated in the resolved AST, so
   * Scan nodes inside an expression query may have come from a nested table
   * subquery, and they can still reference the expression subquery's
   * parameters.)
   * An empty &lt;parameter_list&gt; means that the subquery is uncorrelated.  It is
   * permissable to run an uncorrelated subquery only once and reuse the result.
   * TODO Do we want to specify semantics more firmly here?
   * The semantics vary based on SubqueryType:
   *   SCALAR
   *     Usage: ( &lt;subquery&gt; )
   *     If the subquery produces zero rows, the output value is NULL.
   *     If the subquery produces exactly one row, that row is the output value.
   *     If the subquery produces more than one row, raise a runtime error.
   *   ARRAY
   *     Usage: ARRAY( &lt;subquery&gt; )
   *     The subquery produces an array value with zero or more rows, with
   *     one array element per subquery row produced.
   *   EXISTS
   *     Usage: EXISTS( &lt;subquery&gt; )
   *     The output type is always bool.  The result is true if the subquery
   *     produces at least one row, and false otherwise.
   *   IN
   *     Usage: &lt;in_expr&gt; [NOT] IN ( &lt;subquery&gt; )
   *     The output type is always bool.  The result is true when &lt;in_expr&gt; is
   *     equal to at least one row, and false otherwise.  The &lt;subquery&gt; row
   *     contains only one column, and the types of &lt;in_expr&gt; and the
   *     subquery column must exactly match a built-in signature for the
   *     '$equals' comparison function (they must be the same type or one
   *     must be INT64 and the other UINT64).  NOT will be expressed as a $not
   *     FunctionCall wrapping this SubqueryExpr.
   * The subquery for a SCALAR or ARRAY or IN subquery must have exactly one
   * output column.
   * The output type for a SCALAR or ARRAY subquery is that column's type or
   * an array of that column's type.  (The subquery scan may include a Project
   * with a MakeStruct or MakeProto expression to construct a single value
   * from multiple columns.)
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedSubqueryExprProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedSubqueryExprProto)
      com.google.zetasql.ResolvedSubqueryExprProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedSubqueryExprProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedSubqueryExprProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedSubqueryExprProto.class, com.google.zetasql.ResolvedSubqueryExprProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedSubqueryExprProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getParameterListFieldBuilder();
        getInExprFieldBuilder();
        getSubqueryFieldBuilder();
        getHintListFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      subqueryType_ = 0;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (parameterListBuilder_ == null) {
        parameterList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        parameterListBuilder_.clear();
      }
      if (inExprBuilder_ == null) {
        inExpr_ = null;
      } else {
        inExprBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (subqueryBuilder_ == null) {
        subquery_ = null;
      } else {
        subqueryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (hintListBuilder_ == null) {
        hintList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        hintListBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedSubqueryExprProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedSubqueryExprProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedSubqueryExprProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedSubqueryExprProto build() {
      com.google.zetasql.ResolvedSubqueryExprProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedSubqueryExprProto buildPartial() {
      com.google.zetasql.ResolvedSubqueryExprProto result = new com.google.zetasql.ResolvedSubqueryExprProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
        to_bitField0_ |= 0x00000001;
      }
      if (parentBuilder_ == null) {
        result.parent_ = parent_;
      } else {
        result.parent_ = parentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
        to_bitField0_ |= 0x00000002;
      }
      result.subqueryType_ = subqueryType_;
      if (parameterListBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          parameterList_ = java.util.Collections.unmodifiableList(parameterList_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.parameterList_ = parameterList_;
      } else {
        result.parameterList_ = parameterListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
        to_bitField0_ |= 0x00000004;
      }
      if (inExprBuilder_ == null) {
        result.inExpr_ = inExpr_;
      } else {
        result.inExpr_ = inExprBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
        to_bitField0_ |= 0x00000008;
      }
      if (subqueryBuilder_ == null) {
        result.subquery_ = subquery_;
      } else {
        result.subquery_ = subqueryBuilder_.build();
      }
      if (hintListBuilder_ == null) {
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          hintList_ = java.util.Collections.unmodifiableList(hintList_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.hintList_ = hintList_;
      } else {
        result.hintList_ = hintListBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.zetasql.ResolvedSubqueryExprProto) {
        return mergeFrom((com.google.zetasql.ResolvedSubqueryExprProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.zetasql.ResolvedSubqueryExprProto other) {
      if (other == com.google.zetasql.ResolvedSubqueryExprProto.getDefaultInstance()) return this;
      if (other.hasParent()) {
        mergeParent(other.getParent());
      }
      if (other.hasSubqueryType()) {
        setSubqueryType(other.getSubqueryType());
      }
      if (parameterListBuilder_ == null) {
        if (!other.parameterList_.isEmpty()) {
          if (parameterList_.isEmpty()) {
            parameterList_ = other.parameterList_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureParameterListIsMutable();
            parameterList_.addAll(other.parameterList_);
          }
          onChanged();
        }
      } else {
        if (!other.parameterList_.isEmpty()) {
          if (parameterListBuilder_.isEmpty()) {
            parameterListBuilder_.dispose();
            parameterListBuilder_ = null;
            parameterList_ = other.parameterList_;
            bitField0_ = (bitField0_ & ~0x00000004);
            parameterListBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getParameterListFieldBuilder() : null;
          } else {
            parameterListBuilder_.addAllMessages(other.parameterList_);
          }
        }
      }
      if (other.hasInExpr()) {
        mergeInExpr(other.getInExpr());
      }
      if (other.hasSubquery()) {
        mergeSubquery(other.getSubquery());
      }
      if (hintListBuilder_ == null) {
        if (!other.hintList_.isEmpty()) {
          if (hintList_.isEmpty()) {
            hintList_ = other.hintList_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureHintListIsMutable();
            hintList_.addAll(other.hintList_);
          }
          onChanged();
        }
      } else {
        if (!other.hintList_.isEmpty()) {
          if (hintListBuilder_.isEmpty()) {
            hintListBuilder_.dispose();
            hintListBuilder_ = null;
            hintList_ = other.hintList_;
            bitField0_ = (bitField0_ & ~0x00000020);
            hintListBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getHintListFieldBuilder() : null;
          } else {
            hintListBuilder_.addAllMessages(other.hintList_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      if (hasParent()) {
        if (!getParent().isInitialized()) {
          return false;
        }
      }
      for (int i = 0; i < getParameterListCount(); i++) {
        if (!getParameterList(i).isInitialized()) {
          return false;
        }
      }
      if (hasInExpr()) {
        if (!getInExpr().isInitialized()) {
          return false;
        }
      }
      if (hasSubquery()) {
        if (!getSubquery().isInitialized()) {
          return false;
        }
      }
      for (int i = 0; i < getHintListCount(); i++) {
        if (!getHintList(i).isInitialized()) {
          return false;
        }
      }
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.zetasql.ResolvedSubqueryExprProto parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.zetasql.ResolvedSubqueryExprProto) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedExprProto parent_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedExprProto, com.google.zetasql.ResolvedExprProto.Builder, com.google.zetasql.ResolvedExprProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedExprProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedExprProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedExprProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedExprProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedExprProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) == 0x00000001) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedExprProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedExprProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedExprProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedExprProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedExprProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedExprProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedExprProto, com.google.zetasql.ResolvedExprProto.Builder, com.google.zetasql.ResolvedExprProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedExprProto, com.google.zetasql.ResolvedExprProto.Builder, com.google.zetasql.ResolvedExprProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private int subqueryType_ = 0;
    /**
     * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
     */
    public boolean hasSubqueryType() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
     */
    public com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType getSubqueryType() {
      @SuppressWarnings("deprecation")
      com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType result = com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType.valueOf(subqueryType_);
      return result == null ? com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType.SCALAR : result;
    }
    /**
     * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
     */
    public Builder setSubqueryType(com.google.zetasql.resolvedast.ResolvedSubqueryExprEnums.SubqueryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      subqueryType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedSubqueryExprEnums.SubqueryType subquery_type = 2;</code>
     */
    public Builder clearSubqueryType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      subqueryType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.zetasql.ResolvedColumnRefProto> parameterList_ =
      java.util.Collections.emptyList();
    private void ensureParameterListIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        parameterList_ = new java.util.ArrayList<com.google.zetasql.ResolvedColumnRefProto>(parameterList_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedColumnRefProto, com.google.zetasql.ResolvedColumnRefProto.Builder, com.google.zetasql.ResolvedColumnRefProtoOrBuilder> parameterListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedColumnRefProto> getParameterListList() {
      if (parameterListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameterList_);
      } else {
        return parameterListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public int getParameterListCount() {
      if (parameterListBuilder_ == null) {
        return parameterList_.size();
      } else {
        return parameterListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnRefProto getParameterList(int index) {
      if (parameterListBuilder_ == null) {
        return parameterList_.get(index);
      } else {
        return parameterListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder setParameterList(
        int index, com.google.zetasql.ResolvedColumnRefProto value) {
      if (parameterListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterListIsMutable();
        parameterList_.set(index, value);
        onChanged();
      } else {
        parameterListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder setParameterList(
        int index, com.google.zetasql.ResolvedColumnRefProto.Builder builderForValue) {
      if (parameterListBuilder_ == null) {
        ensureParameterListIsMutable();
        parameterList_.set(index, builderForValue.build());
        onChanged();
      } else {
        parameterListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder addParameterList(com.google.zetasql.ResolvedColumnRefProto value) {
      if (parameterListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterListIsMutable();
        parameterList_.add(value);
        onChanged();
      } else {
        parameterListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder addParameterList(
        int index, com.google.zetasql.ResolvedColumnRefProto value) {
      if (parameterListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterListIsMutable();
        parameterList_.add(index, value);
        onChanged();
      } else {
        parameterListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder addParameterList(
        com.google.zetasql.ResolvedColumnRefProto.Builder builderForValue) {
      if (parameterListBuilder_ == null) {
        ensureParameterListIsMutable();
        parameterList_.add(builderForValue.build());
        onChanged();
      } else {
        parameterListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder addParameterList(
        int index, com.google.zetasql.ResolvedColumnRefProto.Builder builderForValue) {
      if (parameterListBuilder_ == null) {
        ensureParameterListIsMutable();
        parameterList_.add(index, builderForValue.build());
        onChanged();
      } else {
        parameterListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder addAllParameterList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedColumnRefProto> values) {
      if (parameterListBuilder_ == null) {
        ensureParameterListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, parameterList_);
        onChanged();
      } else {
        parameterListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder clearParameterList() {
      if (parameterListBuilder_ == null) {
        parameterList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        parameterListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public Builder removeParameterList(int index) {
      if (parameterListBuilder_ == null) {
        ensureParameterListIsMutable();
        parameterList_.remove(index);
        onChanged();
      } else {
        parameterListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnRefProto.Builder getParameterListBuilder(
        int index) {
      return getParameterListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnRefProtoOrBuilder getParameterListOrBuilder(
        int index) {
      if (parameterListBuilder_ == null) {
        return parameterList_.get(index);  } else {
        return parameterListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedColumnRefProtoOrBuilder> 
         getParameterListOrBuilderList() {
      if (parameterListBuilder_ != null) {
        return parameterListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameterList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnRefProto.Builder addParameterListBuilder() {
      return getParameterListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedColumnRefProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public com.google.zetasql.ResolvedColumnRefProto.Builder addParameterListBuilder(
        int index) {
      return getParameterListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedColumnRefProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedColumnRefProto parameter_list = 3;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedColumnRefProto.Builder> 
         getParameterListBuilderList() {
      return getParameterListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedColumnRefProto, com.google.zetasql.ResolvedColumnRefProto.Builder, com.google.zetasql.ResolvedColumnRefProtoOrBuilder> 
        getParameterListFieldBuilder() {
      if (parameterListBuilder_ == null) {
        parameterListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedColumnRefProto, com.google.zetasql.ResolvedColumnRefProto.Builder, com.google.zetasql.ResolvedColumnRefProtoOrBuilder>(
                parameterList_,
                ((bitField0_ & 0x00000004) == 0x00000004),
                getParentForChildren(),
                isClean());
        parameterList_ = null;
      }
      return parameterListBuilder_;
    }

    private com.google.zetasql.AnyResolvedExprProto inExpr_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> inExprBuilder_;
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public boolean hasInExpr() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto getInExpr() {
      if (inExprBuilder_ == null) {
        return inExpr_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : inExpr_;
      } else {
        return inExprBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public Builder setInExpr(com.google.zetasql.AnyResolvedExprProto value) {
      if (inExprBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inExpr_ = value;
        onChanged();
      } else {
        inExprBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public Builder setInExpr(
        com.google.zetasql.AnyResolvedExprProto.Builder builderForValue) {
      if (inExprBuilder_ == null) {
        inExpr_ = builderForValue.build();
        onChanged();
      } else {
        inExprBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public Builder mergeInExpr(com.google.zetasql.AnyResolvedExprProto value) {
      if (inExprBuilder_ == null) {
        if (((bitField0_ & 0x00000008) == 0x00000008) &&
            inExpr_ != null &&
            inExpr_ != com.google.zetasql.AnyResolvedExprProto.getDefaultInstance()) {
          inExpr_ =
            com.google.zetasql.AnyResolvedExprProto.newBuilder(inExpr_).mergeFrom(value).buildPartial();
        } else {
          inExpr_ = value;
        }
        onChanged();
      } else {
        inExprBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public Builder clearInExpr() {
      if (inExprBuilder_ == null) {
        inExpr_ = null;
        onChanged();
      } else {
        inExprBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto.Builder getInExprBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInExprFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    public com.google.zetasql.AnyResolvedExprProtoOrBuilder getInExprOrBuilder() {
      if (inExprBuilder_ != null) {
        return inExprBuilder_.getMessageOrBuilder();
      } else {
        return inExpr_ == null ?
            com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : inExpr_;
      }
    }
    /**
     * <pre>
     * Field is only populated for subquery of type IN.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto in_expr = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> 
        getInExprFieldBuilder() {
      if (inExprBuilder_ == null) {
        inExprBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder>(
                getInExpr(),
                getParentForChildren(),
                isClean());
        inExpr_ = null;
      }
      return inExprBuilder_;
    }

    private com.google.zetasql.AnyResolvedScanProto subquery_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> subqueryBuilder_;
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public boolean hasSubquery() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public com.google.zetasql.AnyResolvedScanProto getSubquery() {
      if (subqueryBuilder_ == null) {
        return subquery_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : subquery_;
      } else {
        return subqueryBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public Builder setSubquery(com.google.zetasql.AnyResolvedScanProto value) {
      if (subqueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subquery_ = value;
        onChanged();
      } else {
        subqueryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public Builder setSubquery(
        com.google.zetasql.AnyResolvedScanProto.Builder builderForValue) {
      if (subqueryBuilder_ == null) {
        subquery_ = builderForValue.build();
        onChanged();
      } else {
        subqueryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public Builder mergeSubquery(com.google.zetasql.AnyResolvedScanProto value) {
      if (subqueryBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010) &&
            subquery_ != null &&
            subquery_ != com.google.zetasql.AnyResolvedScanProto.getDefaultInstance()) {
          subquery_ =
            com.google.zetasql.AnyResolvedScanProto.newBuilder(subquery_).mergeFrom(value).buildPartial();
        } else {
          subquery_ = value;
        }
        onChanged();
      } else {
        subqueryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public Builder clearSubquery() {
      if (subqueryBuilder_ == null) {
        subquery_ = null;
        onChanged();
      } else {
        subqueryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public com.google.zetasql.AnyResolvedScanProto.Builder getSubqueryBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSubqueryFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    public com.google.zetasql.AnyResolvedScanProtoOrBuilder getSubqueryOrBuilder() {
      if (subqueryBuilder_ != null) {
        return subqueryBuilder_.getMessageOrBuilder();
      } else {
        return subquery_ == null ?
            com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : subquery_;
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto subquery = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> 
        getSubqueryFieldBuilder() {
      if (subqueryBuilder_ == null) {
        subqueryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder>(
                getSubquery(),
                getParentForChildren(),
                isClean());
        subquery_ = null;
      }
      return subqueryBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedOptionProto> hintList_ =
      java.util.Collections.emptyList();
    private void ensureHintListIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        hintList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>(hintList_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> hintListBuilder_;

    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto> getHintListList() {
      if (hintListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(hintList_);
      } else {
        return hintListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public int getHintListCount() {
      if (hintListBuilder_ == null) {
        return hintList_.size();
      } else {
        return hintListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public com.google.zetasql.ResolvedOptionProto getHintList(int index) {
      if (hintListBuilder_ == null) {
        return hintList_.get(index);
      } else {
        return hintListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder setHintList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (hintListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHintListIsMutable();
        hintList_.set(index, value);
        onChanged();
      } else {
        hintListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder setHintList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (hintListBuilder_ == null) {
        ensureHintListIsMutable();
        hintList_.set(index, builderForValue.build());
        onChanged();
      } else {
        hintListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder addHintList(com.google.zetasql.ResolvedOptionProto value) {
      if (hintListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHintListIsMutable();
        hintList_.add(value);
        onChanged();
      } else {
        hintListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder addHintList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (hintListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHintListIsMutable();
        hintList_.add(index, value);
        onChanged();
      } else {
        hintListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder addHintList(
        com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (hintListBuilder_ == null) {
        ensureHintListIsMutable();
        hintList_.add(builderForValue.build());
        onChanged();
      } else {
        hintListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder addHintList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (hintListBuilder_ == null) {
        ensureHintListIsMutable();
        hintList_.add(index, builderForValue.build());
        onChanged();
      } else {
        hintListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder addAllHintList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedOptionProto> values) {
      if (hintListBuilder_ == null) {
        ensureHintListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, hintList_);
        onChanged();
      } else {
        hintListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder clearHintList() {
      if (hintListBuilder_ == null) {
        hintList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        hintListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public Builder removeHintList(int index) {
      if (hintListBuilder_ == null) {
        ensureHintListIsMutable();
        hintList_.remove(index);
        onChanged();
      } else {
        hintListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder getHintListBuilder(
        int index) {
      return getHintListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public com.google.zetasql.ResolvedOptionProtoOrBuilder getHintListOrBuilder(
        int index) {
      if (hintListBuilder_ == null) {
        return hintList_.get(index);  } else {
        return hintListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
         getHintListOrBuilderList() {
      if (hintListBuilder_ != null) {
        return hintListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(hintList_);
      }
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addHintListBuilder() {
      return getHintListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addHintListBuilder(
        int index) {
      return getHintListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Note: Hints currently happen only for EXISTS or IN subquery but
     * not for ARRAY or SCALAR subquery.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedOptionProto hint_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto.Builder> 
         getHintListBuilderList() {
      return getHintListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> 
        getHintListFieldBuilder() {
      if (hintListBuilder_ == null) {
        hintListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder>(
                hintList_,
                ((bitField0_ & 0x00000020) == 0x00000020),
                getParentForChildren(),
                isClean());
        hintList_ = null;
      }
      return hintListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedSubqueryExprProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedSubqueryExprProto)
  private static final com.google.zetasql.ResolvedSubqueryExprProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedSubqueryExprProto();
  }

  public static com.google.zetasql.ResolvedSubqueryExprProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedSubqueryExprProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedSubqueryExprProto>() {
    @java.lang.Override
    public ResolvedSubqueryExprProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResolvedSubqueryExprProto(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResolvedSubqueryExprProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedSubqueryExprProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedSubqueryExprProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

