// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * This statement creates a user-defined function:
 *   CREATE [TEMP] FUNCTION [IF NOT EXISTS] &lt;name_path&gt; (&lt;arg_list&gt;)
 *     [RETURNS &lt;return_type&gt;] [LANGUAGE &lt;language&gt;]
 *     [AS &lt;code&gt; | AS ( &lt;function_expression&gt; )] [OPTIONS (&lt;option_list&gt;)]
 *   &lt;name_path&gt; is the identifier path of the function.
 *   &lt;has_explicit_return_type&gt; is true iff RETURNS clause is present.
 *   &lt;return_type&gt; is the return type for the function, which can be any
 *          valid ZetaSQL type, including ARRAY or STRUCT. It is inferred
 *          from &lt;function_expression&gt; if not explicitly set.
 *          TODO: Deprecate and remove this. The return type is
 *          already specified by the &lt;signature&gt;.
 *   &lt;argument_name_list&gt; The names of the function arguments.
 *   &lt;signature&gt; is the FunctionSignature of the created function, with all
 *          options.  This can be used to create a Function to load into a
 *          Catalog for future queries.
 *   &lt;is_aggregate&gt; is true if this is an aggregate function.  All arguments
 *          are assumed to be aggregate input arguments that may vary for
 *          every row.
 *   &lt;language&gt; is the programming language used by the function. This field
 *          is set to 'SQL' for SQL functions and otherwise to the language
 *          name specified in the LANGUAGE clause.
 *   &lt;code&gt; is a string literal that contains the function definition.  Some
 *          engines may allow this argument to be omitted for certain types
 *          of external functions. This will always be set for SQL functions.
 *   &lt;aggregate_expression_list&gt; is a list of SQL aggregate functions to
 *          compute prior to computing the final &lt;function_expression&gt;.
 *          See below.
 *   &lt;function_expression&gt; is the resolved SQL expression invoked for the
 *          function. This will be unset for external language functions. For
 *          non-template SQL functions, this is a resolved representation of
 *          the expression in &lt;code&gt;.
 *   &lt;option_list&gt; has engine-specific directives for modifying functions.
 *   &lt;sql_security&gt; is the declared security mode for the function. Values
 *          include 'INVOKER', 'DEFINER'.
 * Note that &lt;function_expression&gt; and &lt;code&gt; are both marked as IGNORABLE
 * because an engine could look at either one (but might not look at both).
 * An engine must look at one (and cannot ignore both) to be semantically
 * valid, but there is currently no way to enforce that.
 * For aggregate functions, &lt;is_aggregate&gt; will be true.
 * Aggregate functions will only occur if LanguageOptions has
 * FEATURE_CREATE_AGGREGATE_FUNCTION enabled.
 * Arguments to aggregate functions must have
 * &lt;FunctionSignatureArgumentTypeOptions::is_not_aggregate&gt; true or false.
 * Non-aggregate arguments must be passed constant values only.
 * For SQL aggregate functions, there will be both an
 * &lt;aggregate_expression_list&gt;, with aggregate expressions to compute first,
 * and then a final &lt;function_expression&gt; to compute on the results
 * of the aggregates.  Each aggregate expression is a
 * ResolvedAggregateFunctionCall, and may reference any input arguments.
 * Each ResolvedComputedColumn in &lt;aggregate_expression_list&gt; gives the
 * aggregate expression a column id.  The final &lt;function_expression&gt; can
 * reference these created aggregate columns, and any input arguments
 * with &lt;argument_kind&gt;=NOT_AGGREGATE.
 * For example, with
 *   CREATE TEMP FUNCTION my_avg(x) = (SUM(x) / COUNT(x));
 * we would have an &lt;aggregate_expression_list&gt; with
 *   agg1#1 := SUM(ResolvedArgumentRef(x))
 *   agg2#2 := COUNT(ResolvedArgumentRef(x))
 * and a &lt;function_expression&gt;
 *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2)
 * For example, with
 *   CREATE FUNCTION scaled_avg(x,y NOT AGGREGATE) = (SUM(x) / COUNT(x) * y);
 * we would have an &lt;aggregate_expression_list&gt; with
 *   agg1#1 := SUM(ResolvedArgumentRef(x))
 *   agg2#2 := COUNT(ResolvedArgumentRef(x))
 * and a &lt;function_expression&gt;
 *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2) * ResolvedArgumentRef(y)
 * When resolving a query that calls an aggregate UDF, the query will
 * have a ResolvedAggregateScan that invokes the UDF function.  The engine
 * should remove the UDF aggregate function from the &lt;aggregate_list&gt;, and
 * instead compute the additional aggregates from the
 * UDF's &lt;aggregate_expression_list&gt;, and then add an additional Project
 * to compute the final &lt;function_expression&gt;, which should produce the
 * value for the original ResolvedAggregateScan's computed column for the
 * UDF.  Some rewrites of the ResolvedColumn references inside the UDF will
 * be required.  TODO If using ResolvedColumns makes this renaming
 * too complicated, we could switch to use ResolvedArgumentRefs, or
 * something new.
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedCreateFunctionStmtProto}
 */
public  final class ResolvedCreateFunctionStmtProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedCreateFunctionStmtProto)
    ResolvedCreateFunctionStmtProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedCreateFunctionStmtProto.newBuilder() to construct.
  private ResolvedCreateFunctionStmtProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedCreateFunctionStmtProto() {
    hasExplicitReturnType_ = false;
    argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    isAggregate_ = false;
    language_ = "";
    code_ = "";
    aggregateExpressionList_ = java.util.Collections.emptyList();
    optionList_ = java.util.Collections.emptyList();
    sqlSecurity_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResolvedCreateFunctionStmtProto(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            com.google.zetasql.ResolvedCreateStatementProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000001) == 0x00000001)) {
              subBuilder = parent_.toBuilder();
            }
            parent_ = input.readMessage(com.google.zetasql.ResolvedCreateStatementProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(parent_);
              parent_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000001;
            break;
          }
          case 26: {
            com.google.zetasql.ZetaSQLType.TypeProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000004) == 0x00000004)) {
              subBuilder = returnType_.toBuilder();
            }
            returnType_ = input.readMessage(com.google.zetasql.ZetaSQLType.TypeProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(returnType_);
              returnType_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000004;
            break;
          }
          case 34: {
            com.google.protobuf.ByteString bs = input.readBytes();
            bitField0_ |= 0x00000020;
            language_ = bs;
            break;
          }
          case 42: {
            com.google.protobuf.ByteString bs = input.readBytes();
            bitField0_ |= 0x00000040;
            code_ = bs;
            break;
          }
          case 50: {
            com.google.zetasql.AnyResolvedExprProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000080) == 0x00000080)) {
              subBuilder = functionExpression_.toBuilder();
            }
            functionExpression_ = input.readMessage(com.google.zetasql.AnyResolvedExprProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(functionExpression_);
              functionExpression_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000080;
            break;
          }
          case 58: {
            if (!((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
              optionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>();
              mutable_bitField0_ |= 0x00000400;
            }
            optionList_.add(
                input.readMessage(com.google.zetasql.ResolvedOptionProto.PARSER, extensionRegistry));
            break;
          }
          case 64: {
            bitField0_ |= 0x00000010;
            isAggregate_ = input.readBool();
            break;
          }
          case 74: {
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              aggregateExpressionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedComputedColumnProto>();
              mutable_bitField0_ |= 0x00000100;
            }
            aggregateExpressionList_.add(
                input.readMessage(com.google.zetasql.ResolvedComputedColumnProto.PARSER, extensionRegistry));
            break;
          }
          case 82: {
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder subBuilder = null;
            if (((bitField0_ & 0x00000008) == 0x00000008)) {
              subBuilder = signature_.toBuilder();
            }
            signature_ = input.readMessage(com.google.zetasql.FunctionProtos.FunctionSignatureProto.PARSER, extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(signature_);
              signature_ = subBuilder.buildPartial();
            }
            bitField0_ |= 0x00000008;
            break;
          }
          case 90: {
            com.google.protobuf.ByteString bs = input.readBytes();
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              argumentNameList_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000008;
            }
            argumentNameList_.add(bs);
            break;
          }
          case 96: {
            int rawValue = input.readEnum();
              @SuppressWarnings("deprecation")
            com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity value = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(rawValue);
            if (value == null) {
              unknownFields.mergeVarintField(12, rawValue);
            } else {
              bitField0_ |= 0x00000100;
              sqlSecurity_ = rawValue;
            }
            break;
          }
          case 104: {
            bitField0_ |= 0x00000002;
            hasExplicitReturnType_ = input.readBool();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
        optionList_ = java.util.Collections.unmodifiableList(optionList_);
      }
      if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
        aggregateExpressionList_ = java.util.Collections.unmodifiableList(aggregateExpressionList_);
      }
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        argumentNameList_ = argumentNameList_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedCreateFunctionStmtProto.class, com.google.zetasql.ResolvedCreateFunctionStmtProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedCreateStatementProto parent_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) == 0x00000001);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedCreateStatementProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }

  public static final int HAS_EXPLICIT_RETURN_TYPE_FIELD_NUMBER = 13;
  private boolean hasExplicitReturnType_;
  /**
   * <code>optional bool has_explicit_return_type = 13;</code>
   */
  public boolean hasHasExplicitReturnType() {
    return ((bitField0_ & 0x00000002) == 0x00000002);
  }
  /**
   * <code>optional bool has_explicit_return_type = 13;</code>
   */
  public boolean getHasExplicitReturnType() {
    return hasExplicitReturnType_;
  }

  public static final int RETURN_TYPE_FIELD_NUMBER = 3;
  private com.google.zetasql.ZetaSQLType.TypeProto returnType_;
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   */
  public boolean hasReturnType() {
    return ((bitField0_ & 0x00000004) == 0x00000004);
  }
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   */
  public com.google.zetasql.ZetaSQLType.TypeProto getReturnType() {
    return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
  }
  /**
   * <code>optional .zetasql.TypeProto return_type = 3;</code>
   */
  public com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder getReturnTypeOrBuilder() {
    return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
  }

  public static final int ARGUMENT_NAME_LIST_FIELD_NUMBER = 11;
  private com.google.protobuf.LazyStringList argumentNameList_;
  /**
   * <code>repeated string argument_name_list = 11;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getArgumentNameListList() {
    return argumentNameList_;
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   */
  public int getArgumentNameListCount() {
    return argumentNameList_.size();
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   */
  public java.lang.String getArgumentNameList(int index) {
    return argumentNameList_.get(index);
  }
  /**
   * <code>repeated string argument_name_list = 11;</code>
   */
  public com.google.protobuf.ByteString
      getArgumentNameListBytes(int index) {
    return argumentNameList_.getByteString(index);
  }

  public static final int SIGNATURE_FIELD_NUMBER = 10;
  private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_;
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   */
  public boolean hasSignature() {
    return ((bitField0_ & 0x00000008) == 0x00000008);
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   */
  public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
   */
  public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }

  public static final int IS_AGGREGATE_FIELD_NUMBER = 8;
  private boolean isAggregate_;
  /**
   * <code>optional bool is_aggregate = 8;</code>
   */
  public boolean hasIsAggregate() {
    return ((bitField0_ & 0x00000010) == 0x00000010);
  }
  /**
   * <code>optional bool is_aggregate = 8;</code>
   */
  public boolean getIsAggregate() {
    return isAggregate_;
  }

  public static final int LANGUAGE_FIELD_NUMBER = 4;
  private volatile java.lang.Object language_;
  /**
   * <code>optional string language = 4;</code>
   */
  public boolean hasLanguage() {
    return ((bitField0_ & 0x00000020) == 0x00000020);
  }
  /**
   * <code>optional string language = 4;</code>
   */
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        language_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string language = 4;</code>
   */
  public com.google.protobuf.ByteString
      getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_FIELD_NUMBER = 5;
  private volatile java.lang.Object code_;
  /**
   * <code>optional string code = 5;</code>
   */
  public boolean hasCode() {
    return ((bitField0_ & 0x00000040) == 0x00000040);
  }
  /**
   * <code>optional string code = 5;</code>
   */
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        code_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string code = 5;</code>
   */
  public com.google.protobuf.ByteString
      getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGGREGATE_EXPRESSION_LIST_FIELD_NUMBER = 9;
  private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> aggregateExpressionList_;
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getAggregateExpressionListList() {
    return aggregateExpressionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
      getAggregateExpressionListOrBuilderList() {
    return aggregateExpressionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  public int getAggregateExpressionListCount() {
    return aggregateExpressionList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  public com.google.zetasql.ResolvedComputedColumnProto getAggregateExpressionList(int index) {
    return aggregateExpressionList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
   */
  public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getAggregateExpressionListOrBuilder(
      int index) {
    return aggregateExpressionList_.get(index);
  }

  public static final int FUNCTION_EXPRESSION_FIELD_NUMBER = 6;
  private com.google.zetasql.AnyResolvedExprProto functionExpression_;
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   */
  public boolean hasFunctionExpression() {
    return ((bitField0_ & 0x00000080) == 0x00000080);
  }
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   */
  public com.google.zetasql.AnyResolvedExprProto getFunctionExpression() {
    return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
  }
  /**
   * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
   */
  public com.google.zetasql.AnyResolvedExprProtoOrBuilder getFunctionExpressionOrBuilder() {
    return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
  }

  public static final int OPTION_LIST_FIELD_NUMBER = 7;
  private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_;
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
      getOptionListOrBuilderList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  public int getOptionListCount() {
    return optionList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
    return optionList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
   */
  public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
      int index) {
    return optionList_.get(index);
  }

  public static final int SQL_SECURITY_FIELD_NUMBER = 12;
  private int sqlSecurity_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
   */
  public boolean hasSqlSecurity() {
    return ((bitField0_ & 0x00000100) == 0x00000100);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
   */
  public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
    @SuppressWarnings("deprecation")
    com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
    return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    if (hasParent()) {
      if (!getParent().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    if (hasReturnType()) {
      if (!getReturnType().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    if (hasSignature()) {
      if (!getSignature().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    for (int i = 0; i < getAggregateExpressionListCount(); i++) {
      if (!getAggregateExpressionList(i).isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    if (hasFunctionExpression()) {
      if (!getFunctionExpression().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    for (int i = 0; i < getOptionListCount(); i++) {
      if (!getOptionList(i).isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) == 0x00000001)) {
      output.writeMessage(1, getParent());
    }
    if (((bitField0_ & 0x00000004) == 0x00000004)) {
      output.writeMessage(3, getReturnType());
    }
    if (((bitField0_ & 0x00000020) == 0x00000020)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, language_);
    }
    if (((bitField0_ & 0x00000040) == 0x00000040)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, code_);
    }
    if (((bitField0_ & 0x00000080) == 0x00000080)) {
      output.writeMessage(6, getFunctionExpression());
    }
    for (int i = 0; i < optionList_.size(); i++) {
      output.writeMessage(7, optionList_.get(i));
    }
    if (((bitField0_ & 0x00000010) == 0x00000010)) {
      output.writeBool(8, isAggregate_);
    }
    for (int i = 0; i < aggregateExpressionList_.size(); i++) {
      output.writeMessage(9, aggregateExpressionList_.get(i));
    }
    if (((bitField0_ & 0x00000008) == 0x00000008)) {
      output.writeMessage(10, getSignature());
    }
    for (int i = 0; i < argumentNameList_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, argumentNameList_.getRaw(i));
    }
    if (((bitField0_ & 0x00000100) == 0x00000100)) {
      output.writeEnum(12, sqlSecurity_);
    }
    if (((bitField0_ & 0x00000002) == 0x00000002)) {
      output.writeBool(13, hasExplicitReturnType_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) == 0x00000001)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getParent());
    }
    if (((bitField0_ & 0x00000004) == 0x00000004)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getReturnType());
    }
    if (((bitField0_ & 0x00000020) == 0x00000020)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, language_);
    }
    if (((bitField0_ & 0x00000040) == 0x00000040)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, code_);
    }
    if (((bitField0_ & 0x00000080) == 0x00000080)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getFunctionExpression());
    }
    for (int i = 0; i < optionList_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, optionList_.get(i));
    }
    if (((bitField0_ & 0x00000010) == 0x00000010)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(8, isAggregate_);
    }
    for (int i = 0; i < aggregateExpressionList_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, aggregateExpressionList_.get(i));
    }
    if (((bitField0_ & 0x00000008) == 0x00000008)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getSignature());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < argumentNameList_.size(); i++) {
        dataSize += computeStringSizeNoTag(argumentNameList_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgumentNameListList().size();
    }
    if (((bitField0_ & 0x00000100) == 0x00000100)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(12, sqlSecurity_);
    }
    if (((bitField0_ & 0x00000002) == 0x00000002)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(13, hasExplicitReturnType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.zetasql.ResolvedCreateFunctionStmtProto)) {
      return super.equals(obj);
    }
    com.google.zetasql.ResolvedCreateFunctionStmtProto other = (com.google.zetasql.ResolvedCreateFunctionStmtProto) obj;

    boolean result = true;
    result = result && (hasParent() == other.hasParent());
    if (hasParent()) {
      result = result && getParent()
          .equals(other.getParent());
    }
    result = result && (hasHasExplicitReturnType() == other.hasHasExplicitReturnType());
    if (hasHasExplicitReturnType()) {
      result = result && (getHasExplicitReturnType()
          == other.getHasExplicitReturnType());
    }
    result = result && (hasReturnType() == other.hasReturnType());
    if (hasReturnType()) {
      result = result && getReturnType()
          .equals(other.getReturnType());
    }
    result = result && getArgumentNameListList()
        .equals(other.getArgumentNameListList());
    result = result && (hasSignature() == other.hasSignature());
    if (hasSignature()) {
      result = result && getSignature()
          .equals(other.getSignature());
    }
    result = result && (hasIsAggregate() == other.hasIsAggregate());
    if (hasIsAggregate()) {
      result = result && (getIsAggregate()
          == other.getIsAggregate());
    }
    result = result && (hasLanguage() == other.hasLanguage());
    if (hasLanguage()) {
      result = result && getLanguage()
          .equals(other.getLanguage());
    }
    result = result && (hasCode() == other.hasCode());
    if (hasCode()) {
      result = result && getCode()
          .equals(other.getCode());
    }
    result = result && getAggregateExpressionListList()
        .equals(other.getAggregateExpressionListList());
    result = result && (hasFunctionExpression() == other.hasFunctionExpression());
    if (hasFunctionExpression()) {
      result = result && getFunctionExpression()
          .equals(other.getFunctionExpression());
    }
    result = result && getOptionListList()
        .equals(other.getOptionListList());
    result = result && (hasSqlSecurity() == other.hasSqlSecurity());
    if (hasSqlSecurity()) {
      result = result && sqlSecurity_ == other.sqlSecurity_;
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasParent()) {
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
    }
    if (hasHasExplicitReturnType()) {
      hash = (37 * hash) + HAS_EXPLICIT_RETURN_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getHasExplicitReturnType());
    }
    if (hasReturnType()) {
      hash = (37 * hash) + RETURN_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getReturnType().hashCode();
    }
    if (getArgumentNameListCount() > 0) {
      hash = (37 * hash) + ARGUMENT_NAME_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getArgumentNameListList().hashCode();
    }
    if (hasSignature()) {
      hash = (37 * hash) + SIGNATURE_FIELD_NUMBER;
      hash = (53 * hash) + getSignature().hashCode();
    }
    if (hasIsAggregate()) {
      hash = (37 * hash) + IS_AGGREGATE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIsAggregate());
    }
    if (hasLanguage()) {
      hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguage().hashCode();
    }
    if (hasCode()) {
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCode().hashCode();
    }
    if (getAggregateExpressionListCount() > 0) {
      hash = (37 * hash) + AGGREGATE_EXPRESSION_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getAggregateExpressionListList().hashCode();
    }
    if (hasFunctionExpression()) {
      hash = (37 * hash) + FUNCTION_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getFunctionExpression().hashCode();
    }
    if (getOptionListCount() > 0) {
      hash = (37 * hash) + OPTION_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getOptionListList().hashCode();
    }
    if (hasSqlSecurity()) {
      hash = (37 * hash) + SQL_SECURITY_FIELD_NUMBER;
      hash = (53 * hash) + sqlSecurity_;
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedCreateFunctionStmtProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This statement creates a user-defined function:
   *   CREATE [TEMP] FUNCTION [IF NOT EXISTS] &lt;name_path&gt; (&lt;arg_list&gt;)
   *     [RETURNS &lt;return_type&gt;] [LANGUAGE &lt;language&gt;]
   *     [AS &lt;code&gt; | AS ( &lt;function_expression&gt; )] [OPTIONS (&lt;option_list&gt;)]
   *   &lt;name_path&gt; is the identifier path of the function.
   *   &lt;has_explicit_return_type&gt; is true iff RETURNS clause is present.
   *   &lt;return_type&gt; is the return type for the function, which can be any
   *          valid ZetaSQL type, including ARRAY or STRUCT. It is inferred
   *          from &lt;function_expression&gt; if not explicitly set.
   *          TODO: Deprecate and remove this. The return type is
   *          already specified by the &lt;signature&gt;.
   *   &lt;argument_name_list&gt; The names of the function arguments.
   *   &lt;signature&gt; is the FunctionSignature of the created function, with all
   *          options.  This can be used to create a Function to load into a
   *          Catalog for future queries.
   *   &lt;is_aggregate&gt; is true if this is an aggregate function.  All arguments
   *          are assumed to be aggregate input arguments that may vary for
   *          every row.
   *   &lt;language&gt; is the programming language used by the function. This field
   *          is set to 'SQL' for SQL functions and otherwise to the language
   *          name specified in the LANGUAGE clause.
   *   &lt;code&gt; is a string literal that contains the function definition.  Some
   *          engines may allow this argument to be omitted for certain types
   *          of external functions. This will always be set for SQL functions.
   *   &lt;aggregate_expression_list&gt; is a list of SQL aggregate functions to
   *          compute prior to computing the final &lt;function_expression&gt;.
   *          See below.
   *   &lt;function_expression&gt; is the resolved SQL expression invoked for the
   *          function. This will be unset for external language functions. For
   *          non-template SQL functions, this is a resolved representation of
   *          the expression in &lt;code&gt;.
   *   &lt;option_list&gt; has engine-specific directives for modifying functions.
   *   &lt;sql_security&gt; is the declared security mode for the function. Values
   *          include 'INVOKER', 'DEFINER'.
   * Note that &lt;function_expression&gt; and &lt;code&gt; are both marked as IGNORABLE
   * because an engine could look at either one (but might not look at both).
   * An engine must look at one (and cannot ignore both) to be semantically
   * valid, but there is currently no way to enforce that.
   * For aggregate functions, &lt;is_aggregate&gt; will be true.
   * Aggregate functions will only occur if LanguageOptions has
   * FEATURE_CREATE_AGGREGATE_FUNCTION enabled.
   * Arguments to aggregate functions must have
   * &lt;FunctionSignatureArgumentTypeOptions::is_not_aggregate&gt; true or false.
   * Non-aggregate arguments must be passed constant values only.
   * For SQL aggregate functions, there will be both an
   * &lt;aggregate_expression_list&gt;, with aggregate expressions to compute first,
   * and then a final &lt;function_expression&gt; to compute on the results
   * of the aggregates.  Each aggregate expression is a
   * ResolvedAggregateFunctionCall, and may reference any input arguments.
   * Each ResolvedComputedColumn in &lt;aggregate_expression_list&gt; gives the
   * aggregate expression a column id.  The final &lt;function_expression&gt; can
   * reference these created aggregate columns, and any input arguments
   * with &lt;argument_kind&gt;=NOT_AGGREGATE.
   * For example, with
   *   CREATE TEMP FUNCTION my_avg(x) = (SUM(x) / COUNT(x));
   * we would have an &lt;aggregate_expression_list&gt; with
   *   agg1#1 := SUM(ResolvedArgumentRef(x))
   *   agg2#2 := COUNT(ResolvedArgumentRef(x))
   * and a &lt;function_expression&gt;
   *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2)
   * For example, with
   *   CREATE FUNCTION scaled_avg(x,y NOT AGGREGATE) = (SUM(x) / COUNT(x) * y);
   * we would have an &lt;aggregate_expression_list&gt; with
   *   agg1#1 := SUM(ResolvedArgumentRef(x))
   *   agg2#2 := COUNT(ResolvedArgumentRef(x))
   * and a &lt;function_expression&gt;
   *   ResolvedColumnRef(agg1#1) / ResolvedColumnRef(agg2#2) * ResolvedArgumentRef(y)
   * When resolving a query that calls an aggregate UDF, the query will
   * have a ResolvedAggregateScan that invokes the UDF function.  The engine
   * should remove the UDF aggregate function from the &lt;aggregate_list&gt;, and
   * instead compute the additional aggregates from the
   * UDF's &lt;aggregate_expression_list&gt;, and then add an additional Project
   * to compute the final &lt;function_expression&gt;, which should produce the
   * value for the original ResolvedAggregateScan's computed column for the
   * UDF.  Some rewrites of the ResolvedColumn references inside the UDF will
   * be required.  TODO If using ResolvedColumns makes this renaming
   * too complicated, we could switch to use ResolvedArgumentRefs, or
   * something new.
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedCreateFunctionStmtProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedCreateFunctionStmtProto)
      com.google.zetasql.ResolvedCreateFunctionStmtProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedCreateFunctionStmtProto.class, com.google.zetasql.ResolvedCreateFunctionStmtProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedCreateFunctionStmtProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getReturnTypeFieldBuilder();
        getSignatureFieldBuilder();
        getAggregateExpressionListFieldBuilder();
        getFunctionExpressionFieldBuilder();
        getOptionListFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      hasExplicitReturnType_ = false;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (returnTypeBuilder_ == null) {
        returnType_ = null;
      } else {
        returnTypeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      if (signatureBuilder_ == null) {
        signature_ = null;
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      isAggregate_ = false;
      bitField0_ = (bitField0_ & ~0x00000020);
      language_ = "";
      bitField0_ = (bitField0_ & ~0x00000040);
      code_ = "";
      bitField0_ = (bitField0_ & ~0x00000080);
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
      } else {
        aggregateExpressionListBuilder_.clear();
      }
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = null;
      } else {
        functionExpressionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
      } else {
        optionListBuilder_.clear();
      }
      sqlSecurity_ = 0;
      bitField0_ = (bitField0_ & ~0x00000800);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedCreateFunctionStmtProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto build() {
      com.google.zetasql.ResolvedCreateFunctionStmtProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateFunctionStmtProto buildPartial() {
      com.google.zetasql.ResolvedCreateFunctionStmtProto result = new com.google.zetasql.ResolvedCreateFunctionStmtProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
        to_bitField0_ |= 0x00000001;
      }
      if (parentBuilder_ == null) {
        result.parent_ = parent_;
      } else {
        result.parent_ = parentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
        to_bitField0_ |= 0x00000002;
      }
      result.hasExplicitReturnType_ = hasExplicitReturnType_;
      if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
        to_bitField0_ |= 0x00000004;
      }
      if (returnTypeBuilder_ == null) {
        result.returnType_ = returnType_;
      } else {
        result.returnType_ = returnTypeBuilder_.build();
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        argumentNameList_ = argumentNameList_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.argumentNameList_ = argumentNameList_;
      if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
        to_bitField0_ |= 0x00000008;
      }
      if (signatureBuilder_ == null) {
        result.signature_ = signature_;
      } else {
        result.signature_ = signatureBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
        to_bitField0_ |= 0x00000010;
      }
      result.isAggregate_ = isAggregate_;
      if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
        to_bitField0_ |= 0x00000020;
      }
      result.language_ = language_;
      if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
        to_bitField0_ |= 0x00000040;
      }
      result.code_ = code_;
      if (aggregateExpressionListBuilder_ == null) {
        if (((bitField0_ & 0x00000100) == 0x00000100)) {
          aggregateExpressionList_ = java.util.Collections.unmodifiableList(aggregateExpressionList_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.aggregateExpressionList_ = aggregateExpressionList_;
      } else {
        result.aggregateExpressionList_ = aggregateExpressionListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
        to_bitField0_ |= 0x00000080;
      }
      if (functionExpressionBuilder_ == null) {
        result.functionExpression_ = functionExpression_;
      } else {
        result.functionExpression_ = functionExpressionBuilder_.build();
      }
      if (optionListBuilder_ == null) {
        if (((bitField0_ & 0x00000400) == 0x00000400)) {
          optionList_ = java.util.Collections.unmodifiableList(optionList_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.optionList_ = optionList_;
      } else {
        result.optionList_ = optionListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
        to_bitField0_ |= 0x00000100;
      }
      result.sqlSecurity_ = sqlSecurity_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.zetasql.ResolvedCreateFunctionStmtProto) {
        return mergeFrom((com.google.zetasql.ResolvedCreateFunctionStmtProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.zetasql.ResolvedCreateFunctionStmtProto other) {
      if (other == com.google.zetasql.ResolvedCreateFunctionStmtProto.getDefaultInstance()) return this;
      if (other.hasParent()) {
        mergeParent(other.getParent());
      }
      if (other.hasHasExplicitReturnType()) {
        setHasExplicitReturnType(other.getHasExplicitReturnType());
      }
      if (other.hasReturnType()) {
        mergeReturnType(other.getReturnType());
      }
      if (!other.argumentNameList_.isEmpty()) {
        if (argumentNameList_.isEmpty()) {
          argumentNameList_ = other.argumentNameList_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureArgumentNameListIsMutable();
          argumentNameList_.addAll(other.argumentNameList_);
        }
        onChanged();
      }
      if (other.hasSignature()) {
        mergeSignature(other.getSignature());
      }
      if (other.hasIsAggregate()) {
        setIsAggregate(other.getIsAggregate());
      }
      if (other.hasLanguage()) {
        bitField0_ |= 0x00000040;
        language_ = other.language_;
        onChanged();
      }
      if (other.hasCode()) {
        bitField0_ |= 0x00000080;
        code_ = other.code_;
        onChanged();
      }
      if (aggregateExpressionListBuilder_ == null) {
        if (!other.aggregateExpressionList_.isEmpty()) {
          if (aggregateExpressionList_.isEmpty()) {
            aggregateExpressionList_ = other.aggregateExpressionList_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureAggregateExpressionListIsMutable();
            aggregateExpressionList_.addAll(other.aggregateExpressionList_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregateExpressionList_.isEmpty()) {
          if (aggregateExpressionListBuilder_.isEmpty()) {
            aggregateExpressionListBuilder_.dispose();
            aggregateExpressionListBuilder_ = null;
            aggregateExpressionList_ = other.aggregateExpressionList_;
            bitField0_ = (bitField0_ & ~0x00000100);
            aggregateExpressionListBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getAggregateExpressionListFieldBuilder() : null;
          } else {
            aggregateExpressionListBuilder_.addAllMessages(other.aggregateExpressionList_);
          }
        }
      }
      if (other.hasFunctionExpression()) {
        mergeFunctionExpression(other.getFunctionExpression());
      }
      if (optionListBuilder_ == null) {
        if (!other.optionList_.isEmpty()) {
          if (optionList_.isEmpty()) {
            optionList_ = other.optionList_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureOptionListIsMutable();
            optionList_.addAll(other.optionList_);
          }
          onChanged();
        }
      } else {
        if (!other.optionList_.isEmpty()) {
          if (optionListBuilder_.isEmpty()) {
            optionListBuilder_.dispose();
            optionListBuilder_ = null;
            optionList_ = other.optionList_;
            bitField0_ = (bitField0_ & ~0x00000400);
            optionListBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getOptionListFieldBuilder() : null;
          } else {
            optionListBuilder_.addAllMessages(other.optionList_);
          }
        }
      }
      if (other.hasSqlSecurity()) {
        setSqlSecurity(other.getSqlSecurity());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      if (hasParent()) {
        if (!getParent().isInitialized()) {
          return false;
        }
      }
      if (hasReturnType()) {
        if (!getReturnType().isInitialized()) {
          return false;
        }
      }
      if (hasSignature()) {
        if (!getSignature().isInitialized()) {
          return false;
        }
      }
      for (int i = 0; i < getAggregateExpressionListCount(); i++) {
        if (!getAggregateExpressionList(i).isInitialized()) {
          return false;
        }
      }
      if (hasFunctionExpression()) {
        if (!getFunctionExpression().isInitialized()) {
          return false;
        }
      }
      for (int i = 0; i < getOptionListCount(); i++) {
        if (!getOptionList(i).isInitialized()) {
          return false;
        }
      }
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.zetasql.ResolvedCreateFunctionStmtProto parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.zetasql.ResolvedCreateFunctionStmtProto) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedCreateStatementProto parent_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedCreateStatementProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) == 0x00000001) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedCreateStatementProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private boolean hasExplicitReturnType_ ;
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     */
    public boolean hasHasExplicitReturnType() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     */
    public boolean getHasExplicitReturnType() {
      return hasExplicitReturnType_;
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     */
    public Builder setHasExplicitReturnType(boolean value) {
      bitField0_ |= 0x00000002;
      hasExplicitReturnType_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool has_explicit_return_type = 13;</code>
     */
    public Builder clearHasExplicitReturnType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      hasExplicitReturnType_ = false;
      onChanged();
      return this;
    }

    private com.google.zetasql.ZetaSQLType.TypeProto returnType_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder> returnTypeBuilder_;
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public boolean hasReturnType() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public com.google.zetasql.ZetaSQLType.TypeProto getReturnType() {
      if (returnTypeBuilder_ == null) {
        return returnType_ == null ? com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
      } else {
        return returnTypeBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder setReturnType(com.google.zetasql.ZetaSQLType.TypeProto value) {
      if (returnTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        returnType_ = value;
        onChanged();
      } else {
        returnTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder setReturnType(
        com.google.zetasql.ZetaSQLType.TypeProto.Builder builderForValue) {
      if (returnTypeBuilder_ == null) {
        returnType_ = builderForValue.build();
        onChanged();
      } else {
        returnTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder mergeReturnType(com.google.zetasql.ZetaSQLType.TypeProto value) {
      if (returnTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004) &&
            returnType_ != null &&
            returnType_ != com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance()) {
          returnType_ =
            com.google.zetasql.ZetaSQLType.TypeProto.newBuilder(returnType_).mergeFrom(value).buildPartial();
        } else {
          returnType_ = value;
        }
        onChanged();
      } else {
        returnTypeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public Builder clearReturnType() {
      if (returnTypeBuilder_ == null) {
        returnType_ = null;
        onChanged();
      } else {
        returnTypeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public com.google.zetasql.ZetaSQLType.TypeProto.Builder getReturnTypeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReturnTypeFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    public com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder getReturnTypeOrBuilder() {
      if (returnTypeBuilder_ != null) {
        return returnTypeBuilder_.getMessageOrBuilder();
      } else {
        return returnType_ == null ?
            com.google.zetasql.ZetaSQLType.TypeProto.getDefaultInstance() : returnType_;
      }
    }
    /**
     * <code>optional .zetasql.TypeProto return_type = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder> 
        getReturnTypeFieldBuilder() {
      if (returnTypeBuilder_ == null) {
        returnTypeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ZetaSQLType.TypeProto, com.google.zetasql.ZetaSQLType.TypeProto.Builder, com.google.zetasql.ZetaSQLType.TypeProtoOrBuilder>(
                getReturnType(),
                getParentForChildren(),
                isClean());
        returnType_ = null;
      }
      return returnTypeBuilder_;
    }

    private com.google.protobuf.LazyStringList argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureArgumentNameListIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        argumentNameList_ = new com.google.protobuf.LazyStringArrayList(argumentNameList_);
        bitField0_ |= 0x00000008;
       }
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getArgumentNameListList() {
      return argumentNameList_.getUnmodifiableView();
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public int getArgumentNameListCount() {
      return argumentNameList_.size();
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public java.lang.String getArgumentNameList(int index) {
      return argumentNameList_.get(index);
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public com.google.protobuf.ByteString
        getArgumentNameListBytes(int index) {
      return argumentNameList_.getByteString(index);
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public Builder setArgumentNameList(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public Builder addArgumentNameList(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public Builder addAllArgumentNameList(
        java.lang.Iterable<java.lang.String> values) {
      ensureArgumentNameListIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, argumentNameList_);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public Builder clearArgumentNameList() {
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 11;</code>
     */
    public Builder addArgumentNameListBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }

    private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> signatureBuilder_;
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public boolean hasSignature() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
      if (signatureBuilder_ == null) {
        return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      } else {
        return signatureBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder setSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signature_ = value;
        onChanged();
      } else {
        signatureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder setSignature(
        com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder builderForValue) {
      if (signatureBuilder_ == null) {
        signature_ = builderForValue.build();
        onChanged();
      } else {
        signatureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder mergeSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010) &&
            signature_ != null &&
            signature_ != com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance()) {
          signature_ =
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.newBuilder(signature_).mergeFrom(value).buildPartial();
        } else {
          signature_ = value;
        }
        onChanged();
      } else {
        signatureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public Builder clearSignature() {
      if (signatureBuilder_ == null) {
        signature_ = null;
        onChanged();
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder getSignatureBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSignatureFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
      if (signatureBuilder_ != null) {
        return signatureBuilder_.getMessageOrBuilder();
      } else {
        return signature_ == null ?
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> 
        getSignatureFieldBuilder() {
      if (signatureBuilder_ == null) {
        signatureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder>(
                getSignature(),
                getParentForChildren(),
                isClean());
        signature_ = null;
      }
      return signatureBuilder_;
    }

    private boolean isAggregate_ ;
    /**
     * <code>optional bool is_aggregate = 8;</code>
     */
    public boolean hasIsAggregate() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     */
    public boolean getIsAggregate() {
      return isAggregate_;
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     */
    public Builder setIsAggregate(boolean value) {
      bitField0_ |= 0x00000020;
      isAggregate_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool is_aggregate = 8;</code>
     */
    public Builder clearIsAggregate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      isAggregate_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object language_ = "";
    /**
     * <code>optional string language = 4;</code>
     */
    public boolean hasLanguage() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional string language = 4;</code>
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          language_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string language = 4;</code>
     */
    public com.google.protobuf.ByteString
        getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string language = 4;</code>
     */
    public Builder setLanguage(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
      language_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 4;</code>
     */
    public Builder clearLanguage() {
      bitField0_ = (bitField0_ & ~0x00000040);
      language_ = getDefaultInstance().getLanguage();
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 4;</code>
     */
    public Builder setLanguageBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
      language_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     * <code>optional string code = 5;</code>
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional string code = 5;</code>
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          code_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string code = 5;</code>
     */
    public com.google.protobuf.ByteString
        getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string code = 5;</code>
     */
    public Builder setCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
      code_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 5;</code>
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000080);
      code_ = getDefaultInstance().getCode();
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 5;</code>
     */
    public Builder setCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
      code_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.zetasql.ResolvedComputedColumnProto> aggregateExpressionList_ =
      java.util.Collections.emptyList();
    private void ensureAggregateExpressionListIsMutable() {
      if (!((bitField0_ & 0x00000100) == 0x00000100)) {
        aggregateExpressionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedComputedColumnProto>(aggregateExpressionList_);
        bitField0_ |= 0x00000100;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> aggregateExpressionListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto> getAggregateExpressionListList() {
      if (aggregateExpressionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregateExpressionList_);
      } else {
        return aggregateExpressionListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public int getAggregateExpressionListCount() {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.size();
      } else {
        return aggregateExpressionListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto getAggregateExpressionList(int index) {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.get(index);
      } else {
        return aggregateExpressionListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder setAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.set(index, value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder setAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto value) {
      if (aggregateExpressionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(index, value);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAggregateExpressionList(
        int index, com.google.zetasql.ResolvedComputedColumnProto.Builder builderForValue) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder addAllAggregateExpressionList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedComputedColumnProto> values) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, aggregateExpressionList_);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder clearAggregateExpressionList() {
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public Builder removeAggregateExpressionList(int index) {
      if (aggregateExpressionListBuilder_ == null) {
        ensureAggregateExpressionListIsMutable();
        aggregateExpressionList_.remove(index);
        onChanged();
      } else {
        aggregateExpressionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder getAggregateExpressionListBuilder(
        int index) {
      return getAggregateExpressionListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProtoOrBuilder getAggregateExpressionListOrBuilder(
        int index) {
      if (aggregateExpressionListBuilder_ == null) {
        return aggregateExpressionList_.get(index);  } else {
        return aggregateExpressionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
         getAggregateExpressionListOrBuilderList() {
      if (aggregateExpressionListBuilder_ != null) {
        return aggregateExpressionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregateExpressionList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addAggregateExpressionListBuilder() {
      return getAggregateExpressionListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public com.google.zetasql.ResolvedComputedColumnProto.Builder addAggregateExpressionListBuilder(
        int index) {
      return getAggregateExpressionListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedComputedColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedComputedColumnProto aggregate_expression_list = 9;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedComputedColumnProto.Builder> 
         getAggregateExpressionListBuilderList() {
      return getAggregateExpressionListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder> 
        getAggregateExpressionListFieldBuilder() {
      if (aggregateExpressionListBuilder_ == null) {
        aggregateExpressionListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedComputedColumnProto, com.google.zetasql.ResolvedComputedColumnProto.Builder, com.google.zetasql.ResolvedComputedColumnProtoOrBuilder>(
                aggregateExpressionList_,
                ((bitField0_ & 0x00000100) == 0x00000100),
                getParentForChildren(),
                isClean());
        aggregateExpressionList_ = null;
      }
      return aggregateExpressionListBuilder_;
    }

    private com.google.zetasql.AnyResolvedExprProto functionExpression_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> functionExpressionBuilder_;
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public boolean hasFunctionExpression() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto getFunctionExpression() {
      if (functionExpressionBuilder_ == null) {
        return functionExpression_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
      } else {
        return functionExpressionBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder setFunctionExpression(com.google.zetasql.AnyResolvedExprProto value) {
      if (functionExpressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        functionExpression_ = value;
        onChanged();
      } else {
        functionExpressionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder setFunctionExpression(
        com.google.zetasql.AnyResolvedExprProto.Builder builderForValue) {
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = builderForValue.build();
        onChanged();
      } else {
        functionExpressionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder mergeFunctionExpression(com.google.zetasql.AnyResolvedExprProto value) {
      if (functionExpressionBuilder_ == null) {
        if (((bitField0_ & 0x00000200) == 0x00000200) &&
            functionExpression_ != null &&
            functionExpression_ != com.google.zetasql.AnyResolvedExprProto.getDefaultInstance()) {
          functionExpression_ =
            com.google.zetasql.AnyResolvedExprProto.newBuilder(functionExpression_).mergeFrom(value).buildPartial();
        } else {
          functionExpression_ = value;
        }
        onChanged();
      } else {
        functionExpressionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public Builder clearFunctionExpression() {
      if (functionExpressionBuilder_ == null) {
        functionExpression_ = null;
        onChanged();
      } else {
        functionExpressionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto.Builder getFunctionExpressionBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFunctionExpressionFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    public com.google.zetasql.AnyResolvedExprProtoOrBuilder getFunctionExpressionOrBuilder() {
      if (functionExpressionBuilder_ != null) {
        return functionExpressionBuilder_.getMessageOrBuilder();
      } else {
        return functionExpression_ == null ?
            com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : functionExpression_;
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedExprProto function_expression = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> 
        getFunctionExpressionFieldBuilder() {
      if (functionExpressionBuilder_ == null) {
        functionExpressionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder>(
                getFunctionExpression(),
                getParentForChildren(),
                isClean());
        functionExpression_ = null;
      }
      return functionExpressionBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_ =
      java.util.Collections.emptyList();
    private void ensureOptionListIsMutable() {
      if (!((bitField0_ & 0x00000400) == 0x00000400)) {
        optionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>(optionList_);
        bitField0_ |= 0x00000400;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> optionListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
      if (optionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(optionList_);
      } else {
        return optionListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public int getOptionListCount() {
      if (optionListBuilder_ == null) {
        return optionList_.size();
      } else {
        return optionListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);
      } else {
        return optionListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.set(index, value);
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(index, value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder addAllOptionList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedOptionProto> values) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, optionList_);
        onChanged();
      } else {
        optionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder clearOptionList() {
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        optionListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public Builder removeOptionList(int index) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.remove(index);
        onChanged();
      } else {
        optionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder getOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
        int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);  } else {
        return optionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
         getOptionListOrBuilderList() {
      if (optionListBuilder_ != null) {
        return optionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(optionList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder() {
      return getOptionListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto.Builder> 
         getOptionListBuilderList() {
      return getOptionListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> 
        getOptionListFieldBuilder() {
      if (optionListBuilder_ == null) {
        optionListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder>(
                optionList_,
                ((bitField0_ & 0x00000400) == 0x00000400),
                getParentForChildren(),
                isClean());
        optionList_ = null;
      }
      return optionListBuilder_;
    }

    private int sqlSecurity_ = 0;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     */
    public boolean hasSqlSecurity() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     */
    public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
      @SuppressWarnings("deprecation")
      com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
      return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     */
    public Builder setSqlSecurity(com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      sqlSecurity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 12;</code>
     */
    public Builder clearSqlSecurity() {
      bitField0_ = (bitField0_ & ~0x00000800);
      sqlSecurity_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedCreateFunctionStmtProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedCreateFunctionStmtProto)
  private static final com.google.zetasql.ResolvedCreateFunctionStmtProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedCreateFunctionStmtProto();
  }

  public static com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedCreateFunctionStmtProto>() {
    @java.lang.Override
    public ResolvedCreateFunctionStmtProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResolvedCreateFunctionStmtProto(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedCreateFunctionStmtProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedCreateFunctionStmtProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

