/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;

public class BeamSqlRelUtils {
    public static PCollection<Row> toPCollection(Pipeline pipeline, BeamRelNode node) {
        return BeamSqlRelUtils.toPCollection(pipeline, node, new HashMap<Integer, PCollection<Row>>());
    }

    private static PCollectionList<Row> buildPCollectionList(List<RelNode> inputRels, Pipeline pipeline, Map<Integer, PCollection<Row>> cache) {
        if (inputRels.isEmpty()) {
            return PCollectionList.empty((Pipeline)pipeline);
        }
        return PCollectionList.of((Iterable)inputRels.stream().map(input -> BeamSqlRelUtils.toPCollection(pipeline, (BeamRelNode)input, cache)).collect(Collectors.toList()));
    }

    static PCollection<Row> toPCollection(Pipeline pipeline, BeamRelNode node, Map<Integer, PCollection<Row>> cache) {
        PCollection output = cache.get(node.getId());
        if (output != null) {
            return output;
        }
        String name = node.getClass().getSimpleName() + "_" + node.getId();
        PCollectionList<Row> input = BeamSqlRelUtils.buildPCollectionList(node.getPCollectionInputs(), pipeline, cache);
        PTransform<PCollectionList<Row>, PCollection<Row>> transform = node.buildPTransform();
        output = (PCollection)Pipeline.applyTransform((String)name, input, transform);
        cache.put(node.getId(), (PCollection<Row>)output);
        return output;
    }

    public static BeamRelNode getBeamRelInput(RelNode input) {
        if (input instanceof RelSubset) {
            input = ((RelSubset)input).getBest();
        }
        return (BeamRelNode)input;
    }
}

