/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Map;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.TableScan;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    private final BeamSqlTable beamTable;
    private final BeamCalciteTable calciteTable;
    private final Map<String, String> pipelineOptions;

    public BeamIOSourceRel(RelOptCluster cluster, RelOptTable table, BeamSqlTable beamTable, Map<String, String> pipelineOptions, BeamCalciteTable calciteTable) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table);
        this.beamTable = beamTable;
        this.calciteTable = calciteTable;
        this.pipelineOptions = pipelineOptions;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        BeamTableStatistics rowCountStatistics = this.calciteTable.getStatistic();
        if (this.beamTable.isBounded() == PCollection.IsBounded.BOUNDED) {
            return rowCountStatistics.getRowCount();
        }
        return rowCountStatistics.getRate();
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return this.beamTable.isBounded();
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = this.estimateRowCount(mq);
        return planner.getCostFactory().makeCost(rowCount, rowCount, rowCount);
    }

    protected BeamSqlTable getBeamSqlTable() {
        return this.beamTable;
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> input) {
            Preconditions.checkArgument((input.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object)BeamIOSourceRel.class.getSimpleName(), input);
            return BeamIOSourceRel.this.beamTable.buildIOReader(input.getPipeline().begin());
        }
    }
}

