/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.sql;

import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.ImmutableNullableList;

public class SqlDelete
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DELETE", SqlKind.DELETE);
    SqlNode targetTable;
    SqlNode condition;
    SqlSelect sourceSelect;
    SqlIdentifier alias;

    public SqlDelete(SqlParserPos pos, SqlNode targetTable, SqlNode condition, SqlSelect sourceSelect, SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.condition = condition;
        this.sourceSelect = sourceSelect;
        this.alias = alias;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DELETE;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.targetTable, this.condition, this.alias);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.targetTable = operand;
                break;
            }
            case 1: {
                this.condition = operand;
                break;
            }
            case 2: {
                this.sourceSelect = (SqlSelect)operand;
                break;
            }
            case 3: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    public SqlIdentifier getAlias() {
        return this.alias;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "DELETE FROM", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.alias != null) {
            writer.keyword("AS");
            this.alias.unparse(writer, opLeft, opRight);
        }
        if (this.condition != null) {
            writer.sep("WHERE");
            this.condition.unparse(writer, opLeft, opRight);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDelete(this);
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }
}

