/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableCollection;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Filter;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlAggFunction;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.Mappings;

public class AggregateFilterTransposeRule
extends RelOptRule {
    public static final AggregateFilterTransposeRule INSTANCE = new AggregateFilterTransposeRule();

    private AggregateFilterTransposeRule() {
        this(AggregateFilterTransposeRule.operand(Aggregate.class, AggregateFilterTransposeRule.operand(Filter.class, AggregateFilterTransposeRule.any()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER);
    }

    public AggregateFilterTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        ImmutableBitSet filterColumns = RelOptUtil.InputFinder.bits(filter.getCondition());
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().union(filterColumns);
        RelNode input = filter.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        boolean allColumnsInAggregate = aggregate.getGroupSet().contains(filterColumns);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), input, false, newGroupSet, null, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(newGroupSet::indexOf, input.getRowType().getFieldCount(), newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply(mapping, filter.getCondition());
        Filter newFilter = filter.copy(filter.getTraitSet(), newAggregate, newCondition);
        if (allColumnsInAggregate && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            assert (newGroupSet.equals(aggregate.getGroupSet()));
            call.transformTo(newFilter);
        } else {
            ImmutableBitSet.Builder topGroupSet = ImmutableBitSet.builder();
            for (int c : aggregate.getGroupSet()) {
                topGroupSet.set(newGroupSet.indexOf(c));
            }
            ImmutableCollection newGroupingSets = null;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                ImmutableList.Builder newGroupingSetsBuilder = ImmutableList.builder();
                for (ImmutableBitSet immutableBitSet : aggregate.getGroupSets()) {
                    ImmutableBitSet.Builder newGroupingSet = ImmutableBitSet.builder();
                    for (int c : immutableBitSet) {
                        newGroupingSet.set(newGroupSet.indexOf(c));
                    }
                    newGroupingSetsBuilder.add(newGroupingSet.build());
                }
                newGroupingSets = newGroupingSetsBuilder.build();
            }
            ArrayList<AggregateCall> topAggCallList = new ArrayList<AggregateCall>();
            int i = newGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                SqlAggFunction rollup = SubstitutionVisitor.getRollup(aggregateCall.getAggregation());
                if (rollup == null) {
                    return;
                }
                if (aggregateCall.isDistinct()) {
                    return;
                }
                topAggCallList.add(AggregateCall.create(rollup, aggregateCall.isDistinct(), aggregateCall.isApproximate(), ImmutableList.of(Integer.valueOf(i++)), -1, aggregateCall.collation, aggregateCall.type, aggregateCall.name));
            }
            Aggregate aggregate2 = aggregate.copy(aggregate.getTraitSet(), newFilter, aggregate.indicator, topGroupSet.build(), (List<ImmutableBitSet>)((Object)newGroupingSets), topAggCallList);
            call.transformTo(aggregate2);
        }
    }
}

