/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.Contexts;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.ViewExpanders;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelDistribution;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.JoinInfo;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.SemiJoin;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalSort;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalSortExchange;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalValues;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.TranslatableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SemiJoinType;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.ImmutableBitSet;

public class RelFactories {
    public static final ProjectFactory DEFAULT_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final FilterFactory DEFAULT_FILTER_FACTORY = new FilterFactoryImpl();
    public static final JoinFactory DEFAULT_JOIN_FACTORY = new JoinFactoryImpl();
    public static final CorrelateFactory DEFAULT_CORRELATE_FACTORY = new CorrelateFactoryImpl();
    public static final SemiJoinFactory DEFAULT_SEMI_JOIN_FACTORY = new SemiJoinFactoryImpl();
    public static final SortFactory DEFAULT_SORT_FACTORY = new SortFactoryImpl();
    public static final ExchangeFactory DEFAULT_EXCHANGE_FACTORY = new ExchangeFactoryImpl();
    public static final SortExchangeFactory DEFAULT_SORT_EXCHANGE_FACTORY = new SortExchangeFactoryImpl();
    public static final AggregateFactory DEFAULT_AGGREGATE_FACTORY = new AggregateFactoryImpl();
    public static final MatchFactory DEFAULT_MATCH_FACTORY = new MatchFactoryImpl();
    public static final SetOpFactory DEFAULT_SET_OP_FACTORY = new SetOpFactoryImpl();
    public static final ValuesFactory DEFAULT_VALUES_FACTORY = new ValuesFactoryImpl();
    public static final TableScanFactory DEFAULT_TABLE_SCAN_FACTORY = new TableScanFactoryImpl();
    public static final SnapshotFactory DEFAULT_SNAPSHOT_FACTORY = new SnapshotFactoryImpl();
    public static final RelBuilderFactory LOGICAL_BUILDER = RelBuilder.proto(Contexts.of(DEFAULT_PROJECT_FACTORY, DEFAULT_FILTER_FACTORY, DEFAULT_JOIN_FACTORY, DEFAULT_SEMI_JOIN_FACTORY, DEFAULT_SORT_FACTORY, DEFAULT_EXCHANGE_FACTORY, DEFAULT_SORT_EXCHANGE_FACTORY, DEFAULT_AGGREGATE_FACTORY, DEFAULT_MATCH_FACTORY, DEFAULT_SET_OP_FACTORY, DEFAULT_VALUES_FACTORY, DEFAULT_TABLE_SCAN_FACTORY, DEFAULT_SNAPSHOT_FACTORY));

    private RelFactories() {
    }

    @Nonnull
    public static TableScanFactory expandingScanFactory(@Nonnull TableScanFactory tableScanFactory) {
        return RelFactories.expandingScanFactory((rowType, queryString, schemaPath, viewPath) -> {
            throw new UnsupportedOperationException("cannot expand view");
        }, tableScanFactory);
    }

    @Nonnull
    public static TableScanFactory expandingScanFactory(@Nonnull RelOptTable.ViewExpander viewExpander, @Nonnull TableScanFactory tableScanFactory) {
        return (cluster, table) -> {
            TranslatableTable translatableTable = table.unwrap(TranslatableTable.class);
            if (translatableTable != null) {
                RelOptTable.ToRelContext toRelContext = ViewExpanders.toRelContext(viewExpander, cluster);
                return translatableTable.toRel(toRelContext, table);
            }
            return tableScanFactory.createScan(cluster, table);
        };
    }

    private static class MatchFactoryImpl
    implements MatchFactory {
        private MatchFactoryImpl() {
        }

        @Override
        public RelNode createMatch(RelNode input, RexNode pattern, RelDataType rowType, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, List<RexNode> partitionKeys, RelCollation orderKeys, RexNode interval) {
            return LogicalMatch.create(input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
        }
    }

    public static interface MatchFactory {
        public RelNode createMatch(RelNode var1, RexNode var2, RelDataType var3, boolean var4, boolean var5, Map<String, RexNode> var6, Map<String, RexNode> var7, RexNode var8, Map<String, ? extends SortedSet<String>> var9, boolean var10, List<RexNode> var11, RelCollation var12, RexNode var13);
    }

    public static class SnapshotFactoryImpl
    implements SnapshotFactory {
        @Override
        public RelNode createSnapshot(RelNode input, RexNode period) {
            return LogicalSnapshot.create(input, period);
        }
    }

    public static interface SnapshotFactory {
        public RelNode createSnapshot(RelNode var1, RexNode var2);
    }

    private static class TableScanFactoryImpl
    implements TableScanFactory {
        private TableScanFactoryImpl() {
        }

        @Override
        public RelNode createScan(RelOptCluster cluster, RelOptTable table) {
            return LogicalTableScan.create(cluster, table);
        }
    }

    public static interface TableScanFactory {
        public RelNode createScan(RelOptCluster var1, RelOptTable var2);
    }

    private static class ValuesFactoryImpl
    implements ValuesFactory {
        private ValuesFactoryImpl() {
        }

        @Override
        public RelNode createValues(RelOptCluster cluster, RelDataType rowType, List<ImmutableList<RexLiteral>> tuples) {
            return LogicalValues.create(cluster, rowType, ImmutableList.copyOf(tuples));
        }
    }

    public static interface ValuesFactory {
        public RelNode createValues(RelOptCluster var1, RelDataType var2, List<ImmutableList<RexLiteral>> var3);
    }

    private static class SemiJoinFactoryImpl
    implements SemiJoinFactory {
        private SemiJoinFactoryImpl() {
        }

        @Override
        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            return SemiJoin.create(left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }

    public static interface SemiJoinFactory {
        public RelNode createSemiJoin(RelNode var1, RelNode var2, RexNode var3);
    }

    private static class CorrelateFactoryImpl
    implements CorrelateFactory {
        private CorrelateFactoryImpl() {
        }

        @Override
        public RelNode createCorrelate(RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
            return LogicalCorrelate.create(left, right, correlationId, requiredColumns, joinType);
        }
    }

    public static interface CorrelateFactory {
        public RelNode createCorrelate(RelNode var1, RelNode var2, CorrelationId var3, ImmutableBitSet var4, SemiJoinType var5);
    }

    private static class JoinFactoryImpl
    implements JoinFactory {
        private JoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone) {
            return LogicalJoin.create(left, right, condition, variablesSet, joinType, semiJoinDone, ImmutableList.of());
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return this.createJoin(left, right, condition, CorrelationId.setOf(variablesStopped), joinType, semiJoinDone);
        }
    }

    public static interface JoinFactory {
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, Set<CorrelationId> var4, JoinRelType var5, boolean var6);

        @Deprecated
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, JoinRelType var4, Set<String> var5, boolean var6);
    }

    private static class FilterFactoryImpl
    implements FilterFactory {
        private FilterFactoryImpl() {
        }

        @Override
        public RelNode createFilter(RelNode input, RexNode condition) {
            return LogicalFilter.create(input, condition);
        }
    }

    public static interface FilterFactory {
        public RelNode createFilter(RelNode var1, RexNode var2);
    }

    private static class AggregateFactoryImpl
    implements AggregateFactory {
        private AggregateFactoryImpl() {
        }

        @Override
        public RelNode createAggregate(RelNode input, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return LogicalAggregate.create(input, indicator, groupSet, groupSets, aggCalls);
        }
    }

    public static interface AggregateFactory {
        public RelNode createAggregate(RelNode var1, boolean var2, ImmutableBitSet var3, ImmutableList<ImmutableBitSet> var4, List<AggregateCall> var5);
    }

    private static class SetOpFactoryImpl
    implements SetOpFactory {
        private SetOpFactoryImpl() {
        }

        @Override
        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            switch (kind) {
                case UNION: {
                    return LogicalUnion.create(inputs, all);
                }
                case EXCEPT: {
                    return LogicalMinus.create(inputs, all);
                }
                case INTERSECT: {
                    return LogicalIntersect.create(inputs, all);
                }
            }
            throw new AssertionError((Object)("not a set op: " + (Object)((Object)kind)));
        }
    }

    public static interface SetOpFactory {
        public RelNode createSetOp(SqlKind var1, List<RelNode> var2, boolean var3);
    }

    private static class SortExchangeFactoryImpl
    implements SortExchangeFactory {
        private SortExchangeFactoryImpl() {
        }

        @Override
        public RelNode createSortExchange(RelNode input, RelDistribution distribution, RelCollation collation) {
            return LogicalSortExchange.create(input, distribution, collation);
        }
    }

    public static interface SortExchangeFactory {
        public RelNode createSortExchange(RelNode var1, RelDistribution var2, RelCollation var3);
    }

    private static class ExchangeFactoryImpl
    implements ExchangeFactory {
        private ExchangeFactoryImpl() {
        }

        @Override
        public RelNode createExchange(RelNode input, RelDistribution distribution) {
            return LogicalExchange.create(input, distribution);
        }
    }

    public static interface ExchangeFactory {
        public RelNode createExchange(RelNode var1, RelDistribution var2);
    }

    private static class SortFactoryImpl
    implements SortFactory {
        private SortFactoryImpl() {
        }

        @Override
        public RelNode createSort(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return LogicalSort.create(input, collation, offset, fetch);
        }

        @Override
        @Deprecated
        public RelNode createSort(RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return this.createSort(input, collation, offset, fetch);
        }
    }

    public static interface SortFactory {
        public RelNode createSort(RelNode var1, RelCollation var2, RexNode var3, RexNode var4);

        @Deprecated
        public RelNode createSort(RelTraitSet var1, RelNode var2, RelCollation var3, RexNode var4, RexNode var5);
    }

    private static class ProjectFactoryImpl
    implements ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode input, List<? extends RexNode> childExprs, List<String> fieldNames) {
            return LogicalProject.create(input, childExprs, fieldNames);
        }
    }

    public static interface ProjectFactory {
        public RelNode createProject(RelNode var1, List<? extends RexNode> var2, List<String> var3);
    }
}

