/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.core;

import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.SingleRel;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexShuttle;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Litmus;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public abstract class Calc
extends SingleRel {
    protected final RexProgram program;

    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program) {
        super(cluster, traits, child);
        this.rowType = program.getOutputRowType();
        this.program = program;
        assert (this.isValid(Litmus.THROW, null));
    }

    @Deprecated
    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traits, child, program);
        Util.discard(collationList);
    }

    @Override
    public final Calc copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Calc.sole(inputs), this.program);
    }

    public abstract Calc copy(RelTraitSet var1, RelNode var2, RexProgram var3);

    @Deprecated
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        Util.discard(collationList);
        return this.copy(traitSet, child, program);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!RelOptUtil.equal("program's input type", this.program.getInputRowType(), "child's output type", this.getInput().getRowType(), litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!this.program.isValid(litmus, context)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!this.program.isNormalized(litmus, this.getCluster().getRexBuilder())) {
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public RexProgram getProgram() {
        return this.program;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this);
        double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.program.explainCalc(super.explainTerms(pw));
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition;
        List<RexNode> oldExprs = this.program.getExprList();
        List<RexNode> exprs = shuttle.apply(oldExprs);
        List<RexLocalRef> oldProjects = this.program.getProjectList();
        List<RexLocalRef> projects = shuttle.apply(oldProjects);
        RexLocalRef oldCondition = this.program.getCondition();
        if (oldCondition != null) {
            condition = shuttle.apply(oldCondition);
            assert (condition instanceof RexLocalRef) : "Invalid condition after rewrite. Expected RexLocalRef, got " + condition;
        } else {
            condition = null;
        }
        if (exprs == oldExprs && projects == oldProjects && condition == oldCondition) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), new RexProgram(this.program.getInputRowType(), exprs, projects, (RexLocalRef)condition, this.program.getOutputRowType()));
    }
}

