/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano;

import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.RelSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.VolcanoRuleCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Litmus;

class VolcanoRuleMatch
extends VolcanoRuleCall {
    private final RelSet targetSet;
    private RelSubset targetSubset;
    private String digest;
    private double cachedImportance = Double.NaN;

    VolcanoRuleMatch(VolcanoPlanner volcanoPlanner, RelOptRuleOperand operand0, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs) {
        super(volcanoPlanner, operand0, (RelNode[])rels.clone(), nodeInputs);
        assert (VolcanoRuleMatch.allNotNull(rels, Litmus.THROW));
        this.targetSet = volcanoPlanner.getSet(rels[0]);
        assert (this.targetSet != null) : rels[0].toString() + " isn't in a set";
        this.digest = this.computeDigest();
    }

    public String toString() {
        return this.digest;
    }

    void clearCachedImportance() {
        this.cachedImportance = Double.NaN;
    }

    double getImportance() {
        if (Double.isNaN(this.cachedImportance)) {
            this.cachedImportance = this.computeImportance();
        }
        return this.cachedImportance;
    }

    double computeImportance() {
        double targetImportance;
        RelSubset targetSubset;
        assert (this.rels[0] != null);
        RelSubset subset = this.volcanoPlanner.getSubset(this.rels[0]);
        double importance = 0.0;
        if (subset != null) {
            importance = this.volcanoPlanner.ruleQueue.getImportance(subset);
        }
        if ((targetSubset = this.guessSubset()) != null && targetSubset != subset && (targetImportance = this.volcanoPlanner.ruleQueue.getImportance(targetSubset)) > importance) {
            importance = targetImportance;
            if (subset == null || subset.bestCost.isLt(targetSubset.bestCost)) {
                // empty if block
            }
        }
        return importance;
    }

    private String computeDigest() {
        StringBuilder buf = new StringBuilder("rule [" + this.getRule() + "] rels [");
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.rels[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public void recomputeDigest() {
        this.digest = this.computeDigest();
    }

    private RelSubset guessSubset() {
        if (this.targetSubset != null) {
            return this.targetSubset;
        }
        RelTrait targetTrait = this.getRule().getOutTrait();
        if (this.targetSet != null && targetTrait != null) {
            RelTraitSet targetTraitSet = this.rels[0].getTraitSet().replace(targetTrait);
            this.targetSubset = this.targetSet.getSubset(targetTraitSet);
            return this.targetSubset;
        }
        return null;
    }

    private static <E> boolean allNotNull(E[] es, Litmus litmus) {
        for (E e : es) {
            if (e != null) continue;
            return litmus.fail("was null", new Object[]{es});
        }
        return litmus.succeed();
    }
}

