/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.schemas.Schema;

@AutoService(value=TableProvider.class)
public class KafkaTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        Schema schema = table.getSchema();
        JSONObject properties = table.getProperties();
        String bootstrapServers = properties.getString("bootstrap.servers");
        JSONArray topicsArr = properties.getJSONArray("topics");
        ArrayList<String> topics = new ArrayList<String>(topicsArr.size());
        for (Object topic : topicsArr) {
            topics.add(topic.toString());
        }
        return new BeamKafkaCSVTable(schema, bootstrapServers, topics);
    }

    @Override
    public String getTableType() {
        return "kafka";
    }
}

