/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.Function;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdfImpl;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.UdfUdafProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;

@Internal
@Experimental
public class BeamSqlEnv {
    JdbcConnection connection;
    QueryPlanner planner;

    private BeamSqlEnv(JdbcConnection connection, QueryPlanner planner) {
        this.connection = connection;
        this.planner = planner;
    }

    public static BeamSqlEnvBuilder builder(TableProvider tableProvider) {
        return new BeamSqlEnvBuilder(tableProvider);
    }

    public static BeamSqlEnv readOnly(String tableType, Map<String, BeamSqlTable> tables) {
        return BeamSqlEnv.withTableProvider(new ReadOnlyTableProvider(tableType, tables));
    }

    public static BeamSqlEnv withTableProvider(TableProvider tableProvider) {
        return BeamSqlEnv.builder(tableProvider).build();
    }

    public static BeamSqlEnv inMemory(TableProvider ... tableProviders) {
        InMemoryMetaStore inMemoryMetaStore = new InMemoryMetaStore();
        for (TableProvider tableProvider : tableProviders) {
            inMemoryMetaStore.registerProvider(tableProvider);
        }
        return BeamSqlEnv.withTableProvider(inMemoryMetaStore);
    }

    public BeamRelNode parseQuery(String query) throws ParseException {
        return this.planner.convertToBeamRel(query);
    }

    public boolean isDdl(String sqlStatement) throws ParseException {
        return this.planner.parse(sqlStatement) instanceof SqlExecutableStatement;
    }

    public void executeDdl(String sqlStatement) throws ParseException {
        SqlExecutableStatement ddl = (SqlExecutableStatement)((Object)this.planner.parse(sqlStatement));
        ddl.execute(this.getContext());
    }

    public CalcitePrepare.Context getContext() {
        return this.connection.createPrepareContext();
    }

    public Map<String, String> getPipelineOptions() {
        return this.connection.getPipelineOptionsMap();
    }

    public String explain(String sqlString) throws ParseException {
        try {
            return RelOptUtil.toString(this.planner.convertToBeamRel(sqlString));
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse statement", e);
        }
    }

    public static class BeamSqlEnvBuilder {
        private static final String CALCITE_PLANNER = "org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner";
        private String queryPlannerClassName;
        private TableProvider defaultTableProvider;
        private String currentSchemaName;
        private Map<String, TableProvider> schemaMap;
        private Set<Map.Entry<String, Function>> functionSet;
        private boolean autoLoadBuiltinFunctions;
        private boolean autoLoadUdfs;

        private BeamSqlEnvBuilder(TableProvider tableProvider) {
            Preconditions.checkNotNull((Object)tableProvider, (Object)"Table provider for the default schema must be sets.");
            this.defaultTableProvider = tableProvider;
            this.queryPlannerClassName = CALCITE_PLANNER;
            this.schemaMap = new HashMap<String, TableProvider>();
            this.functionSet = new HashSet<Map.Entry<String, Function>>();
            this.autoLoadUdfs = false;
            this.autoLoadBuiltinFunctions = false;
        }

        public BeamSqlEnvBuilder addSchema(String name, TableProvider tableProvider) {
            if (this.schemaMap.containsKey(name)) {
                throw new RuntimeException("Schema " + name + " is registered twice.");
            }
            this.schemaMap.put(name, tableProvider);
            return this;
        }

        public BeamSqlEnvBuilder setCurrentSchema(String name) {
            this.currentSchemaName = name;
            return this;
        }

        public BeamSqlEnvBuilder addUdf(String functionName, Class<?> clazz, String method) {
            this.functionSet.add(new AbstractMap.SimpleEntry<String, Function>(functionName, UdfImpl.create(clazz, method)));
            return this;
        }

        public BeamSqlEnvBuilder addUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
            return this.addUdf(functionName, clazz, "eval");
        }

        public BeamSqlEnvBuilder addUdf(String functionName, SerializableFunction sfn) {
            return this.addUdf(functionName, sfn.getClass(), "apply");
        }

        public BeamSqlEnvBuilder addUdaf(String functionName, Combine.CombineFn combineFn) {
            this.functionSet.add(new AbstractMap.SimpleEntry(functionName, new UdafImpl(combineFn)));
            return this;
        }

        public BeamSqlEnvBuilder autoLoadUserDefinedFunctions() {
            this.autoLoadUdfs = true;
            return this;
        }

        public BeamSqlEnvBuilder autoLoadBuiltinFunctions() {
            this.autoLoadBuiltinFunctions = true;
            return this;
        }

        public BeamSqlEnvBuilder setQueryPlannerClassName(String name) {
            this.queryPlannerClassName = name;
            return this;
        }

        public BeamSqlEnv build() {
            JdbcConnection jdbcConnection = JdbcDriver.connect(this.defaultTableProvider);
            this.configureSchemas(jdbcConnection);
            this.loadBeamBuiltinFunctions();
            this.loadUdfs();
            this.addUdfsUdafs(jdbcConnection);
            QueryPlanner planner = this.instantiatePlanner(jdbcConnection);
            return new BeamSqlEnv(jdbcConnection, planner);
        }

        private void configureSchemas(JdbcConnection jdbcConnection) {
            this.schemaMap.forEach(jdbcConnection::setSchema);
            if (Strings.isNullOrEmpty((String)this.currentSchemaName)) {
                return;
            }
            try {
                jdbcConnection.setSchema(this.currentSchemaName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void loadBeamBuiltinFunctions() {
            if (!this.autoLoadBuiltinFunctions) {
                return;
            }
            for (BeamBuiltinFunctionProvider provider : ServiceLoader.load(BeamBuiltinFunctionProvider.class)) {
                this.loadBuiltinUdf(provider.getBuiltinMethods());
            }
        }

        private void loadBuiltinUdf(Map<String, List<Method>> methods) {
            for (Map.Entry<String, List<Method>> entry : methods.entrySet()) {
                for (Method method : entry.getValue()) {
                    this.functionSet.add(new AbstractMap.SimpleEntry<String, Function>(entry.getKey(), UdfImpl.create(method)));
                }
            }
        }

        private void loadUdfs() {
            if (!this.autoLoadUdfs) {
                return;
            }
            ServiceLoader.load(UdfUdafProvider.class).forEach(ins -> {
                ins.getBeamSqlUdfs().forEach(this::addUdf);
                ins.getSerializableFunctionUdfs().forEach(this::addUdf);
                ins.getUdafs().forEach(this::addUdaf);
            });
        }

        private void addUdfsUdafs(JdbcConnection connection) {
            for (Map.Entry<String, Function> functionEntry : this.functionSet) {
                connection.getCurrentSchemaPlus().add(functionEntry.getKey(), functionEntry.getValue());
            }
        }

        private QueryPlanner instantiatePlanner(JdbcConnection jdbcConnection) {
            if (this.queryPlannerClassName.equals(CALCITE_PLANNER)) {
                return new CalciteQueryPlanner(jdbcConnection);
            }
            try {
                return (QueryPlanner)Class.forName(this.queryPlannerClassName).getConstructor(JdbcConnection.class).newInstance(jdbcConnection);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Cannot construct query planner %s", this.queryPlannerClassName), e);
            }
        }
    }
}

