/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rex;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.DataContext;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.config.CalciteSystemProperty;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexExecutable;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgramBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public class RexExecutorImpl
implements RexExecutor {
    private final DataContext dataContext;

    public RexExecutorImpl(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter) {
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelDataType emptyRowType = typeFactory.builder().build();
        return this.compile(rexBuilder, constExps, getter, emptyRowType);
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(rexBuilder.getTypeFactory().getTypeSystem());
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, "root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add(Expressions.declare(16, root_, (Expression)Expressions.convert_(root0_, DataContext.class)));
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        RexProgram program = programBuilder.getProgram();
        List<Expression> expressions = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, blockBuilder, null, root_, getter, null);
        blockBuilder.add(Expressions.return_(null, Expressions.newArrayInit(Object[].class, expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl(1, Object[].class, BuiltInMethod.FUNCTION1_APPLY.method.getName(), ImmutableList.of(root0_), blockBuilder.toBlock());
        String code = Expressions.toString(methodDecl);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, code);
        }
        return code;
    }

    public RexExecutable getExecutable(RexBuilder rexBuilder, List<RexNode> exps, RelDataType rowType) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(rexBuilder.getTypeFactory().getTypeSystem());
        DataContextInputGetter getter = new DataContextInputGetter(rowType, typeFactory);
        String code = this.compile(rexBuilder, exps, getter, rowType);
        return new RexExecutable(code, "generated Rex code");
    }

    @Override
    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        String code = this.compile(rexBuilder, constExps, (list, index, storageType) -> {
            throw new UnsupportedOperationException();
        });
        RexExecutable executable = new RexExecutable(code, constExps);
        executable.setDataContext(this.dataContext);
        executable.reduce(rexBuilder, constExps, reducedValues);
    }

    private static class DataContextInputGetter
    implements RexToLixTranslator.InputGetter {
        private final RelDataTypeFactory typeFactory;
        private final RelDataType rowType;

        DataContextInputGetter(RelDataType rowType, RelDataTypeFactory typeFactory) {
            this.rowType = rowType;
            this.typeFactory = typeFactory;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            MethodCallExpression recFromCtx = Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant("inputRecord"));
            Expression recFromCtxCasted = RexToLixTranslator.convert(recFromCtx, Object[].class);
            IndexExpression recordAccess = Expressions.arrayIndex(recFromCtxCasted, Expressions.constant(index));
            if (storageType == null) {
                RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
                storageType = ((JavaTypeFactory)this.typeFactory).getJavaClass(fieldType);
            }
            return RexToLixTranslator.convert(recordAccess, storageType);
        }
    }
}

