/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.Contexts;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Join;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgramBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Pair;

public class JoinProjectTransposeRule
extends RelOptRule {
    public static final JoinProjectTransposeRule BOTH_PROJECT = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any()), JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any())), "JoinProjectTransposeRule(Project-Project)");
    public static final JoinProjectTransposeRule LEFT_PROJECT = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.some(JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any()), new RelOptRuleOperand[0])), "JoinProjectTransposeRule(Project-Other)");
    public static final JoinProjectTransposeRule RIGHT_PROJECT = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.operand(RelNode.class, JoinProjectTransposeRule.any()), JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any())), "JoinProjectTransposeRule(Other-Project)");
    public static final JoinProjectTransposeRule BOTH_PROJECT_INCLUDE_OUTER = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any()), JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any())), "Join(IncludingOuter)ProjectTransposeRule(Project-Project)", true, RelFactories.LOGICAL_BUILDER);
    public static final JoinProjectTransposeRule LEFT_PROJECT_INCLUDE_OUTER = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.some(JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any()), new RelOptRuleOperand[0])), "Join(IncludingOuter)ProjectTransposeRule(Project-Other)", true, RelFactories.LOGICAL_BUILDER);
    public static final JoinProjectTransposeRule RIGHT_PROJECT_INCLUDE_OUTER = new JoinProjectTransposeRule(JoinProjectTransposeRule.operand(LogicalJoin.class, JoinProjectTransposeRule.operand(RelNode.class, JoinProjectTransposeRule.any()), JoinProjectTransposeRule.operand(LogicalProject.class, JoinProjectTransposeRule.any())), "Join(IncludingOuter)ProjectTransposeRule(Other-Project)", true, RelFactories.LOGICAL_BUILDER);
    private final boolean includeOuter;

    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, boolean includeOuter, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, description);
        this.includeOuter = includeOuter;
    }

    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description) {
        this(operand, description, false, RelFactories.LOGICAL_BUILDER);
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, RelFactories.ProjectFactory projectFactory) {
        this(operand, description, false, RelBuilder.proto(Contexts.of((Object)projectFactory)));
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, boolean includeOuter, RelFactories.ProjectFactory projectFactory) {
        this(operand, description, includeOuter, RelBuilder.proto(Contexts.of((Object)projectFactory)));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinChild;
        Project rightProj;
        Object leftJoinChild;
        Project leftProj;
        Join joinRel = (Join)call.rel(0);
        JoinRelType joinType = joinRel.getJoinType();
        if (this.hasLeftChild(call) && (this.includeOuter || !joinType.generatesNullsOnLeft())) {
            leftProj = (Project)call.rel(1);
            leftJoinChild = this.getProjectChild(call, leftProj, true);
        } else {
            leftProj = null;
            leftJoinChild = call.rel(1);
        }
        if (this.hasRightChild(call) && (this.includeOuter || !joinType.generatesNullsOnRight())) {
            rightProj = this.getRightChild(call);
            rightJoinChild = this.getProjectChild(call, rightProj, false);
        } else {
            rightProj = null;
            rightJoinChild = joinRel.getRight();
        }
        if (leftProj == null && rightProj == null) {
            return;
        }
        RelDataType joinChildrenRowType = SqlValidatorUtil.deriveJoinRowType(leftJoinChild.getRowType(), rightJoinChild.getRowType(), JoinRelType.INNER, joinRel.getCluster().getTypeFactory(), null, Collections.emptyList());
        int nProjExprs = joinRel.getRowType().getFieldCount();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        this.createProjectExprs(leftProj, (RelNode)leftJoinChild, 0, rexBuilder, joinChildrenRowType.getFieldList(), projects);
        List<RelDataTypeField> leftFields = leftJoinChild.getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        this.createProjectExprs(rightProj, rightJoinChild, nFieldsLeft, rexBuilder, joinChildrenRowType.getFieldList(), projects);
        ArrayList<RelDataType> projTypes = new ArrayList<RelDataType>();
        for (int i = 0; i < nProjExprs; ++i) {
            projTypes.add(((RexNode)((Pair)projects.get((int)i)).left).getType());
        }
        RelDataType projRowType = rexBuilder.getTypeFactory().createStructType(projTypes, Pair.right(projects));
        RexProgram bottomProgram = RexProgram.create(joinChildrenRowType, Pair.left(projects), null, projRowType, rexBuilder);
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(projRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(joinRel.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        Join newJoinRel = joinRel.copy(joinRel.getTraitSet(), newCondition, (RelNode)leftJoinChild, rightJoinChild, joinRel.getJoinType(), joinRel.isSemiJoinDone());
        ArrayList<RexNode> newProjExprs = new ArrayList<RexNode>();
        List<RexLocalRef> projList = mergedProgram.getProjectList();
        List<RelDataTypeField> newJoinFields = newJoinRel.getRowType().getFieldList();
        int nJoinFields = newJoinFields.size();
        int[] adjustments = new int[nJoinFields];
        for (int i = 0; i < nProjExprs; ++i) {
            RexNode newExpr = mergedProgram.expandLocalRef(projList.get(i));
            if (joinType != JoinRelType.INNER) {
                newExpr = newExpr.accept(new RelOptUtil.RexInputConverter(rexBuilder, joinChildrenRowType.getFieldList(), newJoinFields, adjustments));
            }
            newProjExprs.add(newExpr);
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newJoinRel);
        relBuilder.project(newProjExprs, joinRel.getRowType().getFieldNames());
        if (joinType != JoinRelType.INNER) {
            relBuilder.convert(joinRel.getRowType(), false);
        }
        call.transformTo(relBuilder.build());
    }

    protected boolean hasLeftChild(RelOptRuleCall call) {
        return call.rel(1) instanceof Project;
    }

    protected boolean hasRightChild(RelOptRuleCall call) {
        return call.rels.length == 3;
    }

    protected Project getRightChild(RelOptRuleCall call) {
        return (Project)call.rel(2);
    }

    protected RelNode getProjectChild(RelOptRuleCall call, Project project, boolean leftChild) {
        return project.getInput();
    }

    protected void createProjectExprs(Project projRel, RelNode joinChild, int adjustmentAmount, RexBuilder rexBuilder, List<RelDataTypeField> joinChildrenFields, List<Pair<RexNode, String>> projects) {
        List<RelDataTypeField> childFields = joinChild.getRowType().getFieldList();
        if (projRel != null) {
            List<Pair<RexNode, String>> namedProjects = projRel.getNamedProjects();
            int nChildFields = childFields.size();
            int[] adjustments = new int[nChildFields];
            for (int i = 0; i < nChildFields; ++i) {
                adjustments[i] = adjustmentAmount;
            }
            for (Pair<RexNode, String> pair : namedProjects) {
                RexNode e = (RexNode)pair.left;
                if (adjustmentAmount != 0) {
                    e = e.accept(new RelOptUtil.RexInputConverter(rexBuilder, childFields, joinChildrenFields, adjustments));
                }
                projects.add(Pair.of(e, pair.right));
            }
        } else {
            for (int i = 0; i < childFields.size(); ++i) {
                RelDataTypeField field = childFields.get(i);
                projects.add(Pair.of(rexBuilder.makeInputRef(field.getType(), i + adjustmentAmount), field.getName()));
            }
        }
    }
}

