/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.Mapping;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.MappingType;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.Mappings;

public class AggregateExtractProjectRule
extends RelOptRule {
    public AggregateExtractProjectRule(Class<? extends Aggregate> aggregateClass, Class<? extends RelNode> inputClass, RelBuilderFactory relBuilderFactory) {
        this(AggregateExtractProjectRule.operand(aggregateClass, AggregateExtractProjectRule.operandJ(inputClass, null, r -> !(r instanceof Project), AggregateExtractProjectRule.any()), new RelOptRuleOperand[0]), relBuilderFactory);
    }

    public AggregateExtractProjectRule(RelOptRuleOperand operand, RelBuilderFactory builderFactory) {
        super(operand, builderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Object input = call.rel(1);
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            for (int i : aggCall.getArgList()) {
                inputFieldsUsed.set(i);
            }
            if (aggCall.filterArg < 0) continue;
            inputFieldsUsed.set(aggCall.filterArg);
        }
        RelBuilder relBuilder = call.builder().push((RelNode)input);
        ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, aggregate.getInput().getRowType().getFieldCount(), inputFieldsUsed.cardinality());
        int j = 0;
        for (int i : inputFieldsUsed.build()) {
            projects.add(relBuilder.field(i));
            mapping.set(i, j++);
        }
        relBuilder.project(projects);
        ImmutableBitSet newGroupSet = Mappings.apply(mapping, aggregate.getGroupSet());
        Iterable newGroupSets = Iterables.transform(aggregate.getGroupSets(), bitSet -> Mappings.apply(mapping, bitSet));
        ArrayList<RelBuilder.AggCall> newAggCallList = new ArrayList<RelBuilder.AggCall>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            ImmutableList<RexNode> args = relBuilder.fields(Mappings.apply2(mapping, aggCall.getArgList()));
            RexInputRef filterArg = aggCall.filterArg < 0 ? null : relBuilder.field(Mappings.apply((Mappings.TargetMapping)mapping, aggCall.filterArg));
            newAggCallList.add(relBuilder.aggregateCall(aggCall.getAggregation(), args).distinct(aggCall.isDistinct()).filter(filterArg).approximate(aggCall.isApproximate()).sort(relBuilder.fields(aggCall.collation)).as(aggCall.name));
        }
        RelBuilder.GroupKey groupKey = relBuilder.groupKey(newGroupSet, newGroupSets);
        relBuilder.aggregate(groupKey, (Iterable<RelBuilder.AggCall>)newAggCallList);
        call.transformTo(relBuilder.build());
    }
}

